/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JpaFileTests
extends ContextModelTestCase {
    public JpaFileTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    public void testGetRootStructureNode() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        IFile file = this.getOrmXmlResource().getFile();
        JpaFile ormXmlJpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((Object)this.getEntityMappings(), ormXmlJpaFile.getRootStructureNodes().iterator().next());
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        this.getEntityMappings().removePersistentType(ormPersistentType);
        JpaFileTests.assertEquals((Object)this.getJavaEntity().getPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
    }

    public void testEntityMappingsRootStructureNodeRemoved() throws Exception {
        IFile file = this.getOrmXmlResource().getFile();
        JpaFile ormXmlJpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((Object)this.getEntityMappings(), ormXmlJpaFile.getRootStructureNodes().iterator().next());
        JpaXmlResource resource = (JpaXmlResource)ormXmlJpaFile.getResourceModel();
        resource.getContents().remove((Object)resource.getRootObject());
        JpaFileTests.assertFalse((boolean)ormXmlJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testImpliedEntityMappingsRootStructureNodeRemoved() throws Exception {
        IFile file = this.getOrmXmlResource().getFile();
        JpaFile ormXmlJpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertNull((Object)this.getPersistenceUnit().getImpliedMappingFileRef());
        this.getXmlPersistenceUnit().getMappingFiles().remove(0);
        JpaFileTests.assertNotNull((Object)this.getPersistenceUnit().getImpliedMappingFileRef());
        JpaFileTests.assertEquals((Object)this.getPersistenceUnit().getImpliedMappingFileRef().getMappingFile().getRoot(), ormXmlJpaFile.getRootStructureNodes().iterator().next());
        JpaXmlResource resource = (JpaXmlResource)ormXmlJpaFile.getResourceModel();
        resource.getContents().remove((Object)resource.getRootObject());
        JpaFileTests.assertFalse((boolean)ormXmlJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testEntityMappingsRootStructureNodeRemovedFromResourceModel() throws Exception {
        IFile file = this.getOrmXmlResource().getFile();
        JpaFile ormXmlJpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((Object)this.getEntityMappings(), ormXmlJpaFile.getRootStructureNodes().iterator().next());
        this.getOrmXmlResource().getContents().remove((Object)this.getOrmXmlResource().getRootObject());
        JpaFileTests.assertFalse((boolean)ormXmlJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testUpdatePersistenceRootStructureNodePersistenceRemoved() throws Exception {
        IFile file = this.getPersistenceXmlResource().getFile();
        JpaFile persistenceXmlJpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((Object)this.getRootContextNode().getPersistenceXml().getPersistence(), persistenceXmlJpaFile.getRootStructureNodes().iterator().next());
        JpaXmlResource resource = (JpaXmlResource)persistenceXmlJpaFile.getResourceModel();
        resource.getContents().remove((Object)resource.getRootObject());
        JpaFileTests.assertFalse((boolean)persistenceXmlJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testUpdateOrmJavaRootStructureNodePersistenceRemoved() throws Exception {
        IFile file = this.getPersistenceXmlResource().getFile();
        JpaFile persistenceXmlJpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        JpaXmlResource resource = (JpaXmlResource)persistenceXmlJpaFile.getResourceModel();
        resource.getContents().remove((Object)resource.getRootObject());
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testUpdateJavaRootStructureNodePersistenceRemoved() throws Exception {
        IFile file = this.getPersistenceXmlResource().getFile();
        JpaFile persistenceXmlJpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)this.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        JpaXmlResource resource = (JpaXmlResource)persistenceXmlJpaFile.getResourceModel();
        resource.getContents().remove((Object)resource.getRootObject());
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testPersistenceRootStructureNodeRemovedFromResourceModel() throws Exception {
        IFile file = this.getPersistenceXmlResource().getFile();
        JpaFile persistenceXmlJpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        this.getRootContextNode().getPersistenceXml().getPersistence();
        JpaFileTests.assertEquals((Object)this.getRootContextNode().getPersistenceXml().getPersistence(), persistenceXmlJpaFile.getRootStructureNodes().iterator().next());
        this.getPersistenceXmlResource().getContents().remove((Object)this.getXmlPersistence());
        JpaFileTests.assertFalse((boolean)persistenceXmlJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testUpdateOrmJavaRootStructureNodePersistenceXmlRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        this.getPersistenceXmlResource().getContents().remove((Object)this.getXmlPersistence());
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testUpdateJavaRootStructureNodePersistenceXmlRemoved() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)this.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        this.getPersistenceXmlResource().getContents().remove((Object)this.getXmlPersistence());
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testOrmJavaPersistentTypeRootStructureNodeRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertTrue((boolean)(((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent() instanceof OrmPersistentType));
        this.getEntityMappings().removePersistentType(0);
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        JpaFileTests.assertTrue((boolean)(((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent() instanceof ClassRef));
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
    }

    public void testOrmJavaPersistentTypeRootStructureNodeRemovedFromResourceModel() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertTrue((boolean)(((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent() instanceof OrmPersistentType));
        this.getXmlEntityMappings().getEntities().remove(0);
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        JpaFileTests.assertTrue((boolean)(((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent() instanceof ClassRef));
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
    }

    public void testJavaPersistentTypeRootStructureNodeRemoved() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().specifiedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent());
        this.getEntityMappings().getPersistenceUnit().removeSpecifiedClassRef(0);
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent());
    }

    public void testJavaPersistentTypeRootStructureNodeRemovedFromResourceModel() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        Iterator rootStructureNodes = javaJpaFile.getRootStructureNodes().iterator();
        JpaStructureNode rootStructureNode = (JpaStructureNode)rootStructureNodes.next();
        JpaFileTests.assertEquals((Object)javaPersistentType, (Object)rootStructureNode);
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().specifiedClassRefs().next(), (Object)rootStructureNode.getParent());
        JpaFileTests.assertFalse((boolean)rootStructureNodes.hasNext());
        this.removeXmlClassRef("test.AnnotationTestType");
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent());
    }

    public void testImpliedJavaPersistentTypeRootStructureNodeRemoved() throws Exception {
        this.getJpaProject().setDiscoversAnnotatedClasses(true);
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ((ClassRef)this.getPersistenceUnit().impliedClassRefs().next()).getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        javaPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testJavaRootStructureNodesEntityMappingsRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.getOrmXmlResource().getContents().remove((Object)this.getXmlEntityMappings());
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        JpaFileTests.assertEquals(this.getPersistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent());
    }

    public void testJavaRootStructureNodesPersistenceUnitRemovedFromResourceModel() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.getXmlPersistence().getPersistenceUnits().remove(0);
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
        JpaFileTests.assertEquals((int)0, (int)javaJpaFile.getRootStructureNodesSize());
    }

    public void testJavaRootStructureNodesPersistenceUnitRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.getJpaProject().getRootContextNode().getPersistenceXml().getPersistence().removePersistenceUnit(0);
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
        JpaFileTests.assertEquals((int)0, (int)javaJpaFile.getRootStructureNodesSize());
    }

    public void testJavaRootStructureNodesOrmPersistentTypeRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.getEntityMappings().removePersistentType(0);
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent());
    }

    public void testJavaRootStructureNodesOrmTypeMappingMorphed() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        ormPersistentType.setMappingKey("embeddable");
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        javaPersistentType = ((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.getEntityMappings().removePersistentType(0);
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent());
    }

    public void testUpdateOrmJavaRootStructureNodeMappingFileRefChanged() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        MappingFileRef mappingFileRef = (MappingFileRef)this.getPersistenceUnit().mappingFileRefs().next();
        mappingFileRef.setFileName("foo");
        ormPersistentType = (OrmPersistentType)((EntityMappings)this.getPersistenceUnit().getImpliedMappingFileRef().getMappingFile().getRoot()).getPersistentTypes().iterator().next();
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        IFile file = this.getPersistenceXmlResource().getFile();
        JpaFile ormXmlJpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        JpaFileTests.assertEquals((int)1, (int)ormXmlJpaFile.getRootStructureNodesSize());
    }

    public void testUpdateJavaRootStructureNodeMappingFileRefChanged() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JpaFileTests.assertEquals((Object)this.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        MappingFileRef mappingFileRef = (MappingFileRef)this.getPersistenceUnit().mappingFileRefs().next();
        mappingFileRef.setFileName("foo");
        JpaFileTests.assertEquals((Object)this.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
    }

    public void testUpdateJavaRootStrucutreNodeDeleteOrmResource() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = JptJpaCorePlugin.getJpaFile((IFile)((IFile)cu.getResource()));
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.deleteResource((Resource)this.getOrmXmlResource());
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        JpaFileTests.assertEquals(this.getPersistenceUnit().impliedClassRefs().next(), (Object)((JpaStructureNode)javaJpaFile.getRootStructureNodes().iterator().next()).getParent());
    }
}

