/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlVersion;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmVersionMappingTests
extends ContextModelTestCase {
    public OrmVersionMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityVersionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Version", "javax.persistence.Column", "javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version");
                sb.append(CR);
                sb.append("    @Column(name=\"MY_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\", length=5, precision=6, scale=7)");
                sb.append(CR);
                sb.append("    @Temporal(TemporalType.TIMESTAMP)");
            }
        });
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "versionMapping");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion versionResource = (XmlVersion)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        OrmVersionMappingTests.assertEquals((String)"versionMapping", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertEquals((String)"versionMapping", (String)versionResource.getName());
        versionResource.setName("newName");
        OrmVersionMappingTests.assertEquals((String)"newName", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertEquals((String)"newName", (String)versionResource.getName());
        versionResource.setName(null);
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getName());
        OrmVersionMappingTests.assertNull((Object)versionResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "versionMapping");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion versionResource = (XmlVersion)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        OrmVersionMappingTests.assertEquals((String)"versionMapping", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertEquals((String)"versionMapping", (String)versionResource.getName());
        ormVersionMapping.setName("newName");
        OrmVersionMappingTests.assertEquals((String)"newName", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertEquals((String)"newName", (String)versionResource.getName());
        ormVersionMapping.setName(null);
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getName());
        OrmVersionMappingTests.assertNull((Object)versionResource.getName());
    }

    public void testUpdateTemporal() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "versionMapping");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion versionResource = (XmlVersion)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        OrmVersionMappingTests.assertNull((Object)versionResource.getTemporal());
        versionResource.setTemporal(TemporalType.DATE);
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((TemporalConverter)ormVersionMapping.getConverter()).getTemporalType());
        OrmVersionMappingTests.assertEquals((Object)TemporalType.DATE, (Object)versionResource.getTemporal());
        versionResource.setTemporal(TemporalType.TIME);
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((TemporalConverter)ormVersionMapping.getConverter()).getTemporalType());
        OrmVersionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)versionResource.getTemporal());
        versionResource.setTemporal(TemporalType.TIMESTAMP);
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)ormVersionMapping.getConverter()).getTemporalType());
        OrmVersionMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)versionResource.getTemporal());
        versionResource.setTemporal(null);
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        OrmVersionMappingTests.assertNull((Object)versionResource.getTemporal());
    }

    public void testModifyTemporal() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "versionMapping");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        XmlVersion versionResource = (XmlVersion)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getVersions().get(0);
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        OrmVersionMappingTests.assertNull((Object)versionResource.getTemporal());
        ormVersionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)ormVersionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.DATE);
        OrmVersionMappingTests.assertEquals((Object)TemporalType.DATE, (Object)versionResource.getTemporal());
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((TemporalConverter)ormVersionMapping.getConverter()).getTemporalType());
        ((TemporalConverter)ormVersionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertEquals((Object)TemporalType.TIME, (Object)versionResource.getTemporal());
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((TemporalConverter)ormVersionMapping.getConverter()).getTemporalType());
        ((TemporalConverter)ormVersionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP);
        OrmVersionMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)versionResource.getTemporal());
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)ormVersionMapping.getConverter()).getTemporalType());
        ormVersionMapping.setConverter(null);
        OrmVersionMappingTests.assertNull((Object)versionResource.getTemporal());
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
    }

    public void testVersionMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedAttribute("version", "foo");
        OrmVersionMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertEquals((String)"foo", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        OrmColumn ormColumn = ormVersionMapping.getColumn();
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmVersionMappingTests.assertEquals((String)"foo", (String)ormColumn.getDefaultName());
        OrmVersionMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmVersionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmVersionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmVersionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmVersionMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmVersionMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        OrmVersionMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        OrmVersionMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmVersionMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertEquals((String)"id", (String)versionMapping.getName());
        OrmVersionMappingTests.assertEquals(TemporalConverter.class, (Object)versionMapping.getConverter().getType());
        OrmVersionMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)versionMapping.getConverter()).getTemporalType());
        Column column = versionMapping.getColumn();
        OrmVersionMappingTests.assertEquals((String)"MY_COLUMN", (String)column.getSpecifiedName());
        OrmVersionMappingTests.assertEquals((Object)Boolean.TRUE, (Object)column.getSpecifiedUnique());
        OrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedNullable());
        OrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedInsertable());
        OrmVersionMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedUpdatable());
        OrmVersionMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)column.getColumnDefinition());
        OrmVersionMappingTests.assertEquals((String)"MY_TABLE", (String)column.getSpecifiedTable());
        OrmVersionMappingTests.assertEquals((Object)5, (Object)column.getSpecifiedLength());
        OrmVersionMappingTests.assertEquals((Object)6, (Object)column.getSpecifiedPrecision());
        OrmVersionMappingTests.assertEquals((Object)7, (Object)column.getSpecifiedScale());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmVersionMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmVersionMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        OrmVersionMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.convertToSpecified("version");
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertEquals((String)"id", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        OrmColumn ormColumn = ormVersionMapping.getColumn();
        OrmVersionMappingTests.assertEquals((String)"id", (String)ormColumn.getName());
        OrmVersionMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmVersionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmVersionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmVersionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getTable());
        OrmVersionMappingTests.assertEquals((int)255, (int)ormColumn.getLength());
        OrmVersionMappingTests.assertEquals((int)0, (int)ormColumn.getPrecision());
        OrmVersionMappingTests.assertEquals((int)0, (int)ormColumn.getScale());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedAttribute("version", "id");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmVersionMapping ormVersionMapping = (OrmVersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertEquals((String)"id", (String)ormVersionMapping.getName());
        OrmVersionMappingTests.assertNull((Object)ormVersionMapping.getConverter().getType());
        OrmColumn ormColumn = ormVersionMapping.getColumn();
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmVersionMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmVersionMappingTests.assertEquals((String)"id", (String)ormColumn.getDefaultName());
        OrmVersionMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmVersionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmVersionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmVersionMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmVersionMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmVersionMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmVersionMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        OrmVersionMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        OrmVersionMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
    }

    public void testVersionMorphToIdMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
        OrmVersionMappingTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testVersionMorphToBasicMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("basic");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
        OrmVersionMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testVersionMorphToTransientMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToOneToOneMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToOne");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToOneToManyMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToManyToOneMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testVersionMorphToManyToManyMapping() throws Exception {
        this.createTestEntityVersionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("version", "version");
        VersionMapping versionMapping = (VersionMapping)ormPersistentAttribute.getMapping();
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        versionMapping.getColumn().setSpecifiedName("FOO");
        versionMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)versionMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmVersionMappingTests.assertFalse((boolean)versionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        OrmVersionMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmVersionMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmVersionMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmVersionMappingTests.assertEquals((String)"version", (String)ormPersistentAttribute.getMapping().getName());
    }
}

