/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaDerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapsId2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaManyToOneMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericJavaManyToOneMapping2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdDerivedIdentity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @Id").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.convertToSpecified();
        }
    }

    public void testUpdateId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceAttribute.removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceAttribute.addAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId");
        annotation.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)annotation.getValue());
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        annotation.setValue("bar");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)annotation.getValue());
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceAttribute.removeAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("foo");
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)annotation);
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)annotation.getValue());
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("bar");
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)annotation.getValue());
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue(null);
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testUpdatePredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        JavaDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceAttribute.addAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testSetPredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        JavaDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setMapsIdDerivedIdentityStrategy();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setNullDerivedIdentityStrategy();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setIdDerivedIdentityStrategy();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setMappingKey("oneToOne");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)((JavaOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)((JavaOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setMappingKey("manyToOne");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setMappingKey("id");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(contextAttribute.getMapping() instanceof JavaIdMapping));
        contextAttribute.setMappingKey("manyToOne");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(contextAttribute.getMapping() instanceof JavaManyToOneMapping2_0));
        contextAttribute.setMappingKey("basic");
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(contextAttribute.getMapping() instanceof JavaBasicMapping));
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping2_0 mapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        ManyToOneRelationship2_0 rel = (ManyToOneRelationship2_0)mapping.getRelationship();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinTable();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping2_0 mapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        ManyToOneRelationship2_0 rel = (ManyToOneRelationship2_0)mapping.getRelationship();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceAttribute.addAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceAttribute.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceAttribute.removeAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceAttribute.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
    }
}

