/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.persistence;

import java.util.ListIterator;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.JpaOptions2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.persistence.Generic2_0PersistenceUnitTests;

public class Generic2_0OptionsTests
extends Generic2_0PersistenceUnitTests {
    private JpaOptions2_0 options;
    private ListChangeEvent prePersistEvent;
    private ListChangeEvent preUpdateEvent;
    private ListChangeEvent preRemoveEvent;
    public static final String LOCK_TIMEOUT_KEY = "javax.persistence.lock.timeout";
    public static final Integer LOCK_TIMEOUT_TEST_VALUE = 100;
    public static final Integer LOCK_TIMEOUT_TEST_VALUE_2 = 200;
    public static final String QUERY_TIMEOUT_KEY = "javax.persistence.query.timeout";
    public static final Integer QUERY_TIMEOUT_TEST_VALUE = 100;
    public static final Integer QUERY_TIMEOUT_TEST_VALUE_2 = 200;
    public static final String VALIDATION_GROUP_PRE_PERSIST_KEY = "javax.persistence.validation.group.pre-persist";
    public static final String VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE = "test_pre-persist_group";
    public static final String VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE_2 = "test_2_pre-persist_group";
    public static final String VALIDATION_GROUP_PRE_UPDATE_KEY = "javax.persistence.validation.group.pre-update";
    public static final String VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE = "test_pre-update_group";
    public static final String VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE_2 = "test_2_pre-update_group";
    public static final String VALIDATION_GROUP_PRE_REMOVE_KEY = "javax.persistence.validation.group.pre-remove";
    public static final String VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE = "test_pre-remove_group";
    public static final String VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE_2 = "test_2_pre-remove_group";

    public Generic2_0OptionsTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.options = (JpaOptions2_0)this.subject.getOptions();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.options.addPropertyChangeListener("lockTimeout", propertyChangeListener);
        this.options.addPropertyChangeListener("queryTimeout", propertyChangeListener);
        this.options.addPropertyChangeListener("validationGroupPrePersist", propertyChangeListener);
        this.options.addPropertyChangeListener("validationGroupPreUpdate", propertyChangeListener);
        this.options.addPropertyChangeListener("validationGroupPreRemove", propertyChangeListener);
        ListChangeListener validationGroupListChangeListener = this.buildValidationGroupListChangeListener();
        this.options.addListChangeListener("validationGroupPrePersists", validationGroupListChangeListener);
        this.options.addListChangeListener("validationGroupPreUpdates", validationGroupListChangeListener);
        this.options.addListChangeListener("validationGroupPreRemoves", validationGroupListChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 5;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 1;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitSetProperty(LOCK_TIMEOUT_KEY, LOCK_TIMEOUT_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(QUERY_TIMEOUT_KEY, QUERY_TIMEOUT_TEST_VALUE.toString());
        this.persistenceUnitSetProperty("misc.property.3", "value.3");
        this.persistenceUnitSetProperty(VALIDATION_GROUP_PRE_PERSIST_KEY, VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE);
        this.persistenceUnitSetProperty(VALIDATION_GROUP_PRE_UPDATE_KEY, VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE);
        this.persistenceUnitSetProperty(VALIDATION_GROUP_PRE_REMOVE_KEY, VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE);
    }

    protected PersistenceUnitProperties getModel() {
        return this.options;
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Integer modelValue = null;
        if (propertyName.equals("lockTimeout")) {
            modelValue = this.options.getLockTimeout();
        } else if (propertyName.equals("queryTimeout")) {
            modelValue = this.options.getQueryTimeout();
        } else if (propertyName.equals("validationGroupPrePersist")) {
            ListIterator iterator = this.options.validationGroupPrePersists();
            modelValue = this.getFirstElement(iterator);
        } else if (propertyName.equals("validationGroupPreUpdate")) {
            ListIterator iterator = this.options.validationGroupPreUpdates();
            modelValue = this.getFirstElement(iterator);
        } else if (propertyName.equals("validationGroupPreRemove")) {
            ListIterator iterator = this.options.validationGroupPreRemoves();
            modelValue = this.getFirstElement(iterator);
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("lockTimeout")) {
            this.options.setLockTimeout((Integer)newValue);
        } else if (propertyName.equals("queryTimeout")) {
            this.options.setQueryTimeout((Integer)newValue);
        } else if (propertyName.equals("validationGroupPrePersist")) {
            this.options.addValidationGroupPrePersist((String)newValue);
        } else if (propertyName.equals("validationGroupPreUpdate")) {
            this.options.addValidationGroupPreUpdate((String)newValue);
        } else if (propertyName.equals("validationGroupPreRemove")) {
            this.options.addValidationGroupPreRemove((String)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    public void testSetLockTimeout() throws Exception {
        this.verifyModelInitialized(LOCK_TIMEOUT_KEY, LOCK_TIMEOUT_TEST_VALUE);
        this.verifySetProperty(LOCK_TIMEOUT_KEY, LOCK_TIMEOUT_TEST_VALUE, LOCK_TIMEOUT_TEST_VALUE_2);
    }

    public void testAddRemoveLockTimeout() throws Exception {
        this.verifyAddRemoveProperty(LOCK_TIMEOUT_KEY, LOCK_TIMEOUT_TEST_VALUE, LOCK_TIMEOUT_TEST_VALUE_2);
    }

    public void testSetQueryTimeout() throws Exception {
        this.verifyModelInitialized(QUERY_TIMEOUT_KEY, QUERY_TIMEOUT_TEST_VALUE);
        this.verifySetProperty(QUERY_TIMEOUT_KEY, QUERY_TIMEOUT_TEST_VALUE, QUERY_TIMEOUT_TEST_VALUE_2);
    }

    public void testAddRemoveQueryTimeout() throws Exception {
        this.verifyAddRemoveProperty(QUERY_TIMEOUT_KEY, QUERY_TIMEOUT_TEST_VALUE, QUERY_TIMEOUT_TEST_VALUE_2);
    }

    public void testSetValidationGroupPrePersist() throws Exception {
        this.verifyModelInitialized(VALIDATION_GROUP_PRE_PERSIST_KEY, VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE);
        this.verifySetValidationGroupProperty("validationGroupPrePersist", VALIDATION_GROUP_PRE_PERSIST_KEY, VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE, VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE_2);
    }

    public void testAddRemoveValidationGroupPrePersist() throws Exception {
        this.verifyAddRemoveValidationGroupProperty("validationGroupPrePersist", VALIDATION_GROUP_PRE_PERSIST_KEY, VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE, VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE_2);
    }

    public void testAddValidationGroupPrePersistCompositeValue() throws Exception {
        this.verifyAddCompositeValue("validationGroupPrePersist", VALIDATION_GROUP_PRE_PERSIST_KEY, VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE, VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE_2);
    }

    public void testRemoveValidationGroupPrePersistCompositeValue() throws Exception {
        this.verifyRemoveCompositeValue("validationGroupPrePersist", VALIDATION_GROUP_PRE_PERSIST_KEY, VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE, VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE_2);
    }

    public void testSetValidationGroupPreUpdate() throws Exception {
        this.verifyModelInitialized(VALIDATION_GROUP_PRE_UPDATE_KEY, VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE);
        this.verifySetValidationGroupProperty("validationGroupPreUpdate", VALIDATION_GROUP_PRE_UPDATE_KEY, VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE, VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE_2);
    }

    public void testAddRemoveValidationGroupPreUpdate() throws Exception {
        this.verifyAddRemoveValidationGroupProperty("validationGroupPreUpdate", VALIDATION_GROUP_PRE_UPDATE_KEY, VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE, VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE_2);
    }

    public void testAddValidationGroupPreUpdateCompositeValue() throws Exception {
        this.verifyAddCompositeValue("validationGroupPreUpdate", VALIDATION_GROUP_PRE_UPDATE_KEY, VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE, VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE_2);
    }

    public void testRemoveValidationGroupPreUpdateCompositeValue() throws Exception {
        this.verifyRemoveCompositeValue("validationGroupPreUpdate", VALIDATION_GROUP_PRE_UPDATE_KEY, VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE, VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE_2);
    }

    public void testSetValidationGroupPreRemove() throws Exception {
        this.verifyModelInitialized(VALIDATION_GROUP_PRE_REMOVE_KEY, VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE);
        this.verifySetValidationGroupProperty("validationGroupPreRemove", VALIDATION_GROUP_PRE_REMOVE_KEY, VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE, VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE_2);
    }

    public void testAddRemoveValidationGroupPreRemove() throws Exception {
        this.verifyAddRemoveValidationGroupProperty("validationGroupPreRemove", VALIDATION_GROUP_PRE_REMOVE_KEY, VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE, VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE_2);
    }

    public void testAddValidationGroupPreRemoveCompositeValue() throws Exception {
        this.verifyAddCompositeValue("validationGroupPreRemove", VALIDATION_GROUP_PRE_REMOVE_KEY, VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE, VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE_2);
    }

    public void testRemoveValidationGroupPreRemoveCompositeValue() throws Exception {
        this.verifyRemoveCompositeValue("validationGroupPreRemove", VALIDATION_GROUP_PRE_REMOVE_KEY, VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE, VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE_2);
    }

    public void testValidationGroupsList() throws Exception {
        this.verifyListEvents("validationGroupPrePersist", VALIDATION_GROUP_PRE_PERSIST_TEST_VALUE_2, "validationGroupPrePersists");
        this.verifyListEvents("validationGroupPreUpdate", VALIDATION_GROUP_PRE_UPDATE_TEST_VALUE_2, "validationGroupPreUpdates");
        this.verifyListEvents("validationGroupPreRemove", VALIDATION_GROUP_PRE_REMOVE_TEST_VALUE_2, "validationGroupPreRemoves");
    }

    protected void clearEvent() {
        super.clearEvent();
        this.prePersistEvent = null;
        this.preUpdateEvent = null;
        this.preRemoveEvent = null;
    }

    protected void verifySetValidationGroupProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        this.persistenceUnitSetProperty(key, testValue2, true);
        ++this.propertiesTotal;
        this.verifyPutValidationGroupProperty(propertyName, testValue1);
    }

    protected void verifyAddRemoveValidationGroupProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        Generic2_0OptionsTests.assertTrue((boolean)this.validationGroupValueExists(propertyName, (String)testValue1));
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.getPersistenceUnit().removeProperty(key, (String)testValue1);
        Generic2_0OptionsTests.assertFalse((boolean)this.validationGroupValueExists(propertyName, (String)testValue1));
        Generic2_0OptionsTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitSetProperty(key, testValue1, true);
        this.verifyPutValidationGroupProperty(propertyName, testValue1);
    }

    protected void verifyAddCompositeValue(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        String stringTestValue1 = (String)testValue1;
        String stringTestValue2 = (String)testValue2;
        Generic2_0OptionsTests.assertTrue((boolean)this.validationGroupValueExists(propertyName, stringTestValue1));
        Generic2_0OptionsTests.assertEquals((int)this.getValidationGroupSize(propertyName), (int)1);
        this.addValidationGroupValue(propertyName, stringTestValue2);
        Generic2_0OptionsTests.assertEquals((int)this.getValidationGroupSize(propertyName), (int)2);
        Generic2_0OptionsTests.assertTrue((boolean)this.validationGroupValueExists(propertyName, stringTestValue1));
        Generic2_0OptionsTests.assertTrue((boolean)this.validationGroupValueExists(propertyName, stringTestValue2));
        String propertyValue = this.getPersistenceUnit().getProperty(key).getValue();
        Generic2_0OptionsTests.assertTrue((propertyValue.indexOf(stringTestValue1) != -1 ? 1 : 0) != 0);
        Generic2_0OptionsTests.assertTrue((propertyValue.indexOf(stringTestValue2) != -1 ? 1 : 0) != 0);
    }

    protected void verifyRemoveCompositeValue(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        String stringTestValue1 = (String)testValue1;
        String stringTestValue2 = (String)testValue2;
        Generic2_0OptionsTests.assertTrue((boolean)this.validationGroupValueExists(propertyName, stringTestValue1));
        Generic2_0OptionsTests.assertEquals((int)this.getValidationGroupSize(propertyName), (int)1);
        this.addValidationGroupValue(propertyName, stringTestValue2);
        Generic2_0OptionsTests.assertEquals((int)this.getValidationGroupSize(propertyName), (int)2);
        this.removeValidationGroupValue(propertyName, stringTestValue2);
        Generic2_0OptionsTests.assertEquals((int)this.getValidationGroupSize(propertyName), (int)1);
        Generic2_0OptionsTests.assertFalse((boolean)this.validationGroupValueExists(propertyName, stringTestValue2));
        String propertyValue = this.getPersistenceUnit().getProperty(key).getValue();
        Generic2_0OptionsTests.assertTrue((propertyValue.indexOf(stringTestValue1) != -1 ? 1 : 0) != 0);
        Generic2_0OptionsTests.assertTrue((propertyValue.indexOf(stringTestValue2) == -1 ? 1 : 0) != 0);
        this.removeValidationGroupValue(propertyName, stringTestValue2);
        Generic2_0OptionsTests.assertEquals((int)this.getValidationGroupSize(propertyName), (int)1);
        this.removeValidationGroupValue(propertyName, stringTestValue1);
        Generic2_0OptionsTests.assertEquals((int)this.getValidationGroupSize(propertyName), (int)0);
        Generic2_0OptionsTests.assertFalse((boolean)this.validationGroupValueExists(propertyName, stringTestValue1));
        Generic2_0OptionsTests.assertNull((Object)this.getPersistenceUnit().getProperty(key));
    }

    protected void verifyListEvents(String propertyName, String testValue, String listName) throws Exception {
        this.clearEvent();
        this.addValidationGroupValue(propertyName, testValue);
        Generic2_0OptionsTests.assertNotNull((String)"No Event Fired.", (Object)this.getEventFor(propertyName));
        Generic2_0OptionsTests.assertEquals((String)"Wrong Event.", (String)this.getEventFor(propertyName).getListName(), (String)listName);
        this.clearEvent();
        this.removeValidationGroupValue(propertyName, testValue);
        Generic2_0OptionsTests.assertNotNull((String)"No Event Fired.", (Object)this.getEventFor(propertyName));
        Generic2_0OptionsTests.assertEquals((String)"Wrong Event.", (String)this.getEventFor(propertyName).getListName(), (String)listName);
    }

    protected void verifyPutValidationGroupProperty(String propertyName, Object expectedValue) throws Exception {
        Generic2_0OptionsTests.assertNotNull((String)"No Event Fired.", (Object)this.getEventFor(propertyName));
        Generic2_0OptionsTests.assertTrue((boolean)this.validationGroupValueExists(propertyName, (String)expectedValue));
    }

    private ListChangeListener buildValidationGroupListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent e) {
                Generic2_0OptionsTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void itemsRemoved(ListRemoveEvent e) {
                Generic2_0OptionsTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void itemsReplaced(ListReplaceEvent e) {
                Generic2_0OptionsTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void itemsMoved(ListMoveEvent e) {
                Generic2_0OptionsTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void listCleared(ListClearEvent e) {
                Generic2_0OptionsTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void listChanged(ListChangeEvent e) {
                Generic2_0OptionsTests.this.validationGroupChanged(e);
            }
        };
    }

    private void validationGroupChanged(ListChangeEvent e) {
        String listName = e.getListName();
        if (listName.equals("validationGroupPrePersists")) {
            this.prePersistEvent = e;
        } else if (listName.equals("validationGroupPreUpdates")) {
            this.preUpdateEvent = e;
        } else if (listName.equals("validationGroupPreRemoves")) {
            this.preRemoveEvent = e;
        } else {
            this.throwUnsupportedOperationException((ListEvent)e);
        }
    }

    private void addValidationGroupValue(String propertyName, String propertyValue) throws NoSuchFieldException {
        if (propertyName.equals("validationGroupPrePersist")) {
            this.options.addValidationGroupPrePersist(propertyValue);
        } else if (propertyName.equals("validationGroupPreUpdate")) {
            this.options.addValidationGroupPreUpdate(propertyValue);
        } else if (propertyName.equals("validationGroupPreRemove")) {
            this.options.addValidationGroupPreRemove(propertyValue);
        } else {
            this.throwMissingDefinition("addValidationGroupValue", propertyName);
        }
    }

    private void removeValidationGroupValue(String propertyName, String propertyValue) throws NoSuchFieldException {
        if (propertyName.equals("validationGroupPrePersist")) {
            this.options.removeValidationGroupPrePersist(propertyValue);
        } else if (propertyName.equals("validationGroupPreUpdate")) {
            this.options.removeValidationGroupPreUpdate(propertyValue);
        } else if (propertyName.equals("validationGroupPreRemove")) {
            this.options.removeValidationGroupPreRemove(propertyValue);
        } else {
            this.throwMissingDefinition("removeValidationGroupValue", propertyName);
        }
    }

    private boolean validationGroupValueExists(String propertyName, String propertyValue) throws NoSuchFieldException {
        boolean result = false;
        if (propertyName.equals("validationGroupPrePersist")) {
            result = this.options.validationGroupPrePersistExists(propertyValue);
        } else if (propertyName.equals("validationGroupPreUpdate")) {
            result = this.options.validationGroupPreUpdateExists(propertyValue);
        } else if (propertyName.equals("validationGroupPreRemove")) {
            result = this.options.validationGroupPreRemoveExists(propertyValue);
        } else {
            this.throwMissingDefinition("verifyValidationGroupValueExists", propertyName);
        }
        return result;
    }

    private int getValidationGroupSize(String propertyName) throws NoSuchFieldException {
        int result = 0;
        if (propertyName.equals("validationGroupPrePersist")) {
            result = this.options.validationGroupPrePersistsSize();
        } else if (propertyName.equals("validationGroupPreUpdate")) {
            result = this.options.validationGroupPreUpdatesSize();
        } else if (propertyName.equals("validationGroupPreRemove")) {
            result = this.options.validationGroupPreRemovesSize();
        } else {
            this.throwMissingDefinition("verifyValidationGroupSize", propertyName);
        }
        return result;
    }

    private ListChangeEvent getEventFor(String propertyName) throws NoSuchFieldException {
        ListChangeEvent event = null;
        if (propertyName.equals("validationGroupPrePersist")) {
            event = this.prePersistEvent;
        } else if (propertyName.equals("validationGroupPreUpdate")) {
            event = this.preUpdateEvent;
        } else if (propertyName.equals("validationGroupPreRemove")) {
            event = this.preRemoveEvent;
        } else {
            this.throwMissingDefinition("getEventFor", propertyName);
        }
        return event;
    }
}

