/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.ManyToOne2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.ManyToOneAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class ManyToOne2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public ManyToOne2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestManyToOne() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToOne"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithFetch() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToOne", "javax.persistence.FetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(fetch = FetchType.EAGER)");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithTargetEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToOne"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(targetEntity = AnnotationTestType.class)");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithOptional() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToOne"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(optional = true)");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToOne", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(cascade = CascadeType.ALL)");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithMultipleCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToOne", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(cascade = {CascadeType.MERGE, CascadeType.REMOVE})");
            }
        });
    }

    private ICompilationUnit createTestManyToOneWithDuplicateCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.ManyToOne", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne(cascade = {CascadeType.MERGE, CascadeType.MERGE})");
            }
        });
    }

    public void testManyToOne() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertNotNull((Object)manyToOne);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)manyToOne.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)manyToOne.getFetch());
        manyToOne.setFetch(FetchType.LAZY);
        ManyToOne2_0AnnotationTests.assertEquals((Object)FetchType.LAZY, (Object)manyToOne.getFetch());
        this.assertSourceContains("@ManyToOne(fetch = LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithFetch();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)manyToOne.getFetch());
        manyToOne.setFetch(null);
        ManyToOne2_0AnnotationTests.assertNull((Object)manyToOne.getFetch());
        this.assertSourceContains("@ManyToOne", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }

    public void testGetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)manyToOne.getTargetEntity());
    }

    public void testSetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)manyToOne.getTargetEntity());
        manyToOne.setTargetEntity("Foo");
        this.assertSourceContains("@ManyToOne(targetEntity = Foo.class)", cu);
    }

    public void testSetTargetEntityNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)manyToOne.getTargetEntity());
        manyToOne.setTargetEntity(null);
        this.assertSourceContains("@ManyToOne", cu);
        this.assertSourceDoesNotContain("targetEntity", cu);
    }

    public void testGetFullyQualifiedTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithTargetEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertEquals((String)"test.AnnotationTestType", (String)manyToOne.getFullyQualifiedTargetEntityClassName());
        manyToOne.setTargetEntity("Foo");
        this.assertSourceContains("@ManyToOne(targetEntity = Foo.class)", cu);
        ManyToOne2_0AnnotationTests.assertEquals((String)"Foo", (String)manyToOne.getTargetEntity());
        ManyToOne2_0AnnotationTests.assertEquals((String)"Foo", (String)manyToOne.getFullyQualifiedTargetEntityClassName());
    }

    public void testGetOptional() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOne.getOptional());
    }

    public void testSetOptional() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOne.getOptional());
        manyToOne.setOptional(Boolean.FALSE);
        ManyToOne2_0AnnotationTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOne.getOptional());
        this.assertSourceContains("@ManyToOne(optional = false)", cu);
    }

    public void testSetOptionalNull() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithOptional();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOne.getOptional());
        manyToOne.setOptional(null);
        ManyToOne2_0AnnotationTests.assertNull((Object)manyToOne.getOptional());
        this.assertSourceContains("@ManyToOne", cu);
        this.assertSourceDoesNotContain("optional", cu);
    }

    public void testSetCascadeAll() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertFalse((boolean)manyToOne.isCascadeAll());
        manyToOne.setCascadeAll(true);
        this.assertSourceContains("@ManyToOne(cascade = ALL)", cu);
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeAll());
    }

    public void testSetCascadeMerge() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertFalse((boolean)manyToOne.isCascadeMerge());
        manyToOne.setCascadeMerge(true);
        this.assertSourceContains("@ManyToOne(cascade = MERGE)", cu);
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeMerge());
    }

    public void testSetCascadePersist() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertFalse((boolean)manyToOne.isCascadePersist());
        manyToOne.setCascadePersist(true);
        this.assertSourceContains("@ManyToOne(cascade = PERSIST)", cu);
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadePersist());
    }

    public void testSetCascadeRemove() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertFalse((boolean)manyToOne.isCascadeRemove());
        manyToOne.setCascadeRemove(true);
        this.assertSourceContains("@ManyToOne(cascade = REMOVE)", cu);
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeRemove());
    }

    public void testSetCascadeRefresh() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertFalse((boolean)manyToOne.isCascadeRefresh());
        manyToOne.setCascadeRefresh(true);
        this.assertSourceContains("@ManyToOne(cascade = REFRESH)", cu);
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeRefresh());
    }

    public void testSetCascadeDetach() throws Exception {
        ICompilationUnit cu = this.createTestManyToOne();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOne2_0Annotation manyToOne = (ManyToOne2_0Annotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertFalse((boolean)manyToOne.isCascadeDetach());
        manyToOne.setCascadeDetach(true);
        this.assertSourceContains("@ManyToOne(cascade = DETACH)", cu);
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeDetach());
    }

    public void testCascadeMoreThanOnce() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeAll());
        manyToOne.setCascadeAll(true);
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeAll());
        this.assertSourceContains("@ManyToOne(cascade = CascadeType.ALL)", cu);
        manyToOne.setCascadeAll(false);
        ManyToOne2_0AnnotationTests.assertFalse((boolean)manyToOne.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
        manyToOne.setCascadeAll(false);
        ManyToOne2_0AnnotationTests.assertFalse((boolean)manyToOne.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testDuplicateCascade() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithDuplicateCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeMerge());
        manyToOne.setCascadeMerge(false);
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeMerge());
        manyToOne.setCascadeMerge(false);
        ManyToOne2_0AnnotationTests.assertFalse((boolean)manyToOne.isCascadeMerge());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testMultipleCascade() throws Exception {
        ICompilationUnit cu = this.createTestManyToOneWithMultipleCascade();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getAnnotation("javax.persistence.ManyToOne");
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeMerge());
        ManyToOne2_0AnnotationTests.assertTrue((boolean)manyToOne.isCascadeRemove());
        manyToOne.setCascadeMerge(false);
        this.assertSourceContains("@ManyToOne(cascade = REMOVE)", cu);
        manyToOne.setCascadeRemove(false);
        this.assertSourceDoesNotContain("cascade", cu);
    }
}

