/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.MappedSuperclassAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class MappedSuperclassTests
extends JpaJavaResourceModelTestCase {
    public MappedSuperclassTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassAndEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
                sb.append("@Entity");
            }
        });
    }

    public void testMappedSuperclass() throws Exception {
        ICompilationUnit cu = this.createTestMappedSuperclass();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        Annotation mappingAnnotation = typeResource.getAnnotation("javax.persistence.MappedSuperclass");
        MappedSuperclassTests.assertTrue((boolean)(mappingAnnotation instanceof MappedSuperclassAnnotation));
    }

    public void testMappedSuperclassAndEntity() throws Exception {
        ICompilationUnit cu = this.createTestMappedSuperclassAndEntity();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        Annotation mappingAnnotation = typeResource.getAnnotation("javax.persistence.Entity");
        MappedSuperclassTests.assertTrue((boolean)(mappingAnnotation instanceof EntityAnnotation));
        MappedSuperclassAnnotation mappedSuperclass = (MappedSuperclassAnnotation)typeResource.getAnnotation("javax.persistence.MappedSuperclass");
        MappedSuperclassTests.assertNotNull((Object)mappedSuperclass);
    }
}

