/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.SimpleJavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeTests
extends TestCase {
    public JavaTypeTests(String name) {
        super(name);
    }

    public void testInvalidElementTypeNull() throws Exception {
        boolean exCaught = false;
        try {
            SimpleJavaType javaType = new SimpleJavaType(null, 0);
            JavaTypeTests.fail((String)("invalid JavaType: " + javaType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JavaTypeTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidElementTypeEmpty() throws Exception {
        boolean exCaught = false;
        try {
            SimpleJavaType javaType = new SimpleJavaType("", 0);
            JavaTypeTests.fail((String)("invalid JavaType: " + javaType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JavaTypeTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidElementTypeArray() throws Exception {
        boolean exCaught = false;
        try {
            SimpleJavaType javaType = new SimpleJavaType(Object[].class.getName(), 0);
            JavaTypeTests.fail((String)("invalid JavaType: " + javaType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JavaTypeTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidArrayDepthNegative() throws Exception {
        boolean exCaught = false;
        try {
            SimpleJavaType javaType = new SimpleJavaType(Object.class.getName(), -2);
            JavaTypeTests.fail((String)("invalid JavaType: " + javaType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JavaTypeTests.assertTrue((boolean)exCaught);
    }

    public void testInvalidVoidArray() throws Exception {
        boolean exCaught = false;
        try {
            SimpleJavaType javaType = new SimpleJavaType(Void.TYPE.getName(), 2);
            JavaTypeTests.fail((String)("invalid JavaType: " + javaType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        JavaTypeTests.assertTrue((boolean)exCaught);
    }

    public void testElementTypeName() throws Exception {
        SimpleJavaType javaType = new SimpleJavaType(Object.class);
        JavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getElementTypeName());
        javaType = new SimpleJavaType(Object[].class);
        JavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getElementTypeName());
        javaType = new SimpleJavaType(Integer.TYPE);
        JavaTypeTests.assertEquals((String)"int", (String)javaType.getElementTypeName());
        javaType = new SimpleJavaType(int[].class);
        JavaTypeTests.assertEquals((String)"int", (String)javaType.getElementTypeName());
        javaType = new SimpleJavaType(Void.TYPE);
        JavaTypeTests.assertEquals((String)"void", (String)javaType.getElementTypeName());
        javaType = new SimpleJavaType(Map.Entry.class);
        JavaTypeTests.assertEquals((String)"java.util.Map$Entry", (String)javaType.getElementTypeName());
        javaType = new SimpleJavaType(Map.Entry[][].class);
        JavaTypeTests.assertEquals((String)"java.util.Map$Entry", (String)javaType.getElementTypeName());
    }

    public void testArrayDepth() throws Exception {
        SimpleJavaType javaType = new SimpleJavaType(Object.class);
        JavaTypeTests.assertEquals((int)0, (int)javaType.getArrayDepth());
        javaType = new SimpleJavaType(Object[].class);
        JavaTypeTests.assertEquals((int)1, (int)javaType.getArrayDepth());
        javaType = new SimpleJavaType(Integer.TYPE);
        JavaTypeTests.assertEquals((int)0, (int)javaType.getArrayDepth());
        javaType = new SimpleJavaType(int[].class);
        JavaTypeTests.assertEquals((int)1, (int)javaType.getArrayDepth());
        javaType = new SimpleJavaType(Void.TYPE);
        JavaTypeTests.assertEquals((int)0, (int)javaType.getArrayDepth());
        javaType = new SimpleJavaType(Map.Entry.class);
        JavaTypeTests.assertEquals((int)0, (int)javaType.getArrayDepth());
        javaType = new SimpleJavaType(Map.Entry[][].class);
        JavaTypeTests.assertEquals((int)2, (int)javaType.getArrayDepth());
    }

    public void testIsArray() throws Exception {
        SimpleJavaType javaType = new SimpleJavaType(Object.class);
        JavaTypeTests.assertFalse((boolean)javaType.isArray());
        javaType = new SimpleJavaType(Object[].class);
        JavaTypeTests.assertTrue((boolean)javaType.isArray());
        javaType = new SimpleJavaType(Integer.TYPE);
        JavaTypeTests.assertFalse((boolean)javaType.isArray());
        javaType = new SimpleJavaType(int[].class);
        JavaTypeTests.assertTrue((boolean)javaType.isArray());
        javaType = new SimpleJavaType(Void.TYPE);
        JavaTypeTests.assertFalse((boolean)javaType.isArray());
        javaType = new SimpleJavaType(Map.Entry.class);
        JavaTypeTests.assertFalse((boolean)javaType.isArray());
        javaType = new SimpleJavaType(Map.Entry[][].class);
        JavaTypeTests.assertTrue((boolean)javaType.isArray());
    }

    public void testJavaClass() throws Exception {
        this.verifyJavaClass(Object.class);
        this.verifyJavaClass(Object[].class);
        this.verifyJavaClass(Integer.TYPE);
        this.verifyJavaClass(int[].class);
        this.verifyJavaClass(Void.TYPE);
        this.verifyJavaClass(Map.Entry.class);
        this.verifyJavaClass(Map.Entry[][].class);
    }

    private void verifyJavaClass(Class<?> javaClass) throws Exception {
        SimpleJavaType javaType = new SimpleJavaType(javaClass);
        JavaTypeTests.assertEquals(javaClass, (Object)javaType.getJavaClass());
    }

    public void testJavaClassName() throws Exception {
        SimpleJavaType javaType = new SimpleJavaType(Object.class);
        JavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getJavaClassName());
        javaType = new SimpleJavaType(Object[].class);
        JavaTypeTests.assertEquals((String)"[Ljava.lang.Object;", (String)javaType.getJavaClassName());
        javaType = new SimpleJavaType(Integer.TYPE);
        JavaTypeTests.assertEquals((String)"int", (String)javaType.getJavaClassName());
        javaType = new SimpleJavaType(int[].class);
        JavaTypeTests.assertEquals((String)"[I", (String)javaType.getJavaClassName());
        javaType = new SimpleJavaType(Void.TYPE);
        JavaTypeTests.assertEquals((String)"void", (String)javaType.getJavaClassName());
        javaType = new SimpleJavaType(Map.Entry.class);
        JavaTypeTests.assertEquals((String)"java.util.Map$Entry", (String)javaType.getJavaClassName());
        javaType = new SimpleJavaType(Map.Entry[][].class);
        JavaTypeTests.assertEquals((String)"[[Ljava.util.Map$Entry;", (String)javaType.getJavaClassName());
    }

    public void testDescribes() throws Exception {
        this.verifyDescribes(Object.class);
        this.verifyDescribes(Object[].class);
        this.verifyDescribes(Integer.TYPE);
        this.verifyDescribes(int[].class);
        this.verifyDescribes(Void.TYPE);
        this.verifyDescribes(Map.Entry.class);
        this.verifyDescribes(Map.Entry[][].class);
    }

    private void verifyDescribes(Class<?> javaClass) throws Exception {
        SimpleJavaType javaType = new SimpleJavaType(javaClass);
        JavaTypeTests.assertTrue((boolean)javaType.describes(javaClass));
    }

    public void testDeclaration() throws Exception {
        SimpleJavaType javaType = new SimpleJavaType(Object.class);
        JavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.declaration());
        javaType = new SimpleJavaType(Object[].class);
        JavaTypeTests.assertEquals((String)"java.lang.Object[]", (String)javaType.declaration());
        javaType = new SimpleJavaType(Integer.TYPE);
        JavaTypeTests.assertEquals((String)"int", (String)javaType.declaration());
        javaType = new SimpleJavaType(int[].class);
        JavaTypeTests.assertEquals((String)"int[]", (String)javaType.declaration());
        javaType = new SimpleJavaType(Void.TYPE);
        JavaTypeTests.assertEquals((String)"void", (String)javaType.declaration());
        javaType = new SimpleJavaType(Map.Entry.class);
        JavaTypeTests.assertEquals((String)"java.util.Map.Entry", (String)javaType.declaration());
        javaType = new SimpleJavaType(Map.Entry[][].class);
        JavaTypeTests.assertEquals((String)"java.util.Map.Entry[][]", (String)javaType.declaration());
    }

    public void testIsPrimitive() throws Exception {
        SimpleJavaType javaType = new SimpleJavaType(Object.class);
        JavaTypeTests.assertFalse((boolean)javaType.isPrimitive());
        javaType = new SimpleJavaType(Object[].class);
        JavaTypeTests.assertFalse((boolean)javaType.isPrimitive());
        javaType = new SimpleJavaType(Integer.TYPE);
        JavaTypeTests.assertTrue((boolean)javaType.isPrimitive());
        javaType = new SimpleJavaType(int[].class);
        JavaTypeTests.assertFalse((boolean)javaType.isPrimitive());
        javaType = new SimpleJavaType(Void.TYPE);
        JavaTypeTests.assertTrue((boolean)javaType.isPrimitive());
        javaType = new SimpleJavaType(Map.Entry.class);
        JavaTypeTests.assertFalse((boolean)javaType.isPrimitive());
        javaType = new SimpleJavaType(Map.Entry[][].class);
        JavaTypeTests.assertFalse((boolean)javaType.isPrimitive());
    }
}

