/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.KeyedSet;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedSetTests
extends TestCase {
    private KeyedSet<String, String> nicknames;

    public KeyedSetTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.nicknames = this.buildNicknames();
    }

    private KeyedSet<String, String> buildNicknames() {
        KeyedSet ks = new KeyedSet();
        ks.addItem((Object)"Jimmy", (Object)"James Sullivan");
        ks.addKey((Object)"Sully", (Object)"James Sullivan");
        ks.addItem((Object)"Bob", (Object)"Robert McKenna");
        ks.addKey((Object)"Mac", (Object)"Robert McKenna");
        return ks;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testAddItem() {
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsItem((Object)"James Sullivan"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsItem((Object)"Robert McKenna"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.containsItem((Object)"John Teasdale"));
        this.nicknames.addItem((Object)"Jack", (Object)"John Teasdale");
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsItem((Object)"John Teasdale"));
        this.nicknames.addItem((Object)"Teaser", (Object)"John Teasdale");
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsItem((Object)"John Teasdale"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Teaser"));
    }

    public void testAddKey() {
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Jimmy"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Sully"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Bob"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Mac"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.containsKey((Object)"Robbie"));
        this.nicknames.addKey((Object)"Robbie", (Object)"Robert McKenna");
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Robbie"));
        boolean exceptionCaught = false;
        try {
            this.nicknames.addKey((Object)"Teaser", (Object)"John Teasdale");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionCaught = true;
        }
        KeyedSetTests.assertTrue((boolean)exceptionCaught);
    }

    public void testGetItem() {
        KeyedSetTests.assertEquals((String)((String)this.nicknames.getItem((Object)"Jimmy")), (String)"James Sullivan");
        KeyedSetTests.assertEquals((String)((String)this.nicknames.getItem((Object)"Sully")), (String)"James Sullivan");
        KeyedSetTests.assertEquals((String)((String)this.nicknames.getItem((Object)"Bob")), (String)"Robert McKenna");
        KeyedSetTests.assertEquals((String)((String)this.nicknames.getItem((Object)"Mac")), (String)"Robert McKenna");
        KeyedSetTests.assertNull((Object)this.nicknames.getItem((Object)"Jack"));
    }

    public void testRemoveItem() {
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsItem((Object)"James Sullivan"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Jimmy"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Sully"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.removeItem((Object)"James Sullivan"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.containsItem((Object)"James Sullivan"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.containsKey((Object)"Jimmy"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.containsKey((Object)"Sully"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.removeItem((Object)"William Goldberg"));
    }

    public void testRemoveKey() {
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsItem((Object)"James Sullivan"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Jimmy"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Sully"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.removeKey((Object)"Jimmy"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsItem((Object)"James Sullivan"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.containsKey((Object)"Jimmy"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.containsKey((Object)"Sully"));
        KeyedSetTests.assertTrue((boolean)this.nicknames.removeKey((Object)"Sully"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.containsItem((Object)"James Sullivan"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.containsKey((Object)"Jimmy"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.containsKey((Object)"Sully"));
        KeyedSetTests.assertFalse((boolean)this.nicknames.removeKey((Object)"Billy"));
    }
}

