/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterables;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterableTests
extends TestCase {
    public ArrayIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        int i = 1;
        for (String string : this.buildIterable()) {
            ArrayIterableTests.assertEquals((int)i++, (int)Integer.parseInt(string));
        }
    }

    public void testSubIterator() {
        int i = 3;
        for (String string : this.buildIterable(2)) {
            ArrayIterableTests.assertEquals((int)i++, (int)Integer.parseInt(string));
        }
    }

    public void testIllegalArgumentException() {
        this.triggerIllegalArgumentException(-1, 1);
        this.triggerIllegalArgumentException(8, 1);
        this.triggerIllegalArgumentException(0, -1);
        this.triggerIllegalArgumentException(0, 9);
    }

    private void triggerIllegalArgumentException(int start, int length) {
        boolean exCaught = false;
        try {
            Iterable<String> iterable = this.buildIterable(start, length);
            ArrayIterableTests.fail((String)("bogus iterable: " + iterable));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayIterableTests.assertTrue((boolean)exCaught);
    }

    private Iterable<String> buildIterable() {
        return this.buildIterable(0);
    }

    private Iterable<String> buildIterable(int start) {
        return this.buildIterable(this.buildArray(), start);
    }

    private Iterable<String> buildIterable(String[] array, int start) {
        return new ArrayIterable((Object[])array, start);
    }

    private Iterable<String> buildIterable(int start, int length) {
        return this.buildIterable(this.buildArray(), start, length);
    }

    private Iterable<String> buildIterable(String[] array, int start, int length) {
        return new ArrayIterable((Object[])array, start, length);
    }

    private String[] buildArray() {
        return new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
    }
}

