/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterables;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;

public class CompositeIterableTests
extends TestCase {
    public CompositeIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("4");
        c2.add("5");
        c2.add("6");
        c2.add("7");
        CompositeIterable composite = new CompositeIterable(new Iterable[]{c1, c2});
        int i = 0;
        for (String s : composite) {
            CompositeIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testExtraElement1() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        CompositeIterable composite = new CompositeIterable(c1, (Object)"4");
        int i = 0;
        for (String s : composite) {
            CompositeIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testExtraElement2() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("1");
        c1.add("2");
        c1.add("3");
        CompositeIterable composite = new CompositeIterable((Object)"0", c1);
        int i = 0;
        for (String s : composite) {
            CompositeIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testCollectionOfIterables() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("4");
        c2.add("5");
        c2.add("6");
        c2.add("7");
        ArrayList<ArrayList<String>> collection = new ArrayList<ArrayList<String>>();
        collection.add(c1);
        collection.add(c2);
        CompositeIterable composite = new CompositeIterable(collection);
        int i = 0;
        for (String s : composite) {
            CompositeIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testToString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("4");
        c2.add("5");
        c2.add("6");
        c2.add("7");
        CompositeIterable composite = new CompositeIterable(new Iterable[]{c1, c2});
        CompositeIterableTests.assertNotNull((Object)composite.toString());
    }
}

