/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterables;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIterableTests
extends TestCase {
    private static final String PREFIX = "prefix";

    public FilteringIterableTests(String name) {
        super(name);
    }

    public void testAccept() {
        int i = 0;
        for (String s : this.buildIterable()) {
            FilteringIterableTests.assertTrue((boolean)s.contains(PREFIX));
            ++i;
        }
        FilteringIterableTests.assertEquals((int)6, (int)i);
    }

    public void testFilter() {
        Filter<String> filter = this.buildFilter();
        int i = 0;
        for (String s : new FilteringIterable(this.buildNestedIterable(), filter)) {
            FilteringIterableTests.assertTrue((boolean)s.contains(PREFIX));
            ++i;
        }
        FilteringIterableTests.assertEquals((int)6, (int)i);
    }

    public void testToString() {
        FilteringIterableTests.assertNotNull((Object)this.buildIterable().toString());
    }

    public void testMissingFilter() {
        boolean exCaught = false;
        FilteringIterable iterable = new FilteringIterable(this.buildNestedIterable());
        try {
            Iterator iterator = iterable.iterator();
            FilteringIterableTests.fail((String)("bogus iterator: " + iterator));
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        FilteringIterableTests.assertTrue((boolean)exCaught);
    }

    private Iterable<String> buildIterable() {
        return this.buildFilteringIterable(this.buildNestedIterable());
    }

    private Iterable<String> buildFilteringIterable(Iterable<String> nestedIterable) {
        return new FilteringIterable<String>(nestedIterable){

            protected boolean accept(String s) {
                return s.startsWith(FilteringIterableTests.PREFIX);
            }
        };
    }

    private Filter<String> buildFilter() {
        return new Filter<String>(){

            public boolean accept(String s) {
                return s.startsWith(FilteringIterableTests.PREFIX);
            }
        };
    }

    private Iterable<String> buildNestedIterable() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("prefix1");
        c.add("prefix2");
        c.add("prefix3");
        c.add("4");
        c.add("prefix5");
        c.add("prefix6");
        c.add("prefix7");
        c.add("8");
        return c;
    }
}

