/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ComboBoxModelAdapter;
import org.eclipse.jpt.common.utility.internal.swing.FilteringListBrowser;
import org.eclipse.jpt.common.utility.internal.swing.ListChooser;
import org.eclipse.jpt.common.utility.internal.swing.SimpleListCellRenderer;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxModelAdapterUITest {
    protected JFrame window;
    private TestModel testModel;
    private WritablePropertyValueModel<TestModel> testModelHolder;
    private WritablePropertyValueModel<Object> colorHolder;
    private SimpleListValueModel<String> colorListHolder;
    protected ComboBoxModel colorComboBoxModel;
    private int nextColorNumber = 0;

    public static void main(String[] args) throws Exception {
        new ComboBoxModelAdapterUITest().exec();
    }

    protected ComboBoxModelAdapterUITest() {
    }

    protected void exec() throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        this.testModel = this.buildTestModel();
        this.testModelHolder = new SimplePropertyValueModel((Object)this.testModel);
        this.colorHolder = this.buildColorHolder((PropertyValueModel<TestModel>)this.testModelHolder);
        this.colorListHolder = this.buildColorListHolder();
        this.colorComboBoxModel = this.buildComboBoxModelAdapter((ListValueModel<String>)this.colorListHolder, this.colorHolder);
        this.openWindow();
    }

    private WritablePropertyValueModel<Object> buildColorHolder(PropertyValueModel<TestModel> vm) {
        return new PropertyAspectAdapter<TestModel, Object>(vm, new String[]{"color"}){

            protected String buildValue_() {
                return ((TestModel)((Object)this.subject)).getColor();
            }

            protected void setValue_(Object value) {
                ((TestModel)((Object)this.subject)).setColor((String)value);
            }
        };
    }

    protected TestModel buildTestModel() {
        return new TestModel();
    }

    private SimpleListValueModel<String> buildColorListHolder() {
        return new SimpleListValueModel(TestModel.validColors());
    }

    protected ListValueModel<String> uiColorListHolder() {
        return this.colorListHolder;
    }

    private ComboBoxModel buildComboBoxModelAdapter(ListValueModel<String> listHolder, WritablePropertyValueModel<Object> selectionHolder) {
        return new ComboBoxModelAdapter(listHolder, selectionHolder);
    }

    private void openWindow() {
        this.window = new JFrame(this.getClass().getSimpleName());
        this.window.setDefaultCloseOperation(0);
        this.window.addWindowListener(this.buildWindowListener());
        this.window.getContentPane().add(this.buildMainPanel(), "Center");
        this.window.setLocation(300, 300);
        this.window.setSize(400, 150);
        this.window.setVisible(true);
    }

    private WindowListener buildWindowListener() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
                System.exit(0);
            }
        };
    }

    private Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.buildComboBoxPanel(), "North");
        mainPanel.add(this.buildControlPanel(), "South");
        return mainPanel;
    }

    protected JPanel buildComboBoxPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 0));
        panel.add(this.buildComboBox());
        panel.add(this.buildComboBox());
        panel.add((Component)this.buildListChooser1());
        panel.add((Component)this.buildListChooser2());
        return panel;
    }

    private JComboBox buildComboBox() {
        JComboBox comboBox = new JComboBox(this.colorComboBoxModel);
        comboBox.setRenderer(this.buildComboBoxRenderer());
        return comboBox;
    }

    protected ListCellRenderer buildComboBoxRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                return super.buildText(value);
            }
        };
    }

    private ListChooser buildListChooser1() {
        return new LocalListChooser1(this.colorComboBoxModel);
    }

    private ListChooser buildListChooser2() {
        return new LocalListChooser2(this.colorComboBoxModel);
    }

    private Component buildControlPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(2, 0));
        controlPanel.add(this.buildResetColorButton());
        controlPanel.add(this.buildClearModelButton());
        controlPanel.add(this.buildRestoreModelButton());
        controlPanel.add(this.buildPrintModelButton());
        controlPanel.add(this.buildAddTenButton());
        controlPanel.add(this.buildRemoveTenButton());
        return controlPanel;
    }

    private JButton buildResetColorButton() {
        return new JButton(this.buildResetColorAction());
    }

    private Action buildResetColorAction() {
        AbstractAction action = new AbstractAction("reset color"){

            public void actionPerformed(ActionEvent event) {
                ComboBoxModelAdapterUITest.this.resetColor();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void resetColor() {
        this.testModel.setColor("red");
    }

    private JButton buildClearModelButton() {
        return new JButton(this.buildClearModelAction());
    }

    private Action buildClearModelAction() {
        AbstractAction action = new AbstractAction("clear model"){

            public void actionPerformed(ActionEvent event) {
                ComboBoxModelAdapterUITest.this.clearModel();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void clearModel() {
        this.testModelHolder.setValue(null);
    }

    private JButton buildRestoreModelButton() {
        return new JButton(this.buildRestoreModelAction());
    }

    private Action buildRestoreModelAction() {
        AbstractAction action = new AbstractAction("restore model"){

            public void actionPerformed(ActionEvent event) {
                ComboBoxModelAdapterUITest.this.restoreModel();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void restoreModel() {
        this.testModelHolder.setValue((Object)this.testModel);
    }

    private JButton buildPrintModelButton() {
        return new JButton(this.buildPrintModelAction());
    }

    private Action buildPrintModelAction() {
        AbstractAction action = new AbstractAction("print model"){

            public void actionPerformed(ActionEvent event) {
                ComboBoxModelAdapterUITest.this.printModel();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void printModel() {
        System.out.println((Object)this.testModel);
    }

    private JButton buildAddTenButton() {
        return new JButton(this.buildAddTenAction());
    }

    private Action buildAddTenAction() {
        AbstractAction action = new AbstractAction("add 20"){

            public void actionPerformed(ActionEvent event) {
                ComboBoxModelAdapterUITest.this.addTen();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void addTen() {
        int i = this.nextColorNumber;
        while (i < this.nextColorNumber + 20) {
            this.colorListHolder.add(this.colorListHolder.size(), (Object)("color" + i));
            ++i;
        }
        this.nextColorNumber += 20;
    }

    private JButton buildRemoveTenButton() {
        return new JButton(this.buildRemoveTenAction());
    }

    private Action buildRemoveTenAction() {
        AbstractAction action = new AbstractAction("remove 20"){

            public void actionPerformed(ActionEvent event) {
                ComboBoxModelAdapterUITest.this.removeTen();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void removeTen() {
        int i = 0;
        while (i < 20) {
            if (this.colorListHolder.size() > 0) {
                this.colorListHolder.remove(this.colorListHolder.size() - 1);
            }
            ++i;
        }
    }

    private class LocalListChooser1
    extends ListChooser {
        public LocalListChooser1(ComboBoxModel model) {
            super(model);
        }
    }

    private class LocalListChooser2
    extends ListChooser {
        public LocalListChooser2(ComboBoxModel model) {
            super(model);
        }

        protected ListChooser.ListBrowser buildBrowser() {
            return new FilteringListBrowser();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TestModel
    extends AbstractModel {
        private String color;
        public static final String COLOR_PROPERTY = "color";
        public static final String RED = "red";
        public static final String ORANGE = "orange";
        public static final String YELLOW = "yellow";
        public static final String GREEN = "green";
        public static final String BLUE = "blue";
        public static final String INDIGO = "indigo";
        public static final String VIOLET = "violet";
        public static final String DEFAULT_COLOR = "red";
        public static List<String> validColors;
        public static final String[] DEFAULT_VALID_COLORS;

        static {
            DEFAULT_VALID_COLORS = new String[]{"red", ORANGE, YELLOW, GREEN, BLUE, INDIGO, VIOLET};
        }

        public static List<String> validColors() {
            if (validColors == null) {
                validColors = TestModel.buildDefaultValidColors();
            }
            return validColors;
        }

        public static List<String> buildDefaultValidColors() {
            ArrayList<String> result = new ArrayList<String>();
            CollectionTools.addAll(result, (Object[])DEFAULT_VALID_COLORS);
            return result;
        }

        public TestModel() {
            this("red");
        }

        public TestModel(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.checkColor(color);
            String old = this.color;
            this.color = color;
            this.firePropertyChanged(COLOR_PROPERTY, old, color);
        }

        public void checkColor(String c) {
            if (!TestModel.validColors().contains(c)) {
                throw new IllegalArgumentException(c);
            }
        }

        public String toString() {
            return "TestModel(" + this.color + ")";
        }
    }
}

