/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentClass;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentEnum;
import org.eclipse.jpt.jaxb.core.context.JaxbRegistry;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericContextRootTests
extends JaxbContextModelTestCase {
    public GenericContextRootTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithAccessorOrder() throws CoreException {
        return this.createTestPackageInfo("@XmlAccessorOrder(value = XmlAccessOrder.ALPHABETICAL)", new String[]{"javax.xml.bind.annotation.XmlAccessOrder", "javax.xml.bind.annotation.XmlAccessorOrder"});
    }

    private ICompilationUnit createAnnotatedPersistentClassWithSuperclassNamed(final String superclassName) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends " + superclassName);
            }
        });
    }

    private ICompilationUnit createAnnotatedPersistentClassWithAttributeAndTypeNamed(final String attributeName, final String typeName) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("public " + typeName + " " + attributeName + ";" + CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createAnnotatedPersistentClassWithAttributeAndElementTypeNamed(final String attributeName, final String typeName) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"java.util.List", "javax.xml.bind.annotation.XmlType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("public List<" + typeName + "> " + attributeName + ";" + CR);
                sb.append(CR);
            }
        });
    }

    public void testGetPackages() throws Exception {
        this.createPackageInfoWithAccessorOrder();
        Iterator packages = this.getContextRoot().getPackages().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertEquals((String)"test", (String)((JaxbPackage)packages.next()).getName());
        GenericContextRootTests.assertFalse((boolean)packages.hasNext());
        this.createUnannotatedPackageInfo("foo");
        packages = this.getContextRoot().getPackages().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertEquals((String)"test", (String)((JaxbPackage)packages.next()).getName());
        GenericContextRootTests.assertFalse((boolean)packages.hasNext());
        JavaResourcePackage fooResourcePackage = this.getJaxbProject().getJavaResourcePackage("foo");
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addXmlAccessorTypeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
            }
        });
        TransformationIterable<JaxbPackage, String> packageNames = new TransformationIterable<JaxbPackage, String>(this.getContextRoot().getPackages()){

            protected String transform(JaxbPackage o) {
                return o.getName();
            }
        };
        GenericContextRootTests.assertEquals((int)2, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertTrue((boolean)CollectionTools.contains((Iterable)packageNames, (Object)"test"));
        GenericContextRootTests.assertTrue((boolean)CollectionTools.contains((Iterable)packageNames, (Object)"foo"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeXmlAccessorTypeAnnotation(declaration);
            }
        });
        packages = this.getContextRoot().getPackages().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)this.getContextRoot().getPackagesSize());
        GenericContextRootTests.assertEquals((String)"test", (String)((JaxbPackage)packages.next()).getName());
        GenericContextRootTests.assertFalse((boolean)packages.hasNext());
    }

    protected void addXmlAccessorTypeAnnotation(ModifiedDeclaration declaration, String accessType) {
        NormalAnnotation annotation = this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAccessorType");
        this.addEnumMemberValuePair(annotation, "value", accessType);
    }

    protected void removeXmlAccessorTypeAnnotation(ModifiedDeclaration declaration) {
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessorType");
    }

    protected void addXmlSeeAlsoAnnotation(final ModifiedDeclaration declaration, String ... typeNames) {
        Annotation annotation = declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlSeeAlso");
        NormalAnnotation normalAnnotation = null;
        normalAnnotation = annotation == null ? this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSeeAlso") : (annotation.isMarkerAnnotation() ? this.replaceMarkerAnnotation((MarkerAnnotation)annotation) : (NormalAnnotation)annotation);
        ArrayInitializer arrayInitializer = this.newArrayInitializer(declaration.getAst(), (Expression[])ArrayTools.array((Iterable)new TransformationIterable<String, TypeLiteral>((Iterable)new ArrayIterable((Object[])typeNames)){

            protected TypeLiteral transform(String o) {
                return GenericContextRootTests.this.newTypeLiteral(declaration.getAst(), o);
            }
        }, (Object[])new Expression[0]));
        this.addMemberValuePair(normalAnnotation, "value", (Expression)arrayInitializer);
    }

    public void testGetRegistries() throws Exception {
        this.createAnnotatedRegistry();
        Iterator registries = this.getContextRoot().getRegistries().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getRegistries()));
        GenericContextRootTests.assertEquals((String)"test.AnnotationTestType", (String)((JaxbRegistry)registries.next()).getFullyQualifiedName());
        GenericContextRootTests.assertFalse((boolean)registries.hasNext());
        this.createUnannotatedClassNamed("Foo");
        registries = this.getContextRoot().getRegistries().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getRegistries()));
        GenericContextRootTests.assertEquals((String)"test.AnnotationTestType", (String)((JaxbRegistry)registries.next()).getFullyQualifiedName());
        GenericContextRootTests.assertFalse((boolean)registries.hasNext());
        JavaResourceAbstractType fooResourceType = this.getJaxbProject().getJavaResourceType("test.Foo");
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlRegistry");
            }
        });
        TransformationIterable<JaxbRegistry, String> registryNames = new TransformationIterable<JaxbRegistry, String>(this.getContextRoot().getRegistries()){

            protected String transform(JaxbRegistry o) {
                return o.getFullyQualifiedName();
            }
        };
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getRegistries()));
        GenericContextRootTests.assertTrue((boolean)CollectionTools.contains((Iterable)registryNames, (Object)"test.Foo"));
        GenericContextRootTests.assertTrue((boolean)CollectionTools.contains((Iterable)registryNames, (Object)"test.AnnotationTestType"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRegistry");
            }
        });
        registries = this.getContextRoot().getRegistries().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getRegistries()));
        GenericContextRootTests.assertEquals((String)"test.AnnotationTestType", (String)((JaxbRegistry)registries.next()).getFullyQualifiedName());
        GenericContextRootTests.assertFalse((boolean)registries.hasNext());
    }

    public void testGetPersistentClasses() throws Exception {
        this.createAnnotatedPersistentClass();
        Iterator persistentClasses = this.getContextRoot().getPersistentClasses().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertEquals((String)"test.AnnotationTestType", (String)((JaxbPersistentClass)persistentClasses.next()).getFullyQualifiedName());
        GenericContextRootTests.assertFalse((boolean)persistentClasses.hasNext());
        this.createUnannotatedClassNamed("Foo");
        persistentClasses = this.getContextRoot().getPersistentClasses().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertEquals((String)"test.AnnotationTestType", (String)((JaxbPersistentClass)persistentClasses.next()).getFullyQualifiedName());
        GenericContextRootTests.assertFalse((boolean)persistentClasses.hasNext());
        JavaResourceAbstractType fooResourceType = this.getJaxbProject().getJavaResourceType("test.Foo");
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
            }
        });
        TransformationIterable<JaxbPersistentClass, String> persistentClassNames = new TransformationIterable<JaxbPersistentClass, String>(this.getContextRoot().getPersistentClasses()){

            protected String transform(JaxbPersistentClass o) {
                return o.getFullyQualifiedName();
            }
        };
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertTrue((boolean)CollectionTools.contains((Iterable)persistentClassNames, (Object)"test.Foo"));
        GenericContextRootTests.assertTrue((boolean)CollectionTools.contains((Iterable)persistentClassNames, (Object)"test.AnnotationTestType"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlType");
            }
        });
        persistentClasses = this.getContextRoot().getPersistentClasses().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertEquals((String)"test.AnnotationTestType", (String)((JaxbPersistentClass)persistentClasses.next()).getFullyQualifiedName());
        GenericContextRootTests.assertFalse((boolean)persistentClasses.hasNext());
    }

    public void testGetPersistentEnums() throws Exception {
        this.createAnnotatedPersistentEnum();
        Iterator persistentEnums = this.getContextRoot().getPersistentEnums().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentEnums()));
        GenericContextRootTests.assertEquals((String)"test.AnnotationTestType", (String)((JaxbPersistentEnum)persistentEnums.next()).getFullyQualifiedName());
        GenericContextRootTests.assertFalse((boolean)persistentEnums.hasNext());
        this.createUnannotatedEnumNamed("Foo");
        persistentEnums = this.getContextRoot().getPersistentEnums().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentEnums()));
        GenericContextRootTests.assertEquals((String)"test.AnnotationTestType", (String)((JaxbPersistentEnum)persistentEnums.next()).getFullyQualifiedName());
        GenericContextRootTests.assertFalse((boolean)persistentEnums.hasNext());
        JavaResourceEnum fooResourceType = (JavaResourceEnum)this.getJaxbProject().getJavaResourceType("test.Foo", JavaResourceAbstractType.Kind.ENUM);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
            }
        });
        TransformationIterable<JaxbPersistentEnum, String> persistentEnumNames = new TransformationIterable<JaxbPersistentEnum, String>(this.getContextRoot().getPersistentEnums()){

            protected String transform(JaxbPersistentEnum o) {
                return o.getFullyQualifiedName();
            }
        };
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentEnums()));
        GenericContextRootTests.assertTrue((boolean)CollectionTools.contains((Iterable)persistentEnumNames, (Object)"test.Foo"));
        GenericContextRootTests.assertTrue((boolean)CollectionTools.contains((Iterable)persistentEnumNames, (Object)"test.AnnotationTestType"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlType");
            }
        });
        persistentEnums = this.getContextRoot().getPersistentEnums().iterator();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentEnums()));
        GenericContextRootTests.assertEquals((String)"test.AnnotationTestType", (String)((JaxbPersistentEnum)persistentEnums.next()).getFullyQualifiedName());
        GenericContextRootTests.assertFalse((boolean)persistentEnums.hasNext());
    }

    public void testChangeTypeKind() throws Exception {
        this.createAnnotatedRegistry();
        this.createUnannotatedClassNamed("Foo");
        JavaResourceAbstractType fooResourceType = this.getJaxbProject().getJavaResourceType("test.Foo");
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)fooResourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlRegistry");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)this.getContextRoot().getTypesSize());
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getRegistries()));
        GenericContextRootTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRegistry");
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)this.getContextRoot().getTypesSize());
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getRegistries()));
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlType");
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlRegistry");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)this.getContextRoot().getTypesSize());
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getRegistries()));
        GenericContextRootTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
    }

    public void testDirectReferencedSuperclass() throws Exception {
        String superclassName = "SuperAnnotationTestType";
        String fqSuperclassName = "test." + superclassName;
        this.createUnannotatedClassNamed(superclassName);
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getPersistentClasses()));
        this.createAnnotatedPersistentClassWithSuperclassNamed(superclassName);
        Iterable persistentClasses = this.getContextRoot().getPersistentClasses();
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)persistentClasses));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass(fqSuperclassName));
        IFile file = (IFile)this.getContextRoot().getPersistentClass("test.AnnotationTestType").getResource();
        file.delete(true, null);
        persistentClasses = this.getContextRoot().getPersistentClasses();
        GenericContextRootTests.assertEquals((int)0, (int)CollectionTools.size((Iterable)persistentClasses));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getPersistentClass(fqSuperclassName));
    }

    public void testDirectReferencedAttribute() throws Exception {
        String otherClassName = "OtherAnnotationTestType";
        String fqOtherClassName = "test." + otherClassName;
        String attributeName = "other";
        this.createUnannotatedClassNamed(otherClassName);
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getPersistentClasses()));
        this.createAnnotatedPersistentClassWithAttributeAndTypeNamed(attributeName, otherClassName);
        JavaResourceType thisType = (JavaResourceType)this.getJaxbProject().getJavaResourceType("test.AnnotationTestType");
        JavaResourceAttribute attribute = this.getFieldNamed(thisType, attributeName);
        AnnotatedElement annotatedAttribute = this.annotatedElement((JavaResourceAnnotatedElement)attribute);
        Iterable persistentClasses = this.getContextRoot().getPersistentClasses();
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)persistentClasses));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElement");
            }
        });
        persistentClasses = this.getContextRoot().getPersistentClasses();
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)persistentClasses));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElement");
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlTransient");
            }
        });
        persistentClasses = this.getContextRoot().getPersistentClasses();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)persistentClasses));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getPersistentClass(fqOtherClassName));
    }

    public void testDirectReferencedListAttribute() throws Exception {
        String otherClassName = "OtherAnnotationTestType";
        String fqOtherClassName = "test." + otherClassName;
        String attributeName = "other";
        this.createUnannotatedClassNamed(otherClassName);
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getPersistentClasses()));
        this.createAnnotatedPersistentClassWithAttributeAndElementTypeNamed(attributeName, otherClassName);
        JavaResourceType thisType = (JavaResourceType)this.getJaxbProject().getJavaResourceType("test.AnnotationTestType");
        JavaResourceAttribute attribute = this.getFieldNamed(thisType, attributeName);
        AnnotatedElement annotatedAttribute = this.annotatedElement((JavaResourceAnnotatedElement)attribute);
        Iterable persistentClasses = this.getContextRoot().getPersistentClasses();
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)persistentClasses));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElement");
            }
        });
        persistentClasses = this.getContextRoot().getPersistentClasses();
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)persistentClasses));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass(fqOtherClassName));
        annotatedAttribute.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElement");
                GenericContextRootTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlTransient");
            }
        });
        persistentClasses = this.getContextRoot().getPersistentClasses();
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)persistentClasses));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNull((Object)this.getContextRoot().getPersistentClass(fqOtherClassName));
    }

    public void testDirectReferencedSeeAlso() throws Exception {
        this.createUnannotatedClassNamed("OtherAnnotationTestType");
        this.createUnannotatedClassNamed("OtherAnnotationTestType2");
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getPersistentClasses()));
        this.createAnnotatedPersistentClass();
        JavaResourceType thisType = (JavaResourceType)this.getJaxbProject().getJavaResourceType("test.AnnotationTestType");
        AnnotatedElement annotatedType = this.annotatedElement((JavaResourceAnnotatedElement)thisType);
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        annotatedType.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.addXmlSeeAlsoAnnotation(declaration, "OtherAnnotationTestType");
            }
        });
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.OtherAnnotationTestType"));
        annotatedType.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSeeAlso");
                GenericContextRootTests.this.addXmlSeeAlsoAnnotation(declaration, "OtherAnnotationTestType", "OtherAnnotationTestType2");
            }
        });
        GenericContextRootTests.assertEquals((int)3, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.OtherAnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.OtherAnnotationTestType2"));
        annotatedType.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericContextRootTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSeeAlso");
            }
        });
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
    }

    public void testJaxbIndex() throws Exception {
        this.createUnannotatedClassNamed("OtherAnnotationTestType");
        this.createUnannotatedClassNamed("OtherAnnotationTestType2");
        GenericContextRootTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)this.getContextRoot().getPersistentClasses()));
        this.createAnnotatedPersistentClass();
        JavaResourceType thisType = (JavaResourceType)this.getJaxbProject().getJavaResourceType("test.AnnotationTestType");
        this.annotatedElement((JavaResourceAnnotatedElement)thisType);
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        IFile jaxbIndex = this.getJavaProject().getProject().getFile((IPath)new Path("src/test/jaxb.index"));
        ByteArrayInputStream stream = new ByteArrayInputStream("OtherAnnotationTestType".getBytes());
        jaxbIndex.create((InputStream)stream, true, null);
        GenericContextRootTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.OtherAnnotationTestType"));
        jaxbIndex.setContents((InputStream)new ByteArrayInputStream(("OtherAnnotationTestType" + CR + "OtherAnnotationTestType2").getBytes()), true, false, null);
        GenericContextRootTests.assertEquals((int)3, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.OtherAnnotationTestType"));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.OtherAnnotationTestType2"));
        jaxbIndex.setContents((InputStream)new ByteArrayInputStream(new byte[0]), true, false, null);
        GenericContextRootTests.assertEquals((int)1, (int)CollectionTools.size((Iterable)this.getContextRoot().getPersistentClasses()));
        GenericContextRootTests.assertNotNull((Object)this.getContextRoot().getPersistentClass("test.AnnotationTestType"));
    }
}

