/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaPackageXmlJavaTypeAdapterTests
extends JaxbContextModelTestCase {
    public GenericJavaPackageXmlJavaTypeAdapterTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithXmlJavaTypeAdapter() throws CoreException {
        return this.createTestPackageInfo("@XmlJavaTypeAdapter", new String[]{"javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"});
    }

    public void testModifyValue() throws Exception {
        this.createPackageInfoWithXmlJavaTypeAdapter();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)CollectionTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = (XmlJavaTypeAdapter)contextPackageInfo.getXmlJavaTypeAdapters().iterator().next();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getValue());
        contextXmlJavaTypeAdapter.setValue("foo");
        XmlJavaTypeAdapterAnnotation javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaPackageXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)javaTypeAdapterAnnotation.getValue());
        GenericJavaPackageXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)contextXmlJavaTypeAdapter.getValue());
        contextXmlJavaTypeAdapter.setValue(null);
        javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)javaTypeAdapterAnnotation.getValue());
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getValue());
    }

    public void testUpdateValue() throws Exception {
        this.createPackageInfoWithXmlJavaTypeAdapter();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)CollectionTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = (XmlJavaTypeAdapter)contextPackageInfo.getXmlJavaTypeAdapters().iterator().next();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageXmlJavaTypeAdapterTests.this.addXmlJavaTypeAdapterTypeMemberValuePair(declaration, "value", "String");
            }
        });
        GenericJavaPackageXmlJavaTypeAdapterTests.assertEquals((String)"String", (String)contextXmlJavaTypeAdapter.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageXmlJavaTypeAdapterTests.this.removeXmlJavaTypeAdapterAnnotation(declaration);
            }
        });
        GenericJavaPackageXmlJavaTypeAdapterTests.assertFalse((boolean)contextPackageInfo.getXmlJavaTypeAdapters().iterator().hasNext());
    }

    public void testModifyType() throws Exception {
        this.createPackageInfoWithXmlJavaTypeAdapter();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)CollectionTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = (XmlJavaTypeAdapter)contextPackageInfo.getXmlJavaTypeAdapters().iterator().next();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getType());
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getDefaultType());
        contextXmlJavaTypeAdapter.setSpecifiedType("foo");
        XmlJavaTypeAdapterAnnotation javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaPackageXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)javaTypeAdapterAnnotation.getType());
        GenericJavaPackageXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)contextXmlJavaTypeAdapter.getType());
        contextXmlJavaTypeAdapter.setSpecifiedType(null);
        javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)javaTypeAdapterAnnotation.getType());
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getType());
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getDefaultType());
    }

    public void testUpdateType() throws Exception {
        this.createPackageInfoWithXmlJavaTypeAdapter();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)CollectionTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = (XmlJavaTypeAdapter)contextPackageInfo.getXmlJavaTypeAdapters().iterator().next();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getType());
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaPackageXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getDefaultType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageXmlJavaTypeAdapterTests.this.addXmlJavaTypeAdapterTypeMemberValuePair(declaration, "type", "String");
            }
        });
        GenericJavaPackageXmlJavaTypeAdapterTests.assertEquals((String)"String", (String)contextXmlJavaTypeAdapter.getType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageXmlJavaTypeAdapterTests.this.removeXmlJavaTypeAdapterAnnotation(declaration);
            }
        });
        GenericJavaPackageXmlJavaTypeAdapterTests.assertFalse((boolean)contextPackageInfo.getXmlJavaTypeAdapters().iterator().hasNext());
    }

    protected void addXmlJavaTypeAdapterTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlJavaTypeAdapterAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected void addXmlJavaTypeAdapterMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlJavaTypeAdapterAnnotation(declaration), name, value);
    }

    protected void removeXmlJavaTypeAdapterAnnotation(ModifiedDeclaration declaration) {
        this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAccessorOrder");
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }

    protected Annotation getXmlJavaTypeAdapterAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }
}

