/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentClass;
import org.eclipse.jpt.jaxb.core.context.XmlAnyElementMapping;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementMapping;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAnyElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlMixedAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlAnyElementMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlAnyElementMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlAnyElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAnyElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAnyElement");
            }
        });
    }

    public void testChangeMappingType() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlAnyElementMapping xmlAnyElementMapping = (XmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlAnyElementMapping);
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement"));
        persistentAttribute.setMappingKey("xml-attribute");
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement"));
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-any-element");
        xmlAnyElementMapping = (XmlAnyElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlAnyElementMapping);
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement"));
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-element");
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlElementMapping);
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement"));
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        persistentAttribute.setMappingKey("xml-any-element");
        xmlAnyElementMapping = (XmlAnyElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlAnyElementMapping);
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement"));
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlAnyElementMapping xmlAnyElementMapping = (XmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyElementMapping.getParent().getJavaResourceAttribute();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        xmlAnyElementMapping.addXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlAnyElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        xmlAnyElementMapping.removeXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlAnyElementMapping xmlAnyElementMapping = (XmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyElementMapping.getParent().getJavaResourceAttribute();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlAnyElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
    }

    public void testModifyLax() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlAnyElementMapping xmlAnyElementMapping = (XmlAnyElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)xmlAnyElementMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)xmlAnyElementMapping.isLax());
        xmlAnyElementMapping.setSpecifiedLax(Boolean.TRUE);
        XmlAnyElementAnnotation xmlAnyElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        GenericJavaXmlAnyElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAnyElementAnnotation.getLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAnyElementMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)xmlAnyElementMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)true, (boolean)xmlAnyElementMapping.isLax());
        xmlAnyElementMapping.setSpecifiedLax(null);
        xmlAnyElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)xmlAnyElementMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)xmlAnyElementMapping.isLax());
    }

    public void testUpdateLax() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlAnyElementMapping xmlAnyElementMapping = (XmlAnyElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)xmlAnyElementMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)xmlAnyElementMapping.isLax());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.addXmlAnyElementMemberValuePair(declaration, "lax", true);
            }
        });
        GenericJavaXmlAnyElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAnyElementMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)xmlAnyElementMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)true, (boolean)xmlAnyElementMapping.isLax());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlAnyElementMappingTests.this.getXmlAnyElementAnnotation(declaration);
                GenericJavaXmlAnyElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getSpecifiedLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)xmlAnyElementMapping.isDefaultLax());
        GenericJavaXmlAnyElementMappingTests.assertEquals((boolean)false, (boolean)xmlAnyElementMapping.isLax());
    }

    public void testModifyValue() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlAnyElementMapping xmlAnyElementMapping = (XmlAnyElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getSpecifiedValue());
        xmlAnyElementMapping.setSpecifiedValue("Foo");
        XmlAnyElementAnnotation xmlElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"Foo", (String)xmlAnyElementMapping.getSpecifiedValue());
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"Foo", (String)xmlAnyElementMapping.getValue());
        xmlAnyElementMapping.setSpecifiedValue(null);
        xmlElementAnnotation = (XmlAnyElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyElement");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlElementAnnotation.getValue());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getSpecifiedValue());
    }

    public void testUpdateValue() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlAnyElementMapping xmlAnyElementMapping = (XmlAnyElementMapping)((JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyElementMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getSpecifiedValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.addXmlAnyElementTypeMemberValuePair(declaration, "value", "Foo");
            }
        });
        GenericJavaXmlAnyElementMappingTests.assertEquals((String)"Foo", (String)xmlAnyElementMapping.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlAnyElementMappingTests.this.getXmlAnyElementAnnotation(declaration);
                GenericJavaXmlAnyElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getSpecifiedValue());
    }

    protected void addXmlAnyElementMemberValuePair(ModifiedDeclaration declaration, String name, boolean value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlAnyElementAnnotation(declaration), name, value);
    }

    protected void addXmlAnyElementTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlAnyElementAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected Annotation getXmlAnyElementAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlAnyElement");
    }

    public void testModifyXmlMixed() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlAnyElementMapping xmlAnyElementMapping = (XmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyElementMapping.getParent().getJavaResourceAttribute();
        XmlMixedAnnotation xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getXmlMixed());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlListAnnotation);
        xmlAnyElementMapping.addXmlMixed();
        xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlAnyElementMapping.getXmlMixed());
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlListAnnotation);
        xmlAnyElementMapping.removeXmlMixed();
        xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
    }

    public void testUpdateXmlMixed() throws Exception {
        this.createTypeWithXmlAnyElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlAnyElementMapping xmlAnyElementMapping = (XmlAnyElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyElementMapping.getParent().getJavaResourceAttribute();
        XmlMixedAnnotation xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getXmlMixed());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlListAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlMixed");
            }
        });
        xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlAnyElementMapping.getXmlMixed());
        GenericJavaXmlAnyElementMappingTests.assertNotNull((Object)xmlListAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlMixed");
            }
        });
        xmlListAnnotation = (XmlMixedAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMixed");
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlAnyElementMapping.getXmlMixed());
        GenericJavaXmlAnyElementMappingTests.assertNull((Object)xmlListAnnotation);
    }
}

