/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.beans.Introspector;
import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentClass;
import org.eclipse.jpt.jaxb.core.context.XmlRootElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlRootElementTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlRootElementTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlTypeWithXmlRootElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlRootElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
                sb.append("@XmlRootElement").append(CR);
            }
        });
    }

    public void testModifyNamespace() throws Exception {
        this.createTypeWithXmlTypeWithXmlRootElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlRootElement contextRootElement = persistentClass.getRootElement();
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getSpecifiedNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"", (String)contextRootElement.getDefaultNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"", (String)contextRootElement.getNamespace());
        contextRootElement.setSpecifiedNamespace("foo");
        XmlRootElementAnnotation rootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)rootElementAnnotation.getNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getSpecifiedNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getNamespace());
        contextRootElement.setSpecifiedNamespace(null);
        rootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaXmlRootElementTests.assertNull((Object)rootElementAnnotation.getNamespace());
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getSpecifiedNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"", (String)contextRootElement.getNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createTypeWithXmlTypeWithXmlRootElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlRootElement contextRootElement = persistentClass.getRootElement();
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getSpecifiedNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"", (String)contextRootElement.getDefaultNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"", (String)contextRootElement.getNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlRootElementTests.this.addXmlRootElementMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getSpecifiedNamespace());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlRootElementTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRootElement");
            }
        });
        contextRootElement = persistentClass.getRootElement();
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement);
    }

    public void testModifyName() throws Exception {
        this.createTypeWithXmlTypeWithXmlRootElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlRootElement contextRootElement = persistentClass.getRootElement();
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        String defaultName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getSpecifiedName());
        GenericJavaXmlRootElementTests.assertEquals((String)defaultName, (String)contextRootElement.getDefaultName());
        GenericJavaXmlRootElementTests.assertEquals((String)defaultName, (String)contextRootElement.getName());
        contextRootElement.setSpecifiedName("foo");
        XmlRootElementAnnotation rootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)rootElementAnnotation.getName());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getSpecifiedName());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getName());
        contextRootElement.setSpecifiedName(null);
        rootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaXmlRootElementTests.assertNull((Object)rootElementAnnotation.getName());
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getSpecifiedName());
        GenericJavaXmlRootElementTests.assertEquals((String)defaultName, (String)contextRootElement.getName());
    }

    public void testUpdateName() throws Exception {
        this.createTypeWithXmlTypeWithXmlRootElement();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        XmlRootElement contextRootElement = persistentClass.getRootElement();
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        String defaultName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement.getSpecifiedName());
        GenericJavaXmlRootElementTests.assertEquals((String)defaultName, (String)contextRootElement.getDefaultName());
        GenericJavaXmlRootElementTests.assertEquals((String)defaultName, (String)contextRootElement.getName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlRootElementTests.this.addXmlRootElementMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getSpecifiedName());
        GenericJavaXmlRootElementTests.assertEquals((String)"foo", (String)contextRootElement.getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlRootElementTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRootElement");
            }
        });
        contextRootElement = persistentClass.getRootElement();
        GenericJavaXmlRootElementTests.assertNull((Object)contextRootElement);
    }

    protected void addXmlRootElementMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlRootElementAnnotation(declaration), name, value);
    }

    protected Annotation getXmlRootElementAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlRootElement");
    }
}

