/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorOrderAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlAccessorOrderPackageAnnotationTests
extends JaxbJavaResourceModelTestCase {
    public XmlAccessorOrderPackageAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithAccessorOrder() throws CoreException {
        return this.createTestPackageInfo("@XmlAccessorOrder(XmlAccessOrder.UNDEFINED)", new String[]{"javax.xml.bind.annotation.XmlAccessOrder", "javax.xml.bind.annotation.XmlAccessorOrder"});
    }

    public void testValue() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithAccessorOrder();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        XmlAccessorOrderAnnotation annotation = (XmlAccessorOrderAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        XmlAccessorOrderPackageAnnotationTests.assertNotNull((Object)annotation);
        XmlAccessorOrderPackageAnnotationTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)annotation.getValue());
        annotation.setValue(XmlAccessOrder.ALPHABETICAL);
        XmlAccessorOrderPackageAnnotationTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)annotation.getValue());
        this.assertSourceContains("@XmlAccessorOrder(ALPHABETICAL)", cu);
        annotation.setValue(null);
        annotation = (XmlAccessorOrderAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        XmlAccessorOrderPackageAnnotationTests.assertNull((Object)annotation.getValue());
        this.assertSourceDoesNotContain("@XmlAccessorOrder(", cu);
    }
}

