/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceField;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlMimeTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlMimeTypeAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_MIME_TYPE_VALUE = "myMimeType";

    public XmlMimeTypeAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlMimeType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlMimeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlMimeType");
            }
        });
    }

    private ICompilationUnit createTestXmlMimeTypeWithValue() throws Exception {
        return this.createTestXmlMimeTypeWithStringElement("value", XML_MIME_TYPE_VALUE);
    }

    private ICompilationUnit createTestXmlMimeTypeWithStringElement(final String element, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlMimeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlMimeType(" + element + " = \"" + value + "\")");
            }
        });
    }

    public void testGetXmlMimeType() throws Exception {
        ICompilationUnit cu = this.createTestXmlMimeType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlMimeTypeAnnotation xmlMimeTypeAnnotation = (XmlMimeTypeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMimeType");
        XmlMimeTypeAnnotationTests.assertTrue((xmlMimeTypeAnnotation != null ? 1 : 0) != 0);
        resourceAttribute.removeAnnotation("javax.xml.bind.annotation.XmlMimeType");
        this.assertSourceDoesNotContain("@XmlMimeType", cu);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlMimeTypeWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlMimeTypeAnnotation xmlMimeTypeAnnotation = (XmlMimeTypeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMimeType");
        XmlMimeTypeAnnotationTests.assertTrue((xmlMimeTypeAnnotation != null ? 1 : 0) != 0);
        XmlMimeTypeAnnotationTests.assertEquals((String)XML_MIME_TYPE_VALUE, (String)xmlMimeTypeAnnotation.getValue());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlMimeType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlMimeTypeAnnotation xmlMimeTypeAnnotation = (XmlMimeTypeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMimeType");
        XmlMimeTypeAnnotationTests.assertTrue((xmlMimeTypeAnnotation != null ? 1 : 0) != 0);
        XmlMimeTypeAnnotationTests.assertNull((Object)xmlMimeTypeAnnotation.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlMimeType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlMimeTypeAnnotation xmlMimeTypeAnnotation = (XmlMimeTypeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlMimeType");
        XmlMimeTypeAnnotationTests.assertNull((Object)xmlMimeTypeAnnotation.getValue());
        xmlMimeTypeAnnotation.setValue(XML_MIME_TYPE_VALUE);
        XmlMimeTypeAnnotationTests.assertEquals((String)XML_MIME_TYPE_VALUE, (String)xmlMimeTypeAnnotation.getValue());
        this.assertSourceContains("@XmlMimeType(\"myMimeType\")", cu);
        xmlMimeTypeAnnotation.setValue(null);
        XmlMimeTypeAnnotationTests.assertNull((Object)xmlMimeTypeAnnotation.getValue());
        this.assertSourceDoesNotContain("@XmlMimeType(", cu);
    }
}

