/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.preferences.ui;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocumentFactory;
import org.eclipse.wst.html.core.internal.format.HTMLFormattingUtil;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

public class HTMLSourcePreferencePage
extends AbstractPreferencePage {
    private Button fTagNameUpper = null;
    private Button fTagNameLower = null;
    private Button fAttrNameUpper = null;
    private Button fAttrNameLower = null;
    private final int MIN_INDENTATION_SIZE = 0;
    private final int MAX_INDENTATION_SIZE = 16;
    private Button fClearAllBlankLines;
    private Text fLineWidthText;
    private Button fSplitMultiAttrs;
    private Button fAlignEndBracket;
    private Button fIndentUsingTabs;
    private Button fIndentUsingSpaces;
    private Spinner fIndentationSize;
    private Button fAddButton;
    private Button fRemoveButton;
    private TableViewer fViewer;
    private ContentProvider fContentProvider;

    private Composite createContentsForPreferredCaseGroup(Composite parent, int columnSpan) {
        Group caseGroup = this.createGroup(parent, columnSpan);
        caseGroup.setText(HTMLUIMessages.Preferred_markup_case_UI_);
        Group tagNameGroup = this.createGroup((Composite)caseGroup, 1);
        tagNameGroup.setText(HTMLUIMessages.Tag_names__UI_);
        this.fTagNameUpper = this.createRadioButton((Composite)tagNameGroup, HTMLUIMessages.Tag_names_Upper_case_UI_);
        this.fTagNameLower = this.createRadioButton((Composite)tagNameGroup, HTMLUIMessages.Tag_names_Lower_case_UI_);
        Group attrNameGroup = this.createGroup((Composite)caseGroup, 1);
        attrNameGroup.setText(HTMLUIMessages.Attribute_names__UI_);
        this.fAttrNameUpper = this.createRadioButton((Composite)attrNameGroup, HTMLUIMessages.Attribute_names_Upper_case_UI_);
        this.fAttrNameLower = this.createRadioButton((Composite)attrNameGroup, HTMLUIMessages.Attribute_names_Lower_case_UI_);
        return parent;
    }

    private void createContentsForFormattingGroup(Composite parent) {
        Group formattingGroup = this.createGroup(parent, 2);
        formattingGroup.setText(HTMLUIMessages.Formatting_UI_);
        this.createLabel((Composite)formattingGroup, HTMLUIMessages.Line_width__UI_);
        this.fLineWidthText = new Text((Composite)formattingGroup, 2052);
        GridData gData = new GridData(33);
        gData.widthHint = 25;
        this.fLineWidthText.setLayoutData((Object)gData);
        this.fLineWidthText.addModifyListener((ModifyListener)this);
        this.fSplitMultiAttrs = this.createCheckBox((Composite)formattingGroup, HTMLUIMessages.Split_multiple_attributes);
        ((GridData)this.fSplitMultiAttrs.getLayoutData()).horizontalSpan = 2;
        this.fAlignEndBracket = this.createCheckBox((Composite)formattingGroup, HTMLUIMessages.Align_final_bracket);
        ((GridData)this.fAlignEndBracket.getLayoutData()).horizontalSpan = 2;
        this.fClearAllBlankLines = this.createCheckBox((Composite)formattingGroup, HTMLUIMessages.Clear_all_blank_lines_UI_);
        ((GridData)this.fClearAllBlankLines.getLayoutData()).horizontalSpan = 2;
        Composite indentComposite = this.createComposite((Composite)formattingGroup, 1);
        ((GridData)indentComposite.getLayoutData()).horizontalSpan = 2;
        ((GridLayout)indentComposite.getLayout()).marginWidth = 0;
        ((GridLayout)indentComposite.getLayout()).marginHeight = 0;
        this.fIndentUsingTabs = this.createRadioButton(indentComposite, HTMLUIMessages.Indent_using_tabs);
        ((GridData)this.fIndentUsingTabs.getLayoutData()).horizontalSpan = 1;
        this.fIndentUsingSpaces = this.createRadioButton(indentComposite, HTMLUIMessages.Indent_using_spaces);
        ((GridData)this.fIndentUsingSpaces.getLayoutData()).horizontalSpan = 1;
        this.createLabel((Composite)formattingGroup, HTMLUIMessages.Indentation_size);
        this.fIndentationSize = new Spinner((Composite)formattingGroup, 2056);
        GridData gd = new GridData(32);
        this.fIndentationSize.setLayoutData((Object)gd);
        this.fIndentationSize.setToolTipText(HTMLUIMessages.Indentation_size_tip);
        this.fIndentationSize.setMinimum(0);
        this.fIndentationSize.setMaximum(16);
        this.fIndentationSize.setIncrement(1);
        this.fIndentationSize.setPageIncrement(4);
        this.fIndentationSize.addModifyListener((ModifyListener)this);
        Composite inlineGroup = new Composite((Composite)formattingGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inlineGroup.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        inlineGroup.setLayoutData((Object)data);
        Label label = this.createLabel(inlineGroup, HTMLUIMessages.Inline_elements_table_label);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        final TableViewer viewer = new TableViewer(inlineGroup, 68354);
        data = new GridData(768);
        data.horizontalSpan = 1;
        data.verticalAlignment = 1;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        viewer.getTable().setLayoutData((Object)data);
        Composite buttonContainer = new Composite(inlineGroup, 0);
        data = new GridData(1040);
        buttonContainer.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        this.fAddButton = new Button(buttonContainer, 8);
        this.fAddButton.setText(HTMLUIMessages.Add_inline);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HTMLElementDialog dialog = new HTMLElementDialog(HTMLSourcePreferencePage.this.getShell());
                dialog.setMessage(HTMLUIMessages.Elements_Dialog_message);
                dialog.setTitle(HTMLUIMessages.Elements_Dialog_title);
                dialog.setMultipleSelection(true);
                dialog.setAllowDuplicates(false);
                dialog.open();
                Object[] result = dialog.getResult();
                if (result != null) {
                    int i = 0;
                    while (i < result.length) {
                        HTMLSourcePreferencePage.this.fContentProvider.addElement(result[i].toString());
                        ++i;
                    }
                    HTMLSourcePreferencePage.this.fViewer.refresh();
                }
            }
        });
        data = new GridData(770);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.fAddButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        data.horizontalSpan = 1;
        this.fAddButton.setLayoutData((Object)data);
        this.fRemoveButton = new Button(buttonContainer, 8);
        this.fRemoveButton.setText(HTMLUIMessages.Remove_inline);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = viewer.getSelection();
                if (selection != null && !selection.isEmpty() && selection instanceof StructuredSelection) {
                    Object[] remove = ((StructuredSelection)selection).toArray();
                    int i = 0;
                    while (i < remove.length) {
                        HTMLSourcePreferencePage.this.fContentProvider.removeElement(remove[i].toString());
                        ++i;
                    }
                    if (remove.length > 0) {
                        HTMLSourcePreferencePage.this.fViewer.refresh();
                    }
                }
            }
        });
        data = new GridData(770);
        data.horizontalSpan = 1;
        this.fRemoveButton.setLayoutData((Object)data);
        this.fViewer = viewer;
        this.fContentProvider = new ContentProvider();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setInput((Object)this);
        viewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
    }

    protected void performDefaults() {
        this.fTagNameUpper.setSelection(this.getModelPreferences().getDefaultInt("tagNameCase") == 2);
        this.fTagNameLower.setSelection(this.getModelPreferences().getDefaultInt("tagNameCase") == 1);
        this.fAttrNameUpper.setSelection(this.getModelPreferences().getDefaultInt("attrNameCase") == 2);
        this.fAttrNameLower.setSelection(this.getModelPreferences().getDefaultInt("attrNameCase") == 1);
        this.performDefaultsForFormattingGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    private void performDefaultsForFormattingGroup() {
        this.fLineWidthText.setText(this.getModelPreferences().getDefaultString("lineWidth"));
        this.fSplitMultiAttrs.setSelection(this.getModelPreferences().getDefaultBoolean("splitMultiAttrs"));
        this.fAlignEndBracket.setSelection(this.getModelPreferences().getDefaultBoolean("alignEndBracket"));
        this.fClearAllBlankLines.setSelection(this.getModelPreferences().getDefaultBoolean("clearAllBlankLines"));
        if ("tab".equals(this.getModelPreferences().getDefaultString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getDefaultInt("indentationSize"));
        this.fContentProvider.restoreDefaults();
        this.fViewer.refresh();
    }

    protected void initializeValues() {
        this.fTagNameUpper.setSelection(this.getModelPreferences().getInt("tagNameCase") == 2);
        this.fTagNameLower.setSelection(this.getModelPreferences().getInt("tagNameCase") == 1);
        this.fAttrNameUpper.setSelection(this.getModelPreferences().getInt("attrNameCase") == 2);
        this.fAttrNameLower.setSelection(this.getModelPreferences().getInt("attrNameCase") == 1);
        this.initializeValuesForFormattingGroup();
    }

    private void initializeValuesForFormattingGroup() {
        this.fLineWidthText.setText(this.getModelPreferences().getString("lineWidth"));
        this.fSplitMultiAttrs.setSelection(this.getModelPreferences().getBoolean("splitMultiAttrs"));
        this.fAlignEndBracket.setSelection(this.getModelPreferences().getBoolean("alignEndBracket"));
        this.fClearAllBlankLines.setSelection(this.getModelPreferences().getBoolean("clearAllBlankLines"));
        if ("tab".equals(this.getModelPreferences().getString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getInt("indentationSize"));
    }

    protected void storeValues() {
        if (this.fTagNameUpper.getSelection()) {
            this.getModelPreferences().setValue("tagNameCase", 2);
        } else {
            this.getModelPreferences().setValue("tagNameCase", 1);
        }
        if (this.fAttrNameUpper.getSelection()) {
            this.getModelPreferences().setValue("attrNameCase", 2);
        } else {
            this.getModelPreferences().setValue("attrNameCase", 1);
        }
        this.storeValuesForFormattingGroup();
    }

    private void storeValuesForFormattingGroup() {
        this.getModelPreferences().setValue("lineWidth", this.fLineWidthText.getText());
        this.getModelPreferences().setValue("splitMultiAttrs", this.fSplitMultiAttrs.getSelection());
        this.getModelPreferences().setValue("alignEndBracket", this.fAlignEndBracket.getSelection());
        this.getModelPreferences().setValue("clearAllBlankLines", this.fClearAllBlankLines.getSelection());
        if (this.fIndentUsingTabs.getSelection()) {
            this.getModelPreferences().setValue("indentationChar", "tab");
        } else {
            this.getModelPreferences().setValue("indentationChar", "space");
        }
        this.getModelPreferences().setValue("indentationSize", this.fIndentationSize.getSelection());
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        HTMLFormattingUtil.exportToPreferences((Object[])this.fContentProvider.fElements.toArray());
        return result;
    }

    protected Preferences getModelPreferences() {
        return HTMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return HTMLUIPlugin.getDefault().getPreferenceStore();
    }

    private void doSavePreferenceStore() {
        HTMLUIPlugin.getDefault().savePluginPreferences();
        HTMLCorePlugin.getDefault().savePluginPreferences();
    }

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.html.ui.webx0031");
        new PreferenceLinkArea(composite, 66, "org.eclipse.wst.sse.ui.preferences.editor", HTMLUIMessages._UI_STRUCTURED_TEXT_EDITOR_PREFS_LINK, (IWorkbenchPreferenceContainer)this.getContainer(), null).getControl().setLayoutData((Object)GridDataFactory.fillDefaults().hint(150, -1).create());
        new Label(composite, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.createContentsForFormattingGroup(composite);
        this.createContentsForPreferredCaseGroup(composite, 2);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void validateValues() {
        boolean isError = false;
        String widthText = null;
        if (this.fLineWidthText != null) {
            try {
                widthText = this.fLineWidthText.getText();
                int formattingLineWidth = Integer.parseInt(widthText);
                if (formattingLineWidth < 0 || formattingLineWidth > 999) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setInvalidInputMessage(widthText);
                this.setValid(false);
                isError = true;
            }
        }
        int indentSize = 0;
        if (this.fIndentationSize != null) {
            try {
                indentSize = this.fIndentationSize.getSelection();
                if (indentSize < 0 || indentSize > 16) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setInvalidInputMessage(Integer.toString(indentSize));
                this.setValid(false);
                isError = true;
            }
        }
        if (!isError) {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private List fElements = new ArrayList<Object>(Arrays.asList(HTMLFormattingUtil.getInlineElements()));

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addElement(String name) {
            if (!this.fElements.contains(name)) {
                this.fElements.add(name);
            }
        }

        public void removeElement(String name) {
            this.fElements.remove(name);
        }

        public Object[] getElements(Object inputElement) {
            return this.fElements.toArray();
        }

        public void restoreDefaults() {
            this.fElements = new ArrayList<Object>(Arrays.asList(HTMLFormattingUtil.getDefaultInlineElements()));
        }
    }

    private static class HTMLElementDialog
    extends ElementListSelectionDialog {
        public HTMLElementDialog(Shell parent) {
            super(parent, new ILabelProvider(){

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public String getText(Object element) {
                    return element.toString();
                }

                public Image getImage(Object element) {
                    return null;
                }
            });
        }

        public int open() {
            ArrayList list = new ArrayList();
            IProgressService context = PlatformUI.getWorkbench().getProgressService();
            IRunnableWithProgress runnable = new IRunnableWithProgress(this, list){
                final /* synthetic */ HTMLElementDialog this$1;
                private final /* synthetic */ List val$list;
                {
                    this.this$1 = hTMLElementDialog;
                    this.val$list = list;
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("Searching for known elements", 1);
                    try {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        CMNamedNodeMap map = HTMLCMDocumentFactory.getCMDocument((String)"HTML5").getElements();
                        Iterator it = map.iterator();
                        while (it.hasNext()) {
                            CMNode node = (CMNode)it.next();
                            if (!node.getNodeName().startsWith("SSI:")) {
                                this.val$list.add(node.getNodeName().toLowerCase(Locale.US));
                            }
                            monitor.worked(1);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var5_7 = null;
                    }
                    monitor.done();
                }
            };
            try {
                context.run(true, true, runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                return 1;
            }
            catch (InterruptedException interruptedException) {
                return 1;
            }
            this.setElements(list.toArray());
            return super.open();
        }
    }
}

