/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import java.util.Iterator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;
import org.eclipse.wst.xml.ui.internal.dnd.DragNodeCommand;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.TreeContentHelper;
import org.eclipse.wst.xml.ui.internal.tabletree.TreeExtension;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeContentProvider;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreePropertyDescriptorFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLTableTreeViewer
extends TreeViewer
implements IDesignViewer {
    private PaintListener fContentPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            if (XMLTableTreeViewer.this.getTree().getItemCount() == 0) {
                gc.setForeground(XMLTableTreeViewer.this.getTree().getDisplay().getSystemColor(24));
                gc.setBackground(XMLTableTreeViewer.this.getTree().getDisplay().getSystemColor(25));
                gc.drawString(XMLEditorMessages.XMLTreeExtension_3, 10, 10);
                gc.drawString(XMLEditorMessages.XMLTreeExtension_4, 10, 10 + gc.getFontMetrics().getHeight());
            }
        }
    };
    private ISelectionProvider fSelectionProvider = new SelectionProvider();
    static final double[] WEIGHTS = new double[]{0.4, 0.6};
    private ControlAdapter fResizeAdapter = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            this.sizeColumns(XMLTableTreeViewer.this.getTree().getSize().x, WEIGHTS);
        }

        private void sizeColumns(int width, double[] weights) {
            TreeColumn[] columns = XMLTableTreeViewer.this.getTree().getColumns();
            int size = columns.length;
            int i = 0;
            while (i < size) {
                columns[i].setWidth((int)(weights[i] * (double)width));
                ++i;
            }
        }
    };
    protected TreeContentHelper treeContentHelper = new TreeContentHelper();
    protected XMLTableTreePropertyDescriptorFactory propertyDescriptorFactory;
    private static final String STRUCTURE_PROPERTY = XMLEditorMessages.XMLTreeExtension_0;
    private static final String VALUE_PROPERTY = XMLEditorMessages.XMLTreeExtension_1;

    public XMLTableTreeViewer(Composite parent) {
        super(parent, 66306);
        TreeColumn column = new TreeColumn(this.getTree(), 16384);
        column.setText(XMLEditorMessages.XMLTableTreeViewer_1);
        column = new TreeColumn(this.getTree(), 16384);
        column.setText(XMLEditorMessages.XMLTableTreeViewer_2);
        this.getTree().setHeaderVisible(true);
        this.getTree().setLinesVisible(true);
        this.getTree().addControlListener((ControlListener)this.fResizeAdapter);
        this.propertyDescriptorFactory = new XMLTableTreePropertyDescriptorFactory();
        XMLTableTreeContentProvider provider = new XMLTableTreeContentProvider();
        this.setContentProvider((IContentProvider)provider);
        this.setLabelProvider((IBaseLabelProvider)provider);
        this.setColumnProperties(new String[]{STRUCTURE_PROPERTY, VALUE_PROPERTY});
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)this.getTree());
        this.setCellEditors(cellEditorArray);
        this.setCellModifier(new XMLCMCellModifier());
        this.createContextMenu();
        DragSource dragSource = new DragSource(this.getControl(), 3);
        dragSource.addDragListener(this.createDragSourceListener());
        dragSource.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        DropTarget dropTarget = new DropTarget(this.getControl(), 3);
        dropTarget.addDropListener(this.createDropTargetListener());
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        this.getTree().addPaintListener(this.fContentPaintListener);
    }

    protected void createContextMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)new NodeActionMenuListener());
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    private DragSourceListener createDragSourceListener() {
        return new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            public void dragSetData(DragSourceEvent event) {
            }

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(XMLTableTreeViewer.this.getSelection());
            }
        };
    }

    private DropTargetListener createDropTargetListener() {
        return new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (event.operations != 0 && LocalSelectionTransfer.getTransfer().getSelection() instanceof IStructuredSelection) {
                    this.dragOver(event);
                    IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                    if (selection != null && !selection.isEmpty() && event.item != null && event.item.getData() != null) {
                        float feedbackFloat = this.getHeightInItem(event);
                        DragNodeCommand command = new DragNodeCommand(event.item.getData(), feedbackFloat, event.operations, event.detail, selection.toList(), XMLTableTreeViewer.this);
                        if (command != null && command.canExecute()) {
                            SafeRunnable.run((ISafeRunnable)new SafeRunnable(this, command){
                                final /* synthetic */ 5 this$1;
                                private final /* synthetic */ DragNodeCommand val$command;
                                {
                                    this.this$1 = var1_1;
                                    this.val$command = dragNodeCommand;
                                }

                                public void run() throws Exception {
                                    this.val$command.execute();
                                }
                            });
                        }
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 1;
                float feedbackFloat = this.getHeightInItem(event);
                if ((double)feedbackFloat > 0.75) {
                    event.feedback = 4;
                } else if ((double)feedbackFloat < 0.25) {
                    event.feedback = 2;
                }
                event.feedback |= 0x18;
                if (this.getLocalNodeSelection(event) == null) {
                    event.detail = 0;
                }
            }

            private IStructuredSelection getLocalNodeSelection(DropTargetEvent event) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                if (selection != null && !selection.isEmpty()) {
                    Iterator i = selection.iterator();
                    while (i.hasNext()) {
                        Object node = i.next();
                        if (!(node instanceof Node)) continue;
                        return selection;
                    }
                }
                return null;
            }

            private float getHeightInItem(DropTargetEvent event) {
                if (event.item == null) {
                    return 0.5f;
                }
                if (event.item instanceof TreeItem) {
                    TreeItem treeItem = (TreeItem)event.item;
                    Tree control = treeItem.getParent();
                    Point point = control.toControl(new Point(event.x, event.y));
                    Rectangle bounds = treeItem.getBounds();
                    return (float)(point.y - bounds.y) / (float)bounds.height;
                }
                if (event.item instanceof TableItem) {
                    TableItem tableItem = (TableItem)event.item;
                    Table control = tableItem.getParent();
                    Point point = control.toControl(new Point(event.x, event.y));
                    Rectangle bounds = tableItem.getBounds(0);
                    return (float)(point.y - bounds.y) / (float)bounds.height;
                }
                return 0.0f;
            }
        };
    }

    protected void doRefresh(Object o, boolean fromDelayed) {
        super.refresh(o);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public String getTitle() {
        return XMLEditorMessages.XMLTableTreeViewer_0;
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.getTree().removePaintListener(this.fContentPaintListener);
        this.getTree().removeControlListener((ControlListener)this.fResizeAdapter);
        this.setDocument(null);
    }

    /*
     * Exception decompiling
     */
    public void setDocument(IDocument document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 65->69)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class CellListener
    implements ICellEditorListener {
        private Node node;
        private CellEditor editor;
        private String originalValue;

        CellListener(Node data, CellEditor editor) {
            this.node = data;
            this.editor = editor;
            ((IDOMNode)this.node).getModel().aboutToChangeModel();
            this.originalValue = XMLTableTreeViewer.this.treeContentHelper.getNodeValue(this.node);
        }

        public void applyEditorValue() {
            ((IDOMNode)this.node).getModel().changedModel();
            this.editor.removeListener((ICellEditorListener)this);
        }

        public void cancelEditor() {
            Object value = this.editor.getValue();
            if (value != null && !value.equals(this.originalValue)) {
                XMLTableTreeViewer.this.treeContentHelper.setNodeValue(this.node, this.originalValue);
            }
            ((IDOMNode)this.node).getModel().changedModel();
            this.editor.removeListener((ICellEditorListener)this);
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            if (newValidState) {
                XMLTableTreeViewer.this.treeContentHelper.setNodeValue(this.node, this.editor.getValue().toString(), XMLTableTreeViewer.this.getControl().getShell());
            }
        }
    }

    class NodeActionMenuListener
    implements IMenuListener {
        NodeActionMenuListener() {
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            XMLNodeActionManager nodeActionManager = new XMLNodeActionManager(this, (IStructuredModel)((IDOMDocument)XMLTableTreeViewer.this.getInput()).getModel(), (Viewer)XMLTableTreeViewer.this){
                final /* synthetic */ NodeActionMenuListener this$1;
                {
                    this.this$1 = nodeActionMenuListener;
                }

                public void beginNodeAction(NodeAction action) {
                    super.beginNodeAction(action);
                }

                public void endNodeAction(NodeAction action) {
                    super.endNodeAction(action);
                }
            };
            nodeActionManager.fillContextMenu(menuManager, XMLTableTreeViewer.this.getSelection());
        }
    }

    private class SelectionProvider
    implements IPostSelectionProvider {
        private SelectionProvider() {
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            XMLTableTreeViewer.this.addPostSelectionChangedListener(listener);
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            XMLTableTreeViewer.this.removePostSelectionChangedListener(listener);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            XMLTableTreeViewer.this.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            return XMLTableTreeViewer.this.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            XMLTableTreeViewer.this.removeSelectionChangedListener(listener);
        }

        public void setSelection(ISelection selection) {
            boolean selectionSet = false;
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (selection instanceof ITextSelection) {
                    IDOMNode domNode;
                    IStructuredDocumentRegion startStructuredDocumentRegion;
                    ITextSelection textSelection = (ITextSelection)selection;
                    if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof IDOMNode && (startStructuredDocumentRegion = (domNode = (IDOMNode)structuredSelection.getFirstElement()).getStartStructuredDocumentRegion()) != null) {
                        ITextRegion matchingRegion = startStructuredDocumentRegion.getRegionAtCharacterOffset(textSelection.getOffset());
                        int allowedIterations = 40;
                        while (matchingRegion != null && !matchingRegion.getType().equals("XML_TAG_ATTRIBUTE_NAME") && allowedIterations > 0) {
                            matchingRegion = startStructuredDocumentRegion.getRegionAtCharacterOffset(startStructuredDocumentRegion.getStartOffset(matchingRegion) - 1);
                            --allowedIterations;
                        }
                        if (matchingRegion != null && matchingRegion.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                            Node attr;
                            String attrName = startStructuredDocumentRegion.getText(matchingRegion);
                            NamedNodeMap attributes = domNode.getAttributes();
                            if (attributes != null && attrName.length() > 0 && (attr = attributes.getNamedItem(attrName)) != null) {
                                selectionSet = true;
                                XMLTableTreeViewer.this.setSelection((ISelection)new StructuredSelection((Object)attr));
                            }
                        }
                    }
                }
            }
            if (!selectionSet) {
                XMLTableTreeViewer.this.setSelection(selection);
            }
        }
    }

    public class XMLCMCellModifier
    implements ICellModifier,
    TreeExtension.ICellEditorProvider {
        public boolean canModify(Object element, String property) {
            boolean result = false;
            if (element instanceof Node) {
                CellEditor[] editors;
                Node node = (Node)element;
                if (property == VALUE_PROPERTY && (result = XMLTableTreeViewer.this.treeContentHelper.isEditable(node)) && (editors = XMLTableTreeViewer.this.getCellEditors()).length > 0) {
                    if (editors[1] != null) {
                        editors[1].dispose();
                    }
                    editors[1] = this.getCellEditor(element, 1);
                    if (editors[1] instanceof TextCellEditor) {
                        editors[1].addListener((ICellEditorListener)new CellListener(node, editors[1]));
                    }
                }
            }
            return result;
        }

        public Object getValue(Object object, String property) {
            String result = null;
            if (object instanceof Node) {
                result = XMLTableTreeViewer.this.treeContentHelper.getNodeValue((Node)object);
            }
            return result != null ? result : "";
        }

        public void modify(Object element, String property, Object value) {
            Item item = (Item)element;
            String oldValue = XMLTableTreeViewer.this.treeContentHelper.getNodeValue((Node)item.getData());
            String newValue = value.toString();
            if (newValue != null && !newValue.equals(oldValue)) {
                XMLTableTreeViewer.this.treeContentHelper.setNodeValue((Node)item.getData(), value.toString(), XMLTableTreeViewer.this.getControl().getShell());
            }
        }

        public CellEditor getCellEditor(Object o, int col) {
            IPropertyDescriptor pd = XMLTableTreeViewer.this.propertyDescriptorFactory.createPropertyDescriptor(o);
            return pd != null ? pd.createPropertyEditor((Composite)XMLTableTreeViewer.this.getTree()) : null;
        }
    }
}

