/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.HashMap;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IFunctionCall;
import org.eclipse.wst.jsdt.core.ast.IFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IFunctionExpression;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteral;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteralField;
import org.eclipse.wst.jsdt.core.ast.ISingleNameReference;
import org.eclipse.wst.jsdt.core.ast.IStringLiteral;
import org.eclipse.wst.jsdt.core.infer.IInferEngine;
import org.eclipse.wst.jsdt.core.infer.IInferenceFile;
import org.eclipse.wst.jsdt.core.infer.InferEngine;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.core.infer.RefactoringSupport;
import org.eclipse.wst.jsdt.core.infer.ResolutionConfiguration;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class InferResolveTests
extends AbstractRegressionTest {
    public InferResolveTests(String name) {
        super(name);
    }

    protected void runNegativeTest(String[] testFiles, InferEngine inferEngine, String expectedProblemLog) {
        HashMap<String, InferEngine[]> options = new HashMap<String, InferEngine[]>();
        InferEngine[] inferenceEngines = new InferEngine[]{(InferEngine)new InferProvider(inferEngine).getInferEngine()};
        options.put("InferenceEnginesOption", inferenceEngines);
        this.runNegativeTest(testFiles, expectedProblemLog, null, true, options, false, false, false, false, false, null);
    }

    public void test001() {
        this.runNegativeTest(new String[]{"cls.js", "  function defineClass(name,args){}\n  function addMixin(toClass,mixinName){}\n  defineClass(\"MyClass\",\n   {meth1 : function (){} }\n );\n  addMixin(\"MyClass\",\"myMixin\");\n", "mix.js", "  defineClass(\"myMixin\",\n   {mixinFunc : function (){} }\n );\n", "use.js", "  var v=new MyClass();\n v.mixinFunc();\n"}, new TestInferEngine(), "");
    }

    static class InferProvider
    implements InferrenceProvider {
        InferEngine inferEngine;

        public InferProvider(InferEngine inferEngine) {
            this.inferEngine = inferEngine;
            inferEngine.inferenceProvider = this;
        }

        public int applysTo(IInferenceFile scriptFile) {
            return 3;
        }

        public String getID() {
            return "dummyID";
        }

        public IInferEngine getInferEngine() {
            return this.inferEngine;
        }

        public RefactoringSupport getRefactoringSupport() {
            return null;
        }

        public ResolutionConfiguration getResolutionConfiguration() {
            return null;
        }
    }

    static class TestInferEngine
    extends InferEngine {
        static final char[][] ADD_CLASS = new char[][]{"defineClass".toCharArray()};
        static final char[][] ADD_MIXIN = new char[][]{"addMixin".toCharArray()};

        TestInferEngine() {
        }

        protected boolean handleFunctionCall(IFunctionCall functionCall) {
            IExpression[] arguments;
            if (this.isFunction(functionCall, ADD_CLASS)) {
                IExpression[] arguments2 = functionCall.getArguments();
                if (arguments2.length > 1 && arguments2[0] instanceof IStringLiteral) {
                    IObjectLiteral objectLiteral;
                    char[] className = this.getString(arguments2[0]);
                    InferredType type = this.addType(className, true);
                    type.sourceStart = functionCall.sourceStart();
                    type.sourceEnd = functionCall.sourceEnd();
                    if (arguments2[1] instanceof IObjectLiteral && (objectLiteral = (IObjectLiteral)arguments2[1]).getFields() != null) {
                        int i = 0;
                        while (i < objectLiteral.getFields().length) {
                            IObjectLiteralField field = objectLiteral.getFields()[i];
                            char[] name = this.getString(field.getFieldName());
                            if (field.getInitializer() instanceof IFunctionExpression) {
                                IFunctionExpression functionExpression = (IFunctionExpression)field.getInitializer();
                                type.addMethod(name, (IFunctionDeclaration)functionExpression.getMethodDeclaration(), field.getFieldName().sourceStart());
                            }
                            ++i;
                        }
                    }
                }
            } else if (this.isFunction(functionCall, ADD_MIXIN) && (arguments = functionCall.getArguments()).length > 1) {
                InferredType type;
                char[] className = this.getString(arguments[0]);
                char[] mixinName = this.getString(arguments[1]);
                if (className != null && mixinName != null && (type = this.findDefinedType(className)) != null) {
                    type.addMixin(mixinName);
                }
            }
            return true;
        }

        private char[] getString(IExpression expression) {
            if (expression instanceof IStringLiteral) {
                IStringLiteral strLit = (IStringLiteral)expression;
                return strLit.source();
            }
            if (expression instanceof ISingleNameReference) {
                ISingleNameReference snr = (ISingleNameReference)expression;
                return snr.getToken();
            }
            return null;
        }
    }
}

