/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.Tracing;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.swt.ComboModelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.DateTimeModelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.SpinnerModelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.TriStateCheckBoxModelAdapter;
import org.eclipse.jpt.common.ui.internal.util.ControlAligner;
import org.eclipse.jpt.common.ui.internal.util.LabeledButton;
import org.eclipse.jpt.common.ui.internal.util.LabeledControlUpdater;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.utility.swt.SWTTools;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.NonNullBooleanTransformer;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeBooleanPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pane<T extends Model> {
    private PropertyChangeListener aspectChangeListener;
    private final Composite container;
    private ControlAligner leftControlAligner;
    private boolean populating;
    private ControlAligner rightControlAligner;
    private PropertyChangeListener subjectChangeListener;
    private PropertyValueModel<T> subjectHolder;
    private Collection<Pane<?>> subPanes;
    private WidgetFactory widgetFactory;
    private ArrayList<Control> managedWidgets;
    private ArrayList<Pane<?>> managedSubPanes;
    private final WritablePropertyValueModel<Boolean> baseEnabledModel = new SimplePropertyValueModel((Object)Boolean.TRUE);
    private PropertyValueModel<Boolean> controllerEnabledModel;
    private PropertyValueModel<Boolean> combinedEnabledModel;
    private PropertyChangeListener combinedEnabledModelListener;

    protected Pane(Pane<? extends T> parentPane, Composite parent) {
        this(parentPane, parent, true);
    }

    protected Pane(Pane<? extends T> parentPane, Composite parent, boolean automaticallyAlignWidgets) {
        this(parentPane, parentPane.getSubjectHolder(), parent, automaticallyAlignWidgets);
    }

    protected Pane(Pane<? extends T> parentPane, Composite parent, boolean automaticallyAlignWidgets, boolean parentManagePane) {
        this(parentPane, parentPane.getSubjectHolder(), parent, automaticallyAlignWidgets, parentManagePane);
    }

    protected Pane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        this(parentPane, subjectHolder, parent, true);
    }

    protected Pane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, PropertyValueModel<Boolean> enabledModel) {
        this(parentPane, subjectHolder, parent, true, enabledModel);
    }

    protected Pane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, boolean automaticallyAlignWidgets) {
        this(parentPane, subjectHolder, parent, automaticallyAlignWidgets, true);
    }

    protected Pane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, boolean automaticallyAlignWidgets, PropertyValueModel<Boolean> enabledModel) {
        this(parentPane, subjectHolder, parent, automaticallyAlignWidgets, true, enabledModel);
    }

    protected Pane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, boolean automaticallyAlignWidgets, boolean parentManagePane) {
        this(subjectHolder, parent, parentPane.getWidgetFactory());
        super.initialize(parentPane, automaticallyAlignWidgets, parentManagePane);
    }

    protected Pane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, boolean automaticallyAlignWidgets, boolean parentManagePane, PropertyValueModel<Boolean> enabledModel) {
        this(subjectHolder, parent, parentPane.getWidgetFactory());
        super.initialize(parentPane, automaticallyAlignWidgets, parentManagePane);
        super.initializeEnabledModel(enabledModel);
    }

    protected Pane(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        this.initialize(subjectHolder, widgetFactory);
        this.container = this.addContainer(parent);
        this.initializeLayout(this.container);
        this.engageSubjectHolder();
        this.engageListeners(this.getSubject());
        this.populate();
    }

    private void initialize(PropertyValueModel<? extends T> subjectHolder, WidgetFactory widgetFactory) {
        Assert.isNotNull(subjectHolder, (String)"The subject holder cannot be null");
        this.subjectHolder = subjectHolder;
        this.widgetFactory = widgetFactory;
        this.subPanes = new ArrayList();
        this.managedWidgets = new ArrayList();
        this.managedSubPanes = new ArrayList();
        this.leftControlAligner = new ControlAligner();
        this.rightControlAligner = new ControlAligner();
        this.subjectChangeListener = this.buildSubjectChangeListener();
        this.aspectChangeListener = this.buildAspectChangeListener();
        this.initialize();
    }

    protected void initialize() {
    }

    private void initialize(Pane<?> parentPane, boolean automaticallyAlignWidgets, boolean parentManagePane) {
        parentPane.registerSubPane(this);
        if (parentManagePane) {
            super.manageSubPane(this);
        }
        if (automaticallyAlignWidgets) {
            parentPane.addAlignLeft(this);
            parentPane.addAlignRight(this);
        }
    }

    private void initializeEnabledModel(PropertyValueModel<Boolean> enabledModel) {
        this.controllerEnabledModel = enabledModel;
        this.combinedEnabledModel = CompositeBooleanPropertyValueModel.and((PropertyValueModel[])new PropertyValueModel[]{this.baseEnabledModel, this.controllerEnabledModel});
        this.combinedEnabledModelListener = this.buildCombinedEnabledModelListener();
        this.combinedEnabledModel.addPropertyChangeListener("value", this.combinedEnabledModelListener);
        this.enableWidgets_(this.getCombinedEnablement());
    }

    private PropertyChangeListener buildCombinedEnabledModelListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildControllerEnabledModelListener_());
    }

    private PropertyChangeListener buildControllerEnabledModelListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                Pane.this.controllerEnablementChanged();
            }
        };
    }

    protected abstract void initializeLayout(Composite var1);

    private void manageWidget(Control control) {
        if (this.managedWidgets.contains(control)) {
            throw new IllegalStateException();
        }
        this.managedWidgets.add(control);
    }

    private void manageSubPane(Pane<?> subPane) {
        if (this.managedSubPanes.contains(subPane)) {
            throw new IllegalStateException();
        }
        this.managedSubPanes.add(subPane);
    }

    protected final void addAlignLeft(Pane<?> container) {
        this.leftControlAligner.add(container.leftControlAligner);
    }

    protected final void addAlignLeft(Control control) {
        this.leftControlAligner.add(control);
    }

    protected final void addAlignRight(Pane<?> container) {
        this.rightControlAligner.add(container.rightControlAligner);
    }

    protected final void addAlignRight(Control control) {
        this.rightControlAligner.add(control);
    }

    protected final void addPaneForAlignment(Pane<?> container) {
        this.addAlignLeft(container);
        this.addAlignRight(container);
    }

    protected void addPropertyNames(Collection<String> propertyNames) {
    }

    private PropertyChangeListener buildAspectChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildAspectChangeListener_());
    }

    private PropertyChangeListener buildAspectChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                if (e.getSource() == Pane.this.getSubject()) {
                    Pane.this.updatePane(e.getPropertyName());
                }
            }
        };
    }

    protected final Button addButton(Composite container, String text, Runnable buttonAction) {
        return this.addButton(container, text, null, buttonAction);
    }

    protected final Button addUnmanagedButton(Composite container, String text, Runnable buttonAction) {
        return this.addUnmanagedButton(container, text, null, buttonAction);
    }

    protected final Button addButton(Composite container, String text, String helpId, Runnable buttonAction) {
        Button button = this.addUnmanagedButton(container, text, helpId, buttonAction);
        this.manageWidget((Control)button);
        return button;
    }

    private Button addUnmanagedButton(Composite container, String text, String helpId, final Runnable buttonAction) {
        Button button = this.widgetFactory.createButton(container, text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTUtil.asyncExec(buttonAction);
            }
        });
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)button, helpId);
        }
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected GridData getFieldGridData() {
        int margin = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = 200 + margin;
        data.horizontalIndent = margin;
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    protected final Button addCheckBox(Composite parent, String buttonText, WritablePropertyValueModel<Boolean> booleanHolder, String helpId) {
        return this.addToggleButton(parent, buttonText, booleanHolder, helpId, 32);
    }

    protected final Button addCheckBox(Composite parent, String buttonText, WritablePropertyValueModel<Boolean> booleanHolder, String helpId, PropertyValueModel<Boolean> enabledModel) {
        Button button = this.addUnmanagedToggleButton(parent, buttonText, booleanHolder, helpId, 32);
        this.controlEnabledState(enabledModel, new Control[]{button});
        return button;
    }

    protected final Composite addCollapsibleSection(Composite container, String sectionText) {
        return this.addCollapsibleSection(container, sectionText, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.FALSE));
    }

    protected final Composite addCollapsibleSection(Composite container, String sectionText, String description) {
        return this.addCollapsibleSection(container, sectionText, description, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.FALSE));
    }

    private Composite addCollapsibleSection(Composite container, String sectionText, int type, PropertyValueModel<Boolean> expandedStateHolder) {
        return this.addCollapsibleSection(container, sectionText, null, type, expandedStateHolder);
    }

    private Composite addCollapsibleSection(Composite container, String sectionText, String description, int type, PropertyValueModel<Boolean> expandedStateHolder) {
        Composite subPane = this.addSection(container, sectionText, description, 2 | type);
        Section section = (Section)subPane.getParent();
        expandedStateHolder.addPropertyChangeListener("value", this.buildExpandedStateChangeListener(section));
        section.setExpanded(expandedStateHolder.getValue() != null ? (Boolean)expandedStateHolder.getValue() : true);
        return subPane;
    }

    protected final Composite addCollapsibleSection(Composite container, String sectionText, PropertyValueModel<Boolean> expandedStateHolder) {
        return this.addCollapsibleSection(container, sectionText, 258, expandedStateHolder);
    }

    protected final Composite addCollapsibleSection(Composite container, String sectionText, String description, PropertyValueModel<Boolean> expandedStateHolder) {
        return this.addCollapsibleSection(container, sectionText, description, 258, expandedStateHolder);
    }

    protected final Composite addCollapsibleSubSection(Composite container, String sectionText, PropertyValueModel<Boolean> expandedStateHolder) {
        return this.addCollapsibleSection(container, sectionText, 0, expandedStateHolder);
    }

    protected final Combo addCombo(Composite container) {
        Combo combo = this.addUnmanagedCombo(container);
        this.manageWidget((Control)combo);
        return combo;
    }

    private Combo addUnmanagedCombo(Composite container) {
        Combo combo = this.widgetFactory.createCombo(container);
        combo.setLayoutData((Object)this.getFieldGridData());
        return combo;
    }

    protected final <V> Combo addCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter) {
        Combo combo = this.addCombo(container);
        ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    private <V> Combo addUnmanagedCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter) {
        Combo combo = this.addUnmanagedCombo(container);
        ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    protected final <V> Combo addCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, PropertyValueModel<Boolean> enabledModel) {
        Combo combo = this.addUnmanagedCombo(container, listHolder, selectedItemHolder, stringConverter);
        this.controlEnabledState(enabledModel, new Control[]{combo});
        return combo;
    }

    protected final ComboViewer addComboViewer(Composite container, IBaseLabelProvider labelProvider) {
        Combo combo = this.addCombo(container);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setLabelProvider(labelProvider);
        return viewer;
    }

    protected Composite addContainer(Composite parent) {
        return this.addSubPane(parent);
    }

    protected final <V> Combo addEditableCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, PropertyValueModel<Boolean> enabledModel) {
        Combo combo = this.addUnmanagedEditableCombo(container, listHolder, selectedItemHolder, stringConverter);
        this.controlEnabledState(enabledModel, new Control[]{combo});
        return combo;
    }

    protected final Combo addEditableCombo(Composite container) {
        Combo combo = this.widgetFactory.createEditableCombo(container);
        combo.setLayoutData((Object)this.getFieldGridData());
        this.manageWidget((Control)combo);
        return combo;
    }

    protected final <V> Combo addEditableCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter) {
        Combo combo = this.addEditableCombo(container);
        ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    protected final ComboViewer addEditableComboViewer(Composite container, IBaseLabelProvider labelProvider) {
        Combo combo = this.addEditableCombo(container);
        ComboViewer viewer = new ComboViewer(combo);
        viewer.setLabelProvider(labelProvider);
        return viewer;
    }

    private PropertyChangeListener buildExpandedStateChangeListener(Section section) {
        return new SWTPropertyChangeListenerWrapper(this.buildExpandedStateChangeListener_(section));
    }

    private PropertyChangeListener buildExpandedStateChangeListener_(final Section section) {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                Boolean value = (Boolean)e.getNewValue();
                if (value == null) {
                    value = Boolean.TRUE;
                }
                section.setExpanded(value.booleanValue());
            }
        };
    }

    protected final Hyperlink addHyperlink(Composite parent, String text, final Runnable hyperLinkAction) {
        Hyperlink link = this.widgetFactory.createHyperlink(parent, text);
        this.manageWidget((Control)link);
        link.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Hyperlink hyperLink = (Hyperlink)e.widget;
                if (hyperLink.isEnabled()) {
                    SWTUtil.asyncExec(hyperLinkAction);
                }
            }
        });
        return link;
    }

    protected final Label addLabel(Composite container, String labelText) {
        Label label = this.addUnmanagedLabel(container, labelText);
        this.manageWidget((Control)label);
        return label;
    }

    protected final Label addLabel(Composite container, String labelText, PropertyValueModel<Boolean> enabledModel) {
        Label label = this.addUnmanagedLabel(container, labelText);
        this.controlEnabledState(enabledModel, new Control[]{label});
        return label;
    }

    private Label addUnmanagedLabel(Composite container, String labelText) {
        return this.widgetFactory.createLabel(container, labelText);
    }

    protected final <V> Combo addLabeledCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, Control rightControl, String helpId) {
        Combo combo = this.addCombo(container, listHolder, selectedItemHolder, stringConverter);
        this.addLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final <V> Combo addLabeledCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, String helpId) {
        return this.addLabeledCombo(container, labelText, listHolder, selectedItemHolder, stringConverter, null, helpId);
    }

    protected final Composite addLabeledComposite(Composite container, Control leftControl, Control centerControl, Control rightControl, String helpId) {
        container = this.addSubPane(container, 3, 0, 0, 0, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        leftControl.setLayoutData((Object)gridData);
        leftControl.setParent(container);
        this.addAlignLeft(leftControl);
        centerControl.setParent(container);
        if (helpId != null) {
            this.getHelpSystem().setHelp(centerControl, helpId);
        }
        if (rightControl == null) {
            Composite spacer = this.addPane(container);
            spacer.setLayout(this.buildSpacerLayout());
            rightControl = spacer;
        } else {
            rightControl.setParent(container);
            if (helpId != null) {
                this.getHelpSystem().setHelp(rightControl, helpId);
            }
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 768;
        gridData.grabExcessHorizontalSpace = false;
        rightControl.setLayoutData((Object)gridData);
        this.addAlignRight(rightControl);
        return container;
    }

    protected final Composite addLabeledComposite(Composite container, Control label, Control centerControl, String helpId) {
        return this.addLabeledComposite(container, label, centerControl, null, helpId);
    }

    protected final Composite addLabeledComposite(Composite container, String labelText, Pane<?> centerPane, String helpId) {
        return this.addLabeledComposite(container, labelText, (Control)centerPane.getControl(), helpId);
    }

    protected final Composite addLabeledComposite(Composite container, String labelText, Control centerControl) {
        return this.addLabeledComposite(container, labelText, centerControl, null, null);
    }

    protected final Composite addLabeledComposite(Composite container, String labelText, Control centerControl, Control rightControl, String helpId) {
        return this.addLabeledComposite(container, (Control)this.addLabel(container, labelText), centerControl, rightControl, helpId);
    }

    protected final Composite addLabeledComposite(Composite container, String labelText, Control centerControl, String helpId) {
        Label label = this.addLabel(container, labelText);
        return this.addLabeledComposite(container, (Control)label, centerControl, helpId);
    }

    protected final Combo addLabeledEditableCombo(Composite container, String labelText, ModifyListener comboListener, Control rightControl, String helpId) {
        Combo combo = this.addEditableCombo(container);
        combo.addModifyListener(comboListener);
        this.addLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final Combo addLabeledEditableCombo(Composite container, String labelText, ModifyListener comboListener, String helpId) {
        return this.addLabeledEditableCombo(container, labelText, comboListener, null, helpId);
    }

    protected final Combo addLabeledEditableComboViewer(Composite container, String labelText, ModifyListener comboListener, ILabelProvider labelProvider, Control rightControl, String helpId) {
        ComboViewer comboViewer = this.addEditableComboViewer(container, (IBaseLabelProvider)labelProvider);
        Combo combo = comboViewer.getCombo();
        combo.addModifyListener(comboListener);
        this.addLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final Combo addLabeledEditableComboViewer(Composite container, String labelText, ModifyListener comboListener, ILabelProvider labelProvider, String helpId) {
        return this.addLabeledEditableComboViewer(container, labelText, comboListener, labelProvider, null, helpId);
    }

    protected final <V> Combo addLabeledEditableCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, String helpId) {
        return this.addLabeledEditableCombo(container, labelText, listHolder, selectedItemHolder, StringConverter.Default.instance(), null, helpId);
    }

    protected final <V> Combo addLabeledEditableCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, Control rightControl, String helpId) {
        Combo combo = this.addEditableCombo(container, listHolder, selectedItemHolder, stringConverter);
        this.addLabeledComposite(container, labelText, (Control)(combo.getParent() != container ? combo.getParent() : combo), rightControl, helpId);
        return combo;
    }

    protected final <V> Combo addLabeledEditableCombo(Composite container, String labelText, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter, String helpId) {
        return this.addLabeledEditableCombo(container, labelText, listHolder, selectedItemHolder, stringConverter, null, helpId);
    }

    protected final Text addLabeledMultiLineText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, int lineCount, String helpId) {
        Text text = this.addMultiLineText(container, textHolder, lineCount);
        container = this.addLabeledComposite(container, labelText, (Control)text, helpId);
        int textHeight = text.computeSize((int)-1, (int)-1).y;
        GridData gridData = (GridData)text.getLayoutData();
        gridData.heightHint = text.getLineHeight() * lineCount;
        Control label = container.getChildren()[0];
        int labelHeight = label.computeSize((int)-1, (int)-1).y;
        gridData = (GridData)label.getLayoutData();
        gridData.verticalAlignment = 128;
        gridData.verticalIndent += Math.abs(textHeight - labelHeight) / 2;
        return text;
    }

    protected final Text addLabeledPasswordText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder) {
        return this.addLabeledPasswordText(container, labelText, textHolder, null);
    }

    protected final Text addLabeledPasswordText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, Control rightControl, String helpId) {
        Text text = this.addPasswordText(container, textHolder);
        this.addLabeledComposite(container, labelText, (Control)text, rightControl, helpId);
        return text;
    }

    protected final Text addLabeledPasswordText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, String helpId) {
        return this.addLabeledPasswordText(container, labelText, textHolder, null, helpId);
    }

    protected final Spinner addLabeledSpinner(Composite parent, String labelText, WritablePropertyValueModel<Integer> numberHolder, int defaultValue, int minimumValue, int maximumValue, Control rightControl, String helpId) {
        Spinner spinner = this.addSpinner(parent, numberHolder, defaultValue, minimumValue, maximumValue, helpId);
        Label label = this.addLabel(parent, labelText);
        this.addLabeledComposite(parent, (Control)label, (Control)(spinner.getParent() != parent ? spinner.getParent() : spinner), rightControl, helpId);
        GridData gridData = (GridData)spinner.getLayoutData();
        gridData.horizontalAlignment = 1;
        return spinner;
    }

    protected final Spinner addSpinner(Composite parent, WritablePropertyValueModel<Integer> numberHolder, int defaultValue, int minimumValue, int maximumValue, String helpId) {
        Spinner spinner = this.addUnmanagedSpinner(parent, numberHolder, defaultValue, minimumValue, maximumValue, helpId);
        this.manageWidget((Control)spinner);
        return spinner;
    }

    private Spinner addUnmanagedSpinner(Composite parent, WritablePropertyValueModel<Integer> numberHolder, int defaultValue, int minimumValue, int maximumValue, String helpId) {
        Spinner spinner = this.widgetFactory.createSpinner(parent);
        spinner.setMinimum(minimumValue);
        spinner.setMaximum(maximumValue);
        GridData gridData = this.getFieldGridData();
        gridData.grabExcessHorizontalSpace = false;
        spinner.setLayoutData((Object)gridData);
        SpinnerModelAdapter.adapt(numberHolder, spinner, defaultValue);
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)spinner, helpId);
        }
        return spinner;
    }

    protected final DateTime addDateTime(Composite parent, WritablePropertyValueModel<Integer> hoursHolder, WritablePropertyValueModel<Integer> minutesHolder, WritablePropertyValueModel<Integer> secondsHolder, String helpId) {
        DateTime dateTime = this.addUnmanagedDateTime(parent, hoursHolder, minutesHolder, secondsHolder, helpId);
        this.manageWidget((Control)dateTime);
        return dateTime;
    }

    protected final DateTime addDateTime(Composite parent, WritablePropertyValueModel<Integer> hoursHolder, WritablePropertyValueModel<Integer> minutesHolder, WritablePropertyValueModel<Integer> secondsHolder, String helpId, PropertyValueModel<Boolean> enabledModel) {
        DateTime dateTime = this.addUnmanagedDateTime(parent, hoursHolder, minutesHolder, secondsHolder, helpId);
        this.controlEnabledState(enabledModel, new Control[]{dateTime});
        return dateTime;
    }

    private DateTime addUnmanagedDateTime(Composite parent, WritablePropertyValueModel<Integer> hoursHolder, WritablePropertyValueModel<Integer> minutesHolder, WritablePropertyValueModel<Integer> secondsHolder, String helpId) {
        DateTime dateTime = this.widgetFactory.createDateTime(parent, 128);
        DateTimeModelAdapter.adapt(hoursHolder, minutesHolder, secondsHolder, dateTime);
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)dateTime, helpId);
        }
        return dateTime;
    }

    private <V> Combo addUnmanagedEditableCombo(Composite container, ListValueModel<V> listHolder, WritablePropertyValueModel<V> selectedItemHolder, StringConverter<V> stringConverter) {
        Combo combo = this.addUnmanagedEditableCombo(container);
        ComboModelAdapter.adapt(listHolder, selectedItemHolder, combo, stringConverter);
        return combo;
    }

    private Combo addUnmanagedEditableCombo(Composite container) {
        Combo combo = this.widgetFactory.createEditableCombo(container);
        combo.setLayoutData((Object)this.getFieldGridData());
        return combo;
    }

    protected final Text addLabeledText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder) {
        return this.addLabeledText(container, labelText, textHolder, null);
    }

    protected final Text addLabeledText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, Control rightComponent, String helpId) {
        Text text = this.addText(container, textHolder);
        this.addLabeledComposite(container, labelText, (Control)text, rightComponent, helpId);
        return text;
    }

    protected final Text addLabeledText(Composite container, Label label, WritablePropertyValueModel<String> textHolder, Control rightComponent, String helpId) {
        Text text = this.addText(container, textHolder);
        this.addLabeledComposite(container, (Control)label, (Control)text, rightComponent, helpId);
        return text;
    }

    protected final Text addLabeledText(Composite container, String labelText, WritablePropertyValueModel<String> textHolder, String helpId) {
        return this.addLabeledText(container, labelText, textHolder, null, helpId);
    }

    protected final Text addLabeledText(Composite container, Label label, WritablePropertyValueModel<String> textHolder, String helpId) {
        return this.addLabeledText(container, label, textHolder, null, helpId);
    }

    protected final List addList(Composite container, String helpId) {
        return this.addList(container, (WritablePropertyValueModel<String>)new SimplePropertyValueModel(), helpId);
    }

    protected final List addList(Composite container, WritablePropertyValueModel<String> selectionHolder, String helpId) {
        List list = this.addUnmanagedList(container, selectionHolder, helpId);
        this.manageWidget((Control)list);
        return list;
    }

    private List addUnmanagedList(Composite container, WritablePropertyValueModel<String> selectionHolder, String helpId) {
        List list = this.widgetFactory.createList(container, 2818);
        list.addSelectionListener(this.buildSelectionListener(selectionHolder));
        list.setLayoutData((Object)new GridData(1808));
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)list, helpId);
        }
        return list;
    }

    protected final FormText addMultiLineLabel(Composite container, String labelText) {
        FormText label = this.widgetFactory.createMultiLineLabel(container, labelText);
        this.manageWidget((Control)label);
        return label;
    }

    protected final Text addMultiLineText(Composite container) {
        Text text = this.widgetFactory.createMultiLineText(container);
        text.setLayoutData((Object)this.getFieldGridData());
        this.manageWidget((Control)text);
        return text;
    }

    protected final Text addMultiLineText(Composite container, int lineCount, String helpId) {
        Text text = this.addMultiLineText(container);
        this.adjustMultiLineTextLayout(container, lineCount, (Control)text, text.getLineHeight());
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)text, helpId);
        }
        return text;
    }

    protected final Text addMultiLineText(Composite container, WritablePropertyValueModel<String> textHolder, int lineCount) {
        return this.addMultiLineText(container, textHolder, lineCount, null);
    }

    protected final Text addMultiLineText(Composite container, WritablePropertyValueModel<String> textHolder, int lineCount, String helpId) {
        Text text = this.addMultiLineText(container, lineCount, helpId);
        SWTTools.bind(textHolder, text);
        return text;
    }

    protected final void adjustMultiLineTextLayout(Composite container, int lineCount, Control text, int lineHeight) {
        int textHeight = text.computeSize((int)-1, (int)-1).y;
        GridData gridData = (GridData)text.getLayoutData();
        if (gridData == null) {
            gridData = this.getFieldGridData();
            text.setLayoutData((Object)gridData);
        }
        gridData.heightHint = lineHeight * lineCount;
        Control label = container.getChildren()[0];
        int labelHeight = label.computeSize((int)-1, (int)-1).y;
        gridData = (GridData)label.getLayoutData();
        gridData.verticalAlignment = 128;
        gridData.verticalIndent += Math.abs(textHeight - labelHeight) / 2;
    }

    protected final PageBook addPageBook(Composite container) {
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        return pageBook;
    }

    protected final Composite addPane(Composite parent) {
        return this.widgetFactory.createComposite(parent);
    }

    protected final Composite addPane(Composite container, Layout layout) {
        container = this.addPane(container);
        container.setLayout(layout);
        container.setLayoutData((Object)new GridData(768));
        return container;
    }

    protected final Text addPasswordText(Composite container, WritablePropertyValueModel<String> textHolder) {
        Text text = this.addPasswordText(container);
        SWTTools.bind(textHolder, text);
        return text;
    }

    protected final Text addPasswordText(Composite container) {
        Text text = this.widgetFactory.createPasswordText(container);
        text.setLayoutData((Object)this.getFieldGridData());
        this.manageWidget((Control)text);
        return text;
    }

    protected final Button addPushButton(Composite parent, String buttonText, Runnable buttonAction) {
        return this.addPushButton(parent, buttonText, null, buttonAction);
    }

    protected final Button addPushButton(Composite parent, String buttonText, String helpId, final Runnable buttonAction) {
        Button button = this.widgetFactory.createPushButton(parent, buttonText);
        this.manageWidget((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTUtil.asyncExec(buttonAction);
            }
        });
        button.setLayoutData((Object)new GridData());
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)button, helpId);
        }
        return button;
    }

    protected final Button addRadioButton(Composite parent, String buttonText, WritablePropertyValueModel<Boolean> booleanHolder, String helpId) {
        return this.addToggleButton(parent, buttonText, booleanHolder, helpId, 16);
    }

    protected final Composite addSection(Composite container, String sectionText) {
        return this.addSection(container, sectionText, 256);
    }

    private Composite addSection(Composite container, String sectionText, int type) {
        return this.addSection(container, sectionText, null, type);
    }

    protected final Composite addSection(Composite container, String sectionText, String description) {
        return this.addSection(container, sectionText, description, 256);
    }

    private Composite addSection(Composite container, String sectionText, String description, int type) {
        Section section = this.widgetFactory.createSection(container, type | (description != null ? 128 : 0));
        section.setLayoutData((Object)new GridData(768));
        section.setText(sectionText);
        section.marginWidth = 0;
        section.marginHeight = 0;
        if (description != null) {
            section.setDescription(description);
        }
        Composite subPane = this.addSubPane((Composite)section);
        section.setClient((Control)subPane);
        return subPane;
    }

    private SelectionListener buildSelectionListener(final WritablePropertyValueModel<String> selectionHolder) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = (List)e.widget;
                String[] selectedItems = list.getSelection();
                if (selectedItems == null || selectedItems.length != 1) {
                    selectionHolder.setValue(null);
                } else {
                    selectionHolder.setValue((Object)selectedItems[0]);
                }
            }
        };
    }

    private Layout buildSpacerLayout() {
        return new Layout(){

            protected Point computeSize(Composite composite, int widthHint, int heightHint, boolean flushCache) {
                return new Point(widthHint, heightHint);
            }

            protected void layout(Composite composite, boolean flushCache) {
                GridData data = (GridData)composite.getLayoutData();
                composite.setBounds(0, 0, data.widthHint, data.heightHint);
            }
        };
    }

    private PropertyChangeListener buildSubjectChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildSubjectChangeListener_());
    }

    private PropertyChangeListener buildSubjectChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                Pane.this.subjectChanged((Model)e.getOldValue(), (Model)e.getNewValue());
            }
        };
    }

    protected final Composite addSubPane(Composite container) {
        return this.addSubPane(container, 0);
    }

    protected final Composite addSubPane(Composite container, int topMargin) {
        return this.addSubPane(container, topMargin, 0);
    }

    protected final Composite addSubPane(Composite container, int topMargin, int leftMargin) {
        return this.addSubPane(container, topMargin, leftMargin, 0, 0);
    }

    protected final Composite addSubPane(Composite container, int topMargin, int leftMargin, int bottomMargin, int rightMargin) {
        return this.addSubPane(container, 1, topMargin, leftMargin, bottomMargin, rightMargin);
    }

    protected final Composite addSubPane(Composite container, int columnCount, int topMargin, int leftMargin, int bottomMargin, int rightMargin) {
        GridLayout layout = new GridLayout(columnCount, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = topMargin;
        layout.marginLeft = leftMargin;
        layout.marginBottom = bottomMargin;
        layout.marginRight = rightMargin;
        container = this.addPane(container, (Layout)layout);
        return container;
    }

    protected final Composite addSubSection(Composite container, String sectionText) {
        return this.addCollapsibleSubSection(container, sectionText, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.TRUE));
    }

    protected final Table addTable(Composite container, int style, String helpId) {
        Table table = this.addUnmanagedTable(container, style, helpId);
        this.manageWidget((Control)table);
        return table;
    }

    protected final Table addUnmanagedTable(Composite container, int style, String helpId) {
        Table table = this.widgetFactory.createTable(container, style);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.heightHint = table.getItemHeight() * 4;
        table.setLayoutData((Object)gridData);
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)table, helpId);
        }
        return table;
    }

    protected final Table addTable(Composite container, String helpId) {
        return this.addTable(container, 66306, helpId);
    }

    protected final Table addUnmanagedTable(Composite container, String helpId) {
        return this.addUnmanagedTable(container, 66306, helpId);
    }

    protected final Text addText(Composite container) {
        Text text = this.addUnmanagedText(container);
        this.manageWidget((Control)text);
        return text;
    }

    private Text addUnmanagedText(Composite container) {
        Text text = this.widgetFactory.createText(container);
        text.setLayoutData((Object)this.getFieldGridData());
        return text;
    }

    protected final Text addText(Composite container, String helpId) {
        Text text = this.addText(container);
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)text, helpId);
        }
        return text;
    }

    private Text addUnmanagedText(Composite container, String helpId) {
        Text text = this.addUnmanagedText(container);
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)text, helpId);
        }
        return text;
    }

    protected final Text addText(Composite container, WritablePropertyValueModel<String> textHolder) {
        return this.addText(container, textHolder, null);
    }

    protected final Text addText(Composite container, WritablePropertyValueModel<String> textHolder, String helpId) {
        Text text = this.addText(container, helpId);
        SWTTools.bind(textHolder, text);
        return text;
    }

    protected final Text addText(Composite container, WritablePropertyValueModel<String> textHolder, String helpId, PropertyValueModel<Boolean> enabledModel) {
        Text text = this.addUnmanagedText(container, textHolder, helpId);
        this.controlEnabledState(enabledModel, new Control[]{text});
        return text;
    }

    private Text addUnmanagedText(Composite container, WritablePropertyValueModel<String> textHolder, String helpId) {
        Text text = this.addUnmanagedText(container, helpId);
        SWTTools.bind(textHolder, text);
        return text;
    }

    protected final Group addTitledGroup(Composite container, String title) {
        return this.addTitledGroup(container, title, null);
    }

    protected final Group addTitledGroup(Composite container, String title, String helpId) {
        return this.addTitledGroup(container, title, 1, helpId);
    }

    protected final Group addTitledGroup(Composite container, String title, int columnCount, String helpId) {
        Group group = this.widgetFactory.createGroup(container, title);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(columnCount, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginBottom = 5;
        layout.marginRight = 5;
        group.setLayout((Layout)layout);
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)group, helpId);
        }
        return group;
    }

    private Button addUnmanagedToggleButton(Composite parent, String buttonText, WritablePropertyValueModel<Boolean> booleanHolder, String helpId, int toggleButtonType) {
        Button button = toggleButtonType == 8 ? this.widgetFactory.createPushButton(parent, buttonText) : (toggleButtonType == 16 ? this.widgetFactory.createRadioButton(parent, buttonText) : (toggleButtonType == 32 ? this.widgetFactory.createCheckBox(parent, buttonText) : this.widgetFactory.createButton(parent, buttonText)));
        button.setLayoutData((Object)new GridData());
        SWTTools.bind(booleanHolder, button);
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)button, helpId);
        }
        return button;
    }

    private Button addToggleButton(Composite parent, String buttonText, WritablePropertyValueModel<Boolean> booleanHolder, String helpId, int toggleButtonType) {
        Button button = this.addUnmanagedToggleButton(parent, buttonText, booleanHolder, helpId, toggleButtonType);
        this.manageWidget((Control)button);
        return button;
    }

    protected final TriStateCheckBox addTriStateCheckBox(Composite parent, String text, WritablePropertyValueModel<Boolean> booleanHolder, String helpId) {
        TriStateCheckBox checkBox = new TriStateCheckBox(parent, text, this.getWidgetFactory());
        this.manageWidget((Control)checkBox.getCheckBox());
        TriStateCheckBoxModelAdapter.adapt(booleanHolder, checkBox);
        if (helpId != null) {
            this.getHelpSystem().setHelp((Control)checkBox.getCheckBox(), helpId);
        }
        return checkBox;
    }

    protected final TriStateCheckBox addTriStateCheckBoxWithDefault(Composite parent, String text, WritablePropertyValueModel<Boolean> booleanHolder, PropertyValueModel<String> stringHolder, String helpId) {
        TriStateCheckBox checkBox = this.addTriStateCheckBox(parent, text, booleanHolder, helpId);
        new LabeledControlUpdater(new LabeledButton(checkBox.getCheckBox()), stringHolder);
        return checkBox;
    }

    protected void doPopulate() {
        this.log("/debug/ui/layout", "   ->doPopulate()");
    }

    private void controlEnabledState(PropertyValueModel<Boolean> booleanModel, Control ... controls) {
        this.controlEnabledState_(this.wrapEnabledModel(booleanModel), controls);
    }

    private PropertyValueModel<Boolean> wrapEnabledModel(PropertyValueModel<Boolean> booleanModel) {
        return new TransformationPropertyValueModel(booleanModel, NonNullBooleanTransformer.FALSE);
    }

    private void controlEnabledState_(PropertyValueModel<Boolean> booleanModel, Control ... controls) {
        SWTTools.controlEnabledState(this.andEnabledModel(booleanModel), controls);
    }

    private PropertyValueModel<Boolean> getCombinedEnabledModel() {
        return this.combinedEnabledModel != null ? this.combinedEnabledModel : this.baseEnabledModel;
    }

    private boolean getCombinedEnablement() {
        Boolean enabled = (Boolean)this.getCombinedEnabledModel().getValue();
        return enabled == null ? true : enabled;
    }

    private PropertyValueModel<Boolean> andEnabledModel(PropertyValueModel<Boolean> booleanModel) {
        return CompositeBooleanPropertyValueModel.and((PropertyValueModel[])new PropertyValueModel[]{this.getCombinedEnabledModel(), booleanModel});
    }

    protected void controllerEnablementChanged() {
        this.enableWidgets_(this.getCombinedEnablement());
    }

    public void enableWidgets(boolean enabled) {
        this.baseEnabledModel.setValue((Object)enabled);
        this.enableWidgets_(this.getCombinedEnablement());
    }

    private void enableWidgets_(boolean enabled) {
        if (!this.container.isDisposed()) {
            for (Control control : this.managedWidgets) {
                control.setEnabled(enabled);
            }
            for (Pane pane : this.managedSubPanes) {
                pane.enableWidgets(enabled);
            }
        }
    }

    private void engageSubjectHolder() {
        this.subjectHolder.addPropertyChangeListener("value", this.subjectChangeListener);
    }

    protected void engageListeners(T subject) {
        if (subject != null) {
            this.engageListeners_(subject);
        }
    }

    protected void engageListeners_(T subject) {
        this.log("/debug/ui/layout", "   ->engageListeners_(" + subject + ')');
        for (String propertyName : this.getPropertyNames()) {
            subject.addPropertyChangeListener(propertyName, this.aspectChangeListener);
        }
    }

    protected void disengageListeners(T subject) {
        if (subject != null) {
            this.disengageListeners_(subject);
        }
    }

    protected void disengageListeners_(T subject) {
        this.log("/debug/ui/layout", "   ->disengageListeners_(" + subject + ')');
        for (String propertyName : this.getPropertyNames()) {
            subject.removePropertyChangeListener(propertyName, this.aspectChangeListener);
        }
    }

    private void disengageSubjectHolder() {
        this.subjectHolder.removePropertyChangeListener("value", this.subjectChangeListener);
    }

    public Composite getControl() {
        return this.container;
    }

    protected final PropertyValueModel<T> getSubjectHolder() {
        return this.subjectHolder;
    }

    protected final WidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    protected final int getGroupBoxMargin() {
        Group group = this.widgetFactory.createGroup((Composite)SWTUtil.getShell(), "");
        Rectangle clientArea = group.getClientArea();
        group.dispose();
        return clientArea.x + 5;
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    protected final boolean isPopulating() {
        return this.populating;
    }

    protected void log(String flag, String message) {
        if (flag.equals("/debug/ui/layout") && Tracing.booleanDebugOption("/debug/ui/layout")) {
            this.log(message);
        }
    }

    protected void log(String message) {
        Class<?> thisClass = this.getClass();
        String className = thisClass.getSimpleName();
        if (thisClass.isAnonymousClass()) {
            className = className.substring(0, className.indexOf(36));
            className = String.valueOf(className) + "->" + thisClass.getSuperclass().getSimpleName();
        }
        Tracing.log(String.valueOf(className) + ": " + message);
    }

    private void populate() {
        if (!this.container.isDisposed()) {
            this.log("/debug/ui/layout", "populate()");
            this.repopulate();
        }
    }

    protected void propertyChanged(String propertyName) {
    }

    protected Collection<String> getPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        this.addPropertyNames(propertyNames);
        return propertyNames;
    }

    protected final void removeAlignLeft(Pane<?> pane) {
        this.leftControlAligner.remove(pane.leftControlAligner);
    }

    protected final void removeAlignLeft(Control control) {
        this.leftControlAligner.remove(control);
    }

    protected final void removeAlignRight(Pane<?> pane) {
        this.rightControlAligner.remove(pane.rightControlAligner);
    }

    protected final void removeAlignRight(Control control) {
        this.rightControlAligner.remove(control);
    }

    protected final void removePaneForAlignment(Pane<?> pane) {
        this.removeAlignLeft(pane);
        this.removeAlignRight(pane);
    }

    protected final void repopulate() {
        this.log("/debug/ui/layout", "   ->repopulate()");
        try {
            this.setPopulating(true);
            this.doPopulate();
        }
        finally {
            this.setPopulating(false);
        }
        for (Pane<?> subPane : this.subPanes) {
            subPane.repopulate();
        }
    }

    protected final void setPopulating(boolean populating) {
        this.populating = populating;
    }

    public void setVisible(boolean visible) {
        if (!this.container.isDisposed()) {
            this.container.setVisible(visible);
        }
    }

    public final Shell getShell() {
        return this.container.getShell();
    }

    public T getSubject() {
        return (T)((Model)this.subjectHolder.getValue());
    }

    protected final void subjectChanged(T oldSubject, T newSubject) {
        if (!this.container.isDisposed()) {
            this.log("/debug/ui/layout", "subjectChanged()");
            this.disengageListeners(oldSubject);
            this.repopulate();
            this.engageListeners(newSubject);
        }
    }

    protected final void registerSubPane(Pane<?> subPane) {
        this.subPanes.add(subPane);
    }

    protected final void unregisterSubPane(Pane<?> subPane) {
        this.subPanes.remove(subPane);
    }

    private void updatePane(String propertyName) {
        if (!this.isPopulating() && !this.container.isDisposed()) {
            this.populating = true;
            try {
                this.propertyChanged(propertyName);
            }
            finally {
                this.populating = false;
            }
        }
    }

    public void dispose() {
        this.log("/debug/ui/layout", "dispose()");
        this.disengageListeners(this.getSubject());
        this.disengageSubjectHolder();
        if (this.combinedEnabledModel != null && this.combinedEnabledModelListener != null) {
            this.combinedEnabledModel.removePropertyChangeListener("value", this.combinedEnabledModelListener);
        }
        this.leftControlAligner.dispose();
        this.rightControlAligner.dispose();
        for (Pane<?> subPane : this.subPanes) {
            subPane.dispose();
        }
    }
}

