/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionalClause
extends AbstractExpression {
    private AbstractExpression conditionalExpression;
    private boolean hasSpace;

    AbstractConditionalClause(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getConditionalExpression().accept(visitor);
    }

    @Override
    final void addChildrenTo(Collection<Expression> children) {
        children.add(this.getConditionalExpression());
    }

    @Override
    final void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression(this.getText()));
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.conditionalExpression != null) {
            children.add(this.conditionalExpression);
        }
    }

    public final Expression getConditionalExpression() {
        if (this.conditionalExpression == null) {
            this.conditionalExpression = this.buildNullExpression();
        }
        return this.conditionalExpression;
    }

    public final String getIdentifier() {
        return this.getText();
    }

    public final boolean hasConditionalExpression() {
        return this.conditionalExpression != null && !this.conditionalExpression.isNull();
    }

    public final boolean hasSpaceAfterIdentifier() {
        return this.hasSpace;
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return wordParser.character() == ')' || super.isParsingComplete(wordParser, word, expression);
    }

    final Expression parse(CharSequence expression, boolean tolerant) {
        this.conditionalExpression = this.parse(new WordParser(expression), (JPQLQueryBNF)AbstractConditionalClause.queryBNF("conditional_expression"), tolerant);
        this.hasSpace = true;
        return this.conditionalExpression;
    }

    @Override
    final void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward(this.getText());
        this.hasSpace = wordParser.skipLeadingWhitespace() > 0;
        this.conditionalExpression = this.parse(wordParser, (JPQLQueryBNF)AbstractConditionalClause.queryBNF("conditional_expression"), tolerant);
    }

    @Override
    boolean shouldSkipLiteral(AbstractExpression expression) {
        return false;
    }

    @Override
    final void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getText());
        if (this.hasSpace) {
            writer.append(' ');
        }
        if (this.conditionalExpression != null) {
            this.conditionalExpression.toParsedText(writer, includeVirtual);
        }
    }
}

