/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RangeVariableDeclaration
extends AbstractExpression {
    private AbstractExpression abstractSchemaName;
    private boolean hasAs;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterSchemaName;
    private AbstractExpression identificationVariable;
    private boolean virtualIdentificationVariable;

    RangeVariableDeclaration(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getAbstractSchemaName().accept(visitor);
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getAbstractSchemaName());
        children.add(this.getIdentificationVariable());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.abstractSchemaName != null) {
            children.add(this.abstractSchemaName);
        }
        if (this.hasSpaceAfterSchemaName) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasAs) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.identificationVariable != null) {
            children.add(this.identificationVariable);
        }
    }

    public Expression getAbstractSchemaName() {
        if (this.abstractSchemaName == null) {
            this.abstractSchemaName = this.buildNullExpression();
        }
        return this.abstractSchemaName;
    }

    public Expression getIdentificationVariable() {
        if (this.identificationVariable == null) {
            this.identificationVariable = this.buildNullExpression();
        }
        return this.identificationVariable;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return RangeVariableDeclaration.queryBNF("range_variable_declaration");
    }

    public boolean hasAbstractSchemaName() {
        return this.abstractSchemaName != null && !this.abstractSchemaName.isNull();
    }

    public boolean hasAs() {
        return this.hasAs;
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable != null && !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public boolean hasSpaceAfterAbstractSchemaName() {
        return this.hasSpaceAfterSchemaName;
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasVirtualIdentificationVariable() {
        return this.virtualIdentificationVariable;
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("SET") || word.equalsIgnoreCase("INNER") || word.equalsIgnoreCase("JOIN") || word.equalsIgnoreCase("LEFT") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        this.abstractSchemaName = this.parseAbstractSchemaName(wordParser, tolerant);
        this.hasSpaceAfterSchemaName = wordParser.skipLeadingWhitespace() > 0;
        this.hasAs = wordParser.startsWithIdentifier("AS");
        if (this.hasAs) {
            wordParser.moveForward("AS");
            boolean bl = this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        if (!wordParser.startsWithIdentifier("SET")) {
            this.identificationVariable = this.parseIdentificationVariable(wordParser, tolerant);
        }
    }

    private AbstractExpression parseAbstractSchemaName(WordParser wordParser, boolean tolerant) {
        if (tolerant) {
            if (wordParser.startsWithIdentifier("AS")) {
                return null;
            }
            return this.parse(wordParser, (JPQLQueryBNF)RangeVariableDeclaration.queryBNF("abstract_schema_name"), tolerant);
        }
        String word = wordParser.word();
        AbstractExpression expression = word.indexOf(46) != -1 ? new CollectionValuedPathExpression((AbstractExpression)this, word) : new AbstractSchemaName(this, word);
        expression.parse(wordParser, tolerant);
        return expression;
    }

    private AbstractExpression parseIdentificationVariable(WordParser wordParser, boolean tolerant) {
        if (tolerant) {
            return this.parse(wordParser, (JPQLQueryBNF)RangeVariableDeclaration.queryBNF("identification_variable"), tolerant);
        }
        IdentificationVariable expression = new IdentificationVariable(this, wordParser.word());
        ((AbstractExpression)expression).parse(wordParser, tolerant);
        return expression;
    }

    void setDeclaration(String abstractSchemaName, String identificationVariable) {
        this.abstractSchemaName = new AbstractSchemaName(this, abstractSchemaName);
        this.identificationVariable = new IdentificationVariable(this, identificationVariable);
        this.hasSpaceAfterSchemaName = true;
    }

    void setVirtualIdentificationVariable(String variableName) {
        this.virtualIdentificationVariable = true;
        this.identificationVariable = new IdentificationVariable(this, variableName, true);
    }

    public void setVirtualIdentificationVariable(String variableName, String path) {
        this.setVirtualIdentificationVariable(variableName);
        CollectionValuedPathExpression expression = new CollectionValuedPathExpression((AbstractExpression)this, path);
        expression.setVirtualIdentificationVariable(variableName);
        this.abstractSchemaName = expression;
    }

    @Override
    boolean shouldParseWithFactoryFirst() {
        return false;
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        if (this.abstractSchemaName != null) {
            this.abstractSchemaName.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterSchemaName) {
            writer.append(' ');
        }
        if (this.hasAs) {
            writer.append("AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.identificationVariable != null && !this.virtualIdentificationVariable) {
            this.identificationVariable.toParsedText(writer, includeVirtual);
        }
    }
}

