/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialogConfiguration;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentSearchListProvider;
import org.eclipse.wst.common.ui.internal.search.dialogs.ScopedComponentSearchListDialog;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Description;
import org.eclipse.wst.wsdl.ui.internal.edit.WSDLBindingSearchListProvider;
import org.eclipse.wst.wsdl.ui.internal.edit.WSDLComponentDescriptionProvider;
import org.eclipse.wst.wsdl.ui.internal.edit.WSDLInterfaceSearchListProvider;
import org.eclipse.wst.wsdl.ui.internal.edit.WSDLMessageSearchListProvider;
import org.eclipse.wst.wsdl.ui.internal.search.IWSDLSearchConstants;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;

public class W11BrowseComponentDialog
implements IComponentDialog {
    private QualifiedName qualifiedName;
    private ComponentSpecification selection;
    private W11Description description;

    public W11BrowseComponentDialog(QualifiedName qualifiedName, IFile iFile, W11Description description) {
        this.qualifiedName = qualifiedName;
        this.description = description;
    }

    public void setInitialSelection(ComponentSpecification componentSpecification) {
    }

    public ComponentSpecification getSelectedComponent() {
        return this.selection;
    }

    public int createAndOpen() {
        Definition definition = (Definition)this.description.getTarget();
        Shell shell = WSDLEditorPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        int returnValue = 1;
        ScopedComponentSearchListDialog dialog = null;
        if (this.qualifiedName == IWSDLSearchConstants.BINDING_META_NAME) {
            WSDLComponentDescriptionProvider descriptionProvider = new WSDLComponentDescriptionProvider();
            WSDLBindingSearchListProvider searchListProvider = new WSDLBindingSearchListProvider(definition);
            ComponentSearchListDialogConfiguration configuration = new ComponentSearchListDialogConfiguration();
            configuration.setFilterLabelText(Messages._UI_LABEL_NAME_FILTER);
            configuration.setDescriptionProvider((IComponentDescriptionProvider)descriptionProvider);
            configuration.setSearchListProvider((IComponentSearchListProvider)searchListProvider);
            String dialogTitle = Messages._UI_TITLE_SPECIFY_BINDING;
            dialog = new ScopedComponentSearchListDialog(shell, dialogTitle, configuration);
            IFile file = this.getFile();
            if (file != null) {
                dialog.setCurrentResource((IResource)file);
            }
        } else if (this.qualifiedName == IWSDLSearchConstants.PORT_TYPE_META_NAME) {
            WSDLComponentDescriptionProvider descriptionProvider = new WSDLComponentDescriptionProvider();
            WSDLInterfaceSearchListProvider searchListProvider = new WSDLInterfaceSearchListProvider(definition);
            ComponentSearchListDialogConfiguration configuration = new ComponentSearchListDialogConfiguration();
            configuration.setFilterLabelText(Messages._UI_LABEL_NAME_FILTER);
            configuration.setDescriptionProvider((IComponentDescriptionProvider)descriptionProvider);
            configuration.setSearchListProvider((IComponentSearchListProvider)searchListProvider);
            String dialogTitle = Messages._UI_TITLE_SPECIFY_PORTTYPE;
            dialog = new ScopedComponentSearchListDialog(shell, dialogTitle, configuration);
            IFile file = this.getFile();
            if (file != null) {
                dialog.setCurrentResource((IResource)file);
            }
        } else if (this.qualifiedName == IWSDLSearchConstants.MESSAGE_META_NAME) {
            WSDLComponentDescriptionProvider descriptionProvider = new WSDLComponentDescriptionProvider();
            WSDLMessageSearchListProvider searchListProvider = new WSDLMessageSearchListProvider(definition);
            ComponentSearchListDialogConfiguration configuration = new ComponentSearchListDialogConfiguration();
            configuration.setFilterLabelText(Messages._UI_LABEL_NAME_FILTER);
            configuration.setDescriptionProvider((IComponentDescriptionProvider)descriptionProvider);
            configuration.setSearchListProvider((IComponentSearchListProvider)searchListProvider);
            String dialogTitle = Messages._UI_TITLE_SPECIFY_MESSAGE;
            dialog = new ScopedComponentSearchListDialog(shell, dialogTitle, configuration);
            IFile file = this.getFile();
            if (file != null) {
                dialog.setCurrentResource((IResource)file);
            }
        }
        if (dialog != null) {
            dialog.setBlockOnOpen(true);
            dialog.create();
            returnValue = dialog.open();
            if (returnValue == 0) {
                this.selection = dialog.getSelectedComponent();
            }
        }
        return returnValue;
    }

    private IFile getFile() {
        IFile file = null;
        IEditorInput input = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        return file;
    }
}

