/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.main;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.IStylesheetEntriesChangedListener;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.main.StylesheetContentProvider;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;

public class StylesheetViewer {
    private TableViewer viewer;
    private final ListenerList listenerList = new ListenerList();

    public StylesheetViewer(Composite parent) {
        this.viewer = new TableViewer(parent);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private StylesheetContentProvider getStylesheetContentProvider() {
        return (StylesheetContentProvider)this.viewer.getContentProvider();
    }

    public void setEntries(LaunchTransform[] transforms) {
        this.getStylesheetContentProvider().setEntries(transforms);
        this.notifyChanged();
    }

    public LaunchTransform[] getEntries() {
        return (LaunchTransform[])this.getStylesheetContentProvider().getElements(null);
    }

    public Shell getShell() {
        return this.viewer.getControl().getShell();
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean updateSelection(int actionType, IStructuredSelection selection) {
        switch (actionType) {
            case 1: {
                return true;
            }
        }
        return selection.size() > 0;
    }

    public IStructuredSelection getSelectedEntries() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection;
    }

    public void addTransforms(LaunchTransform[] res) {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object beforeElement = sel.getFirstElement();
        if (this.getEntries().length > 1 && beforeElement == null) {
            beforeElement = this.getEntries()[this.getEntries().length - 1];
        }
        this.getStylesheetContentProvider().addEntries(res, beforeElement);
        this.notifyChanged();
    }

    public void removeEntries(LaunchTransform[] entries) {
        this.getStylesheetContentProvider().removeEntries(entries);
        this.notifyChanged();
    }

    public void addEntriesChangedListener(IStylesheetEntriesChangedListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeEntriesChangedListener(IStylesheetEntriesChangedListener listener) {
        this.listenerList.remove((Object)listener);
    }

    private void notifyChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ((IStylesheetEntriesChangedListener)element).entriesChanged(this);
            ++n2;
        }
    }
}

