/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.ReadOnlyWritablePropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class ReadOnlyWritablePropertyValueModelWrapperTests
extends TestCase {
    private WritablePropertyValueModel<String> objectHolder;
    PropertyChangeEvent event;
    private WritablePropertyValueModel<String> wrapperObjectHolder;
    PropertyChangeEvent wrapperEvent;

    public ReadOnlyWritablePropertyValueModelWrapperTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.objectHolder = new SimplePropertyValueModel((Object)"foo");
        this.wrapperObjectHolder = new ReadOnlyWritablePropertyValueModelWrapper(this.objectHolder);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testValue() {
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.wrapperObjectHolder.getValue()));
        this.objectHolder.setValue((Object)"bar");
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"bar", (String)((String)this.objectHolder.getValue()));
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"bar", (String)((String)this.wrapperObjectHolder.getValue()));
        this.objectHolder.setValue(null);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertNull((Object)this.objectHolder.getValue());
        ReadOnlyWritablePropertyValueModelWrapperTests.assertNull((Object)this.wrapperObjectHolder.getValue());
        this.objectHolder.setValue((Object)"foo");
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.wrapperObjectHolder.getValue()));
    }

    public void testSetValue() {
        boolean exceptionOccurred = false;
        try {
            this.wrapperObjectHolder.setValue((Object)"bar");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exceptionOccurred = true;
        }
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)exceptionOccurred);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.wrapperObjectHolder.getValue()));
    }

    public void testLazyListening() {
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        ChangeListener listener = this.buildWrapperListener();
        this.wrapperObjectHolder.addChangeListener(listener);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.wrapperObjectHolder.removeChangeListener(listener);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        this.wrapperObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.wrapperObjectHolder.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
    }

    public void testPropertyChange1() {
        this.objectHolder.addChangeListener(this.buildListener());
        this.wrapperObjectHolder.addChangeListener(this.buildWrapperListener());
        this.verifyPropertyChanges();
    }

    public void testPropertyChange2() {
        this.objectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildListener());
        this.wrapperObjectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildWrapperListener());
        this.verifyPropertyChanges();
    }

    private void verifyPropertyChanges() {
        this.event = null;
        this.wrapperEvent = null;
        this.objectHolder.setValue((Object)"bar");
        this.verifyEvent(this.event, this.objectHolder, "foo", "bar");
        this.verifyEvent(this.wrapperEvent, this.wrapperObjectHolder, "foo", "bar");
        this.event = null;
        this.wrapperEvent = null;
        this.objectHolder.setValue(null);
        this.verifyEvent(this.event, this.objectHolder, "bar", null);
        this.verifyEvent(this.wrapperEvent, this.wrapperObjectHolder, "bar", null);
        this.event = null;
        this.wrapperEvent = null;
        this.objectHolder.setValue((Object)"foo");
        this.verifyEvent(this.event, this.objectHolder, null, "foo");
        this.verifyEvent(this.wrapperEvent, this.wrapperObjectHolder, null, "foo");
    }

    private ChangeListener buildListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                ReadOnlyWritablePropertyValueModelWrapperTests.this.event = e;
            }
        };
    }

    private ChangeListener buildWrapperListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                ReadOnlyWritablePropertyValueModelWrapperTests.this.wrapperEvent = e;
            }
        };
    }

    private void verifyEvent(PropertyChangeEvent e, Object source, Object oldValue, Object newValue) {
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((Object)source, (Object)e.getSource());
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"value", (String)e.getPropertyName());
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((Object)oldValue, (Object)e.getOldValue());
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((Object)newValue, (Object)e.getNewValue());
    }
}

