/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.core.internal.ITagRegistryFactoryProvider;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.el.DefaultDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.el.DefaultDTVariableResolver;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.junit.Before;
import org.osgi.framework.Bundle;

public class TestJSF20ImplicitVariables
extends TestCase {
    private IType _testBean1Type;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;
    private JDTTestEnvironment _jdtTestEnvironment;
    private IFile _testJSP1;
    private static final String SRC_FOLDER_NAME = "src";
    private static final String PACKAGE_NAME = "com.test";
    private static final String TESTBEAN1_NAME = "TestBean1";
    private static final String ATTRS_SYMBOL_NAME = "attrs";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestJSF20ImplicitVariables_" + this.getName(), JavaFacet.VERSION_1_5, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.5"));
        projectTestEnvironment.createProject(true);
        IResource res = projectTestEnvironment.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", "testdata1.jsp");
        this._testJSP1 = (IFile)res;
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(projectTestEnvironment);
        this._jsfFactedTestEnvironment.initialize("2.0");
        IProject project = projectTestEnvironment.getTestProject();
        FacesConfigArtifactEdit edit = null;
        try {
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, null);
            FacesConfigType model = edit.getFacesConfig();
            ManagedBeanClassType beanClass = FacesConfigFactory.eINSTANCE.createManagedBeanClassType();
            beanClass.setTextContent("com.test.TestBean1");
            ManagedBeanNameType beanName = FacesConfigFactory.eINSTANCE.createManagedBeanNameType();
            beanName.setTextContent("testBean1");
            ManagedBeanScopeType beanScope = FacesConfigFactory.eINSTANCE.createManagedBeanScopeType();
            beanScope.setTextContent("session");
            ManagedBeanType bean = FacesConfigFactory.eINSTANCE.createManagedBeanType();
            bean.setManagedBeanClass(beanClass);
            bean.setManagedBeanName(beanName);
            bean.setManagedBeanScope(beanScope);
            model.getManagedBean().add((Object)bean);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle1.resources.data");
        this._jdtTestEnvironment.addResourceFile(SRC_FOLDER_NAME, (InputStream)new ByteArrayInputStream(input.toBytes()), "bundles", "bundle1.properties");
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/TestBean1.java.data", (String)TESTBEAN1_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._testBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1");
        TestJSF20ImplicitVariables.assertNotNull((Object)this._testBean1Type);
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider((ITagRegistryFactoryProvider)JSFCoreUtilHelper.createSimpleRegistryFactory());
    }

    public void testCCSymbol() {
        DefaultDTVariableResolver resolver = new DefaultDTVariableResolver();
        DTFacesContext context = DesignTimeApplicationManager.getInstance((IProject)this._jdtTestEnvironment.getJavaProject().getProject()).getFacesContext(this._testJSP1);
        ISymbol symbol = resolver.resolveVariable(context, "cc", (IAdaptable)this._testJSP1);
        TestJSF20ImplicitVariables.assertNotNull((Object)symbol);
        TestJSF20ImplicitVariables.assertTrue((boolean)(symbol instanceof IInstanceSymbol));
        TestJSF20ImplicitVariables.assertEquals((Object)ERuntimeSource.BUILT_IN_SYMBOL_LITERAL, (Object)((IInstanceSymbol)symbol).getRuntimeSource());
        DefaultDTPropertyResolver propresolver = new DefaultDTPropertyResolver();
        ISymbol[] props = propresolver.getAllProperties(symbol);
        this.assertContainsVariable(props, ATTRS_SYMBOL_NAME);
        ISymbol propSymbol = propresolver.getProperty(symbol, (Object)ATTRS_SYMBOL_NAME);
        TestJSF20ImplicitVariables.assertNotNull((Object)propSymbol);
        TestJSF20ImplicitVariables.assertTrue((boolean)(propSymbol instanceof IInstanceSymbol));
        ITypeDescriptor typeDesc = ((IInstanceSymbol)propSymbol).getTypeDescriptor();
        TestJSF20ImplicitVariables.assertTrue((boolean)(typeDesc instanceof IBoundedMapTypeDescriptor));
    }

    public void testComponentSymbol() {
        DefaultDTVariableResolver resolver = new DefaultDTVariableResolver();
        DTFacesContext context = DesignTimeApplicationManager.getInstance((IProject)this._jdtTestEnvironment.getJavaProject().getProject()).getFacesContext(this._testJSP1);
        ISymbol symbol = resolver.resolveVariable(context, "component", (IAdaptable)this._testJSP1);
        TestJSF20ImplicitVariables.assertNotNull((Object)symbol);
        TestJSF20ImplicitVariables.assertTrue((boolean)(symbol instanceof IInstanceSymbol));
        TestJSF20ImplicitVariables.assertEquals((Object)ERuntimeSource.BUILT_IN_SYMBOL_LITERAL, (Object)((IInstanceSymbol)symbol).getRuntimeSource());
        DefaultDTPropertyResolver propresolver = new DefaultDTPropertyResolver();
        ISymbol[] props = propresolver.getAllProperties(symbol);
        this.assertContainsVariable(props, ATTRS_SYMBOL_NAME);
        ISymbol propSymbol = propresolver.getProperty(symbol, (Object)ATTRS_SYMBOL_NAME);
        TestJSF20ImplicitVariables.assertNotNull((Object)propSymbol);
        TestJSF20ImplicitVariables.assertTrue((boolean)(propSymbol instanceof IInstanceSymbol));
        ITypeDescriptor typeDesc = ((IInstanceSymbol)propSymbol).getTypeDescriptor();
        TestJSF20ImplicitVariables.assertTrue((boolean)(typeDesc instanceof IBoundedMapTypeDescriptor));
    }

    public void testResourceSymbol() {
        DefaultDTVariableResolver resolver = new DefaultDTVariableResolver();
        DTFacesContext context = DesignTimeApplicationManager.getInstance((IProject)this._jdtTestEnvironment.getJavaProject().getProject()).getFacesContext(this._testJSP1);
        ISymbol symbol = resolver.resolveVariable(context, "resource", (IAdaptable)this._testJSP1);
        TestJSF20ImplicitVariables.assertNotNull((Object)symbol);
        TestJSF20ImplicitVariables.assertTrue((boolean)(symbol instanceof IInstanceSymbol));
        TestJSF20ImplicitVariables.assertEquals((Object)ERuntimeSource.BUILT_IN_SYMBOL_LITERAL, (Object)((IInstanceSymbol)symbol).getRuntimeSource());
        ITypeDescriptor typeDesc = ((IInstanceSymbol)symbol).getTypeDescriptor();
        TestJSF20ImplicitVariables.assertTrue((boolean)(typeDesc instanceof IBoundedMapTypeDescriptor));
    }

    public void testViewScopeSymbol() {
        DefaultDTVariableResolver resolver = new DefaultDTVariableResolver();
        DTFacesContext context = DesignTimeApplicationManager.getInstance((IProject)this._jdtTestEnvironment.getJavaProject().getProject()).getFacesContext(this._testJSP1);
        ISymbol symbol = resolver.resolveVariable(context, "viewScope", (IAdaptable)this._testJSP1);
        TestJSF20ImplicitVariables.assertNotNull((Object)symbol);
        TestJSF20ImplicitVariables.assertTrue((boolean)(symbol instanceof IInstanceSymbol));
        TestJSF20ImplicitVariables.assertEquals((Object)ERuntimeSource.BUILT_IN_SYMBOL_LITERAL, (Object)((IInstanceSymbol)symbol).getRuntimeSource());
        ITypeDescriptor typeDesc = ((IInstanceSymbol)symbol).getTypeDescriptor();
        TestJSF20ImplicitVariables.assertTrue((boolean)(typeDesc instanceof IBoundedMapTypeDescriptor));
    }

    public void testFlashScopeSymbol() {
        DefaultDTVariableResolver resolver = new DefaultDTVariableResolver();
        DTFacesContext context = DesignTimeApplicationManager.getInstance((IProject)this._jdtTestEnvironment.getJavaProject().getProject()).getFacesContext(this._testJSP1);
        ISymbol symbol = resolver.resolveVariable(context, "flash", (IAdaptable)this._testJSP1);
        TestJSF20ImplicitVariables.assertNotNull((Object)symbol);
        TestJSF20ImplicitVariables.assertTrue((boolean)(symbol instanceof IInstanceSymbol));
        TestJSF20ImplicitVariables.assertEquals((Object)ERuntimeSource.BUILT_IN_SYMBOL_LITERAL, (Object)((IInstanceSymbol)symbol).getRuntimeSource());
        ITypeDescriptor typeDesc = ((IInstanceSymbol)symbol).getTypeDescriptor();
        TestJSF20ImplicitVariables.assertTrue((boolean)(typeDesc instanceof IBoundedMapTypeDescriptor));
    }

    public void testGetAllVariables() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        DefaultDTVariableResolver variableResolver = new DefaultDTVariableResolver();
        ISymbol[] variables = variableResolver.getAllVariables(manager.getFacesContext(this._testJSP1), (IAdaptable)this._testJSP1);
        TestJSF20ImplicitVariables.assertEquals((int)19, (int)variables.length);
        this.assertContainsVariable(variables, "applicationScope");
        this.assertContainsVariable(variables, "sessionScope");
        this.assertContainsVariable(variables, "requestScope");
        this.assertContainsVariable(variables, "cookie");
        this.assertContainsVariable(variables, "facesContext");
        this.assertContainsVariable(variables, "header");
        this.assertContainsVariable(variables, "headerValues");
        this.assertContainsVariable(variables, "initParam");
        this.assertContainsVariable(variables, "param");
        this.assertContainsVariable(variables, "paramValues");
        this.assertContainsVariable(variables, "view");
        this.assertContainsVariable(variables, "viewScope");
        this.assertContainsVariable(variables, "flash");
        this.assertContainsVariable(variables, "cc");
        this.assertContainsVariable(variables, "component");
        this.assertContainsVariable(variables, "resource");
        this.assertContainsVariable(variables, "testBean1");
        this.assertContainsVariable(variables, "bundle");
        this.assertContainsVariable(variables, "row");
    }

    private void assertContainsVariable(ISymbol[] variables, String name) {
        ISymbol[] iSymbolArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol variable = iSymbolArray[n2];
            if (name.equals(variable.getName())) {
                TestJSF20ImplicitVariables.assertTrue((boolean)(variable instanceof IInstanceSymbol));
                return;
            }
            ++n2;
        }
        TestJSF20ImplicitVariables.fail((String)("Expected variable not found: " + name));
    }
}

