/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import java.util.Arrays;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AddAttributeFeatureTest {
    private IJPAEditorFeatureProvider featureProvider;
    private AddContext context;
    private JavaPersistentAttribute jpa;
    private ContainerShape entityShape;
    private ICustomFeature expandFeature;
    private IAddFeature graphicalAdd;

    @Before
    public void setUp() throws Exception {
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        this.jpa = (JavaPersistentAttribute)EasyMock.createMock(JavaPersistentAttribute.class);
        this.context = new AddContext();
        this.context.setNewObject((Object)this.jpa);
        this.context.setTargetContainer(this.entityShape);
        this.graphicalAdd = (IAddFeature)EasyMock.createMock(IAddFeature.class);
        this.expandFeature = (ICustomFeature)EasyMock.createMock(ICustomFeature.class);
    }

    @Test
    public void testAddNotJPA() {
        this.context.setNewObject(new Object());
        Assert.assertNull((Object)this.callAdd());
    }

    private void confgirueAttributeShape(ContainerShape attributeContainer) {
        ContainerShape attributeShape = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)this.jpa)).andReturn((Object)attributeShape);
        EasyMock.expect((Object)attributeShape.getContainer()).andReturn((Object)attributeContainer);
        EasyMock.replay((Object[])new Object[]{attributeShape});
    }

    private ContainerShape replayTextShape(Text text) {
        EList children = (EList)EasyMock.createMock(EList.class);
        children.add((Object)text);
        GraphicsAlgorithm ga = (GraphicsAlgorithm)EasyMock.createMock(GraphicsAlgorithm.class);
        EasyMock.expect((Object)ga.getGraphicsAlgorithmChildren()).andReturn((Object)children);
        EasyMock.replay((Object[])new Object[]{ga});
        ContainerShape textShape = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)textShape.getGraphicsAlgorithm()).andReturn((Object)ga);
        EasyMock.replay((Object[])new Object[]{textShape});
        return textShape;
    }

    private IDirectEditingInfo configureDirectEditing(Text text, ContainerShape textShape) {
        IDirectEditingInfo info = (IDirectEditingInfo)EasyMock.createMock(IDirectEditingInfo.class);
        info.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        info.setMainPictogramElement((PictogramElement)textShape);
        info.setPictogramElement((PictogramElement)textShape);
        EasyMock.expect((Object)this.featureProvider.getDirectEditingInfo()).andReturn((Object)info);
        EasyMock.replay((Object[])new Object[]{info});
        return info;
    }

    private ICustomContext createCustomContextMatcher(final PictogramElement[] elements) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
            }

            public boolean matches(Object argument) {
                if (!ICustomContext.class.isInstance(argument)) {
                    return false;
                }
                ICustomContext context = (ICustomContext)argument;
                return Arrays.equals(context.getPictogramElements(), elements);
            }
        });
        return null;
    }

    private IAddContext contextMatcher() {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
            }

            public boolean matches(Object argument) {
                if (!IAddContext.class.isInstance(argument)) {
                    return false;
                }
                IAddContext context = (IAddContext)argument;
                if (AddAttributeFeatureTest.this.jpa != context.getNewObject()) {
                    return false;
                }
                return AddAttributeFeatureTest.this.entityShape == context.getTargetContainer();
            }
        });
        return null;
    }

    private PictogramElement callAdd() {
        IAddFeature fixture = this.createFeature();
        return fixture.add((IAddContext)this.context);
    }

    @Test
    public void testGetFeatureProvider() {
        Assert.assertSame((Object)this.featureProvider, (Object)this.createFeature().getFeatureProvider());
    }

    @Test
    public void testCanAddObject() {
        this.context.setNewObject(new Object());
        Assert.assertEquals((Object)false, (Object)this.callCanAdd());
    }

    @Test
    public void testCanAddJpt() {
        Assert.assertEquals((Object)true, (Object)this.callCanAdd());
    }

    private boolean callCanAdd() {
        IAddFeature fixture = this.createFeature();
        boolean result = fixture.canAdd((IAddContext)this.context);
        return result;
    }

    private IAddFeature createFeature() {
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
        EasyMock.replay((Object[])new Object[]{this.graphicalAdd});
        EasyMock.replay((Object[])new Object[]{this.expandFeature});
        return new AddAttributeFeature((IFeatureProvider)this.featureProvider, this.graphicalAdd, this.expandFeature);
    }
}

