/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import java.util.LinkedList;
import org.easymock.EasyMock;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorImageCreator;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IPeServiceUtil;
import org.eclipse.swt.graphics.Point;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AddRelationFeatureTest {
    private IJPAEditorFeatureProvider featureProvider;
    private IJPAEditorImageCreator imageCreator;
    private IJPAEditorUtil jpaEditorUtil;
    private IDiagramTypeProvider diagramProvider;
    private Diagram diagram;
    private IAddConnectionContext context;
    private IPeServiceUtil peUtil;
    private IGaService gaUtil;
    private IAddBendpointFeature ft;
    private Resource resource;
    private static String OWNER_AT_NAME = "ownerAttr";
    private static String INVERSE_AT_NAME = "inverseAttr";

    @Before
    public void setUp() throws Exception {
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        this.imageCreator = (IJPAEditorImageCreator)EasyMock.createMock(IJPAEditorImageCreator.class);
        this.jpaEditorUtil = (IJPAEditorUtil)EasyMock.createMock(IJPAEditorUtil.class);
        this.diagramProvider = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        this.diagram = (Diagram)EasyMock.createMock(Diagram.class);
        this.context = (IAddConnectionContext)EasyMock.createMock(IAddConnectionContext.class);
        this.peUtil = (IPeServiceUtil)EasyMock.createMock(IPeServiceUtil.class);
        this.gaUtil = (IGaService)EasyMock.createMock(IGaService.class);
        this.ft = (IAddBendpointFeature)EasyMock.createMock(IAddBendpointFeature.class);
        TransactionalEditingDomain defaultTransEditDomain = (TransactionalEditingDomain)EasyMock.createMock(TransactionalEditingDomain.class);
        ResourceSet resourceSet = (ResourceSet)EasyMock.createMock(ResourceSet.class);
        EasyMock.expect((Object)defaultTransEditDomain.getResourceSet()).andStubReturn((Object)resourceSet);
        EList eAdapters = (EList)EasyMock.createMock(EList.class);
        EasyMock.expect((Object)resourceSet.eAdapters()).andStubReturn((Object)eAdapters);
        this.resource = (Resource)EasyMock.createMock(Resource.class);
        EasyMock.expect((Object)resourceSet.getResource((URI)EasyMock.isA(URI.class), EasyMock.anyBoolean())).andStubReturn((Object)this.resource);
        EasyMock.expect((Object)this.resource.getResourceSet()).andStubReturn((Object)resourceSet);
        EasyMock.replay((Object[])new Object[]{defaultTransEditDomain, resourceSet, this.resource});
    }

    @Test
    public void testCanAddNotAddConnectionContext() {
        IAddContext context = (IAddContext)EasyMock.createMock(IAddContext.class);
        this.verifyCanAdd(context, false);
    }

    @Test
    public void testCanAddNoRelation() throws Exception {
        IAddConnectionContext context = (IAddConnectionContext)EasyMock.createMock(IAddConnectionContext.class);
        Object notARelation = new Object();
        EasyMock.expect((Object)context.getNewObject()).andReturn(notARelation);
        this.verifyCanAdd((IAddContext)context, false);
    }

    @Test
    public void testCanAdd() throws Exception {
        IAddConnectionContext context = (IAddConnectionContext)EasyMock.createMock(IAddConnectionContext.class);
        IRelation relation = (IRelation)EasyMock.createMock(IRelation.class);
        EasyMock.replay((Object[])new Object[]{relation});
        EasyMock.expect((Object)context.getNewObject()).andReturn((Object)relation);
        this.verifyCanAdd((IAddContext)context, true);
    }

    @Test
    public void testGetFeatureProvider() {
        IAddFeature fixture = this.createFeature();
        Assert.assertSame((Object)this.featureProvider, (Object)fixture.getFeatureProvider());
    }

    private void expectManyEndDecorator(double location) {
        ConnectionDecorator d = (ConnectionDecorator)EasyMock.createMock(ConnectionDecorator.class);
        Polyline pl = (Polyline)EasyMock.createMock(Polyline.class);
        EasyMock.expect((Object)pl.getX()).andReturn((Object)0);
        EasyMock.expect((Object)pl.getY()).andReturn((Object)0);
        EasyMock.expect((Object)this.imageCreator.createManyEndDecorator((Connection)EasyMock.isA(Connection.class), EasyMock.eq((double)location))).andReturn((Object)d);
        EasyMock.expect((Object)d.getGraphicsAlgorithm()).andReturn((Object)pl);
        EasyMock.replay((Object[])new Object[]{d, pl});
    }

    private void expectManyStartDecorator(double location) {
        ConnectionDecorator d = (ConnectionDecorator)EasyMock.createMock(ConnectionDecorator.class);
        Polyline pl = (Polyline)EasyMock.createMock(Polyline.class);
        EasyMock.expect((Object)pl.getX()).andReturn((Object)0);
        EasyMock.expect((Object)pl.getY()).andReturn((Object)0);
        EasyMock.expect((Object)this.imageCreator.createManyStartDecorator((Connection)EasyMock.isA(Connection.class), EasyMock.eq((double)location))).andReturn((Object)d);
        EasyMock.expect((Object)d.getGraphicsAlgorithm()).andReturn((Object)pl);
        EasyMock.replay((Object[])new Object[]{d, pl});
    }

    private void expectManyEndWithArrow(double location) {
        ConnectionDecorator d = (ConnectionDecorator)EasyMock.createMock(ConnectionDecorator.class);
        Polyline pl = (Polyline)EasyMock.createMock(Polyline.class);
        EasyMock.expect((Object)pl.getX()).andReturn((Object)0);
        EasyMock.expect((Object)pl.getY()).andReturn((Object)0);
        EasyMock.expect((Object)this.imageCreator.createManyEndWithArrowDecorator((Connection)EasyMock.isA(Connection.class), EasyMock.eq((double)location))).andReturn((Object)d);
        EasyMock.expect((Object)d.getGraphicsAlgorithm()).andReturn((Object)pl);
        EasyMock.replay((Object[])new Object[]{d, pl});
    }

    private void expectArrow(double location) {
        ConnectionDecorator d = (ConnectionDecorator)EasyMock.createMock(ConnectionDecorator.class);
        Polyline pl = (Polyline)EasyMock.createMock(Polyline.class);
        EasyMock.expect((Object)pl.getX()).andReturn((Object)0);
        EasyMock.expect((Object)pl.getY()).andReturn((Object)0);
        EasyMock.expect((Object)this.imageCreator.createArrowConnectionDecorator((Connection)EasyMock.isA(Connection.class), EasyMock.eq((double)location))).andReturn((Object)d);
        EasyMock.expect((Object)d.getGraphicsAlgorithm()).andReturn((Object)pl);
        EasyMock.replay((Object[])new Object[]{d, pl});
    }

    private void expectTextConnectionDecorator(String text, double location) {
        EasyMock.expect((Object)this.imageCreator.createCardinalityConnectionDecorator(this.diagram, (Connection)EasyMock.isA(Connection.class), (String)EasyMock.eq((Object)text), EasyMock.eq((double)location))).andReturn(null);
    }

    private void configureRelation(IRelation relation, IRelation.RelDir direction, IRelation.RelType type) {
        EasyMock.expect((Object)relation.getOwnerAttributeName()).andStubReturn((Object)OWNER_AT_NAME);
        EasyMock.expect((Object)relation.getInverseAttributeName()).andStubReturn((Object)INVERSE_AT_NAME);
        EasyMock.expect((Object)relation.getRelDir()).andStubReturn((Object)direction);
        EasyMock.expect((Object)relation.getRelType()).andStubReturn((Object)type);
    }

    private void configureProvidersForAdd(IRelation relation) {
        EasyMock.expect((Object)this.diagramProvider.getDiagram()).andReturn((Object)this.diagram);
        EasyMock.expect((Object)this.featureProvider.getDiagramTypeProvider()).andReturn((Object)this.diagramProvider);
        EasyMock.expect((Object)this.featureProvider.getPeUtil()).andReturn((Object)this.peUtil);
        EasyMock.expect((Object)this.featureProvider.getAddBendpointFeature((IAddBendpointContext)EasyMock.isA(IAddBendpointContext.class))).andStubReturn((Object)this.ft);
        EasyMock.expect((Object)this.context.getNewObject()).andReturn((Object)relation);
    }

    private void verifyAdd(IRelation relation, boolean expectId) {
        FreeFormConnection connection = this.configureConnection(relation, expectId);
        EasyMock.replay((Object[])new Object[]{connection});
        PictogramElement result = this.callAdd();
        Assert.assertSame((Object)connection, (Object)result);
        EasyMock.verify((Object[])new Object[]{this.context});
        EasyMock.verify((Object[])new Object[]{this.featureProvider});
        EasyMock.verify((Object[])new Object[]{this.imageCreator});
        EasyMock.verify((Object[])new Object[]{this.jpaEditorUtil});
        EasyMock.verify((Object[])new Object[]{this.diagram});
        EasyMock.verify((Object[])new Object[]{this.diagramProvider});
        EasyMock.verify((Object[])new Object[]{relation});
    }

    private PictogramElement callAdd() {
        IAddFeature fixture = this.createFeature();
        PictogramElement result = fixture.add((IAddContext)this.context);
        return result;
    }

    private FreeFormConnection configureConnection(IRelation relation, boolean expectId) {
        if (expectId) {
            EasyMock.expect((Object)relation.getId()).andStubReturn((Object)"someId");
        }
        EasyMock.replay((Object[])new Object[]{relation});
        this.configureProvidersForAdd(relation);
        Anchor startAnchor = this.replayAnchor();
        Anchor endAnchor = this.replayAnchor();
        EasyMock.expect((Object)this.context.getSourceAnchor()).andReturn((Object)startAnchor);
        EasyMock.expect((Object)this.context.getTargetAnchor()).andReturn((Object)endAnchor);
        this.gaUtil.setLocation((GraphicsAlgorithm)EasyMock.isA(Polyline.class), EasyMock.anyInt(), EasyMock.anyInt());
        this.gaUtil.setLocation((GraphicsAlgorithm)EasyMock.isA(Polyline.class), EasyMock.anyInt(), EasyMock.anyInt());
        FreeFormConnection connection = this.createConnection(startAnchor, endAnchor);
        EasyMock.expect((Object)this.peUtil.createFreeFormConnection(this.diagram)).andReturn((Object)connection);
        EasyMock.expect((Object)this.imageCreator.createConnectionLine(this.diagram, (Connection)connection)).andReturn(null);
        this.ft.addBendpoint((IAddBendpointContext)EasyMock.isA(IAddBendpointContext.class));
        LinkedList<Point> pts = new LinkedList<Point>();
        Point pt1 = new Point(100, 100);
        pts.add(pt1);
        EasyMock.expect((Object)this.jpaEditorUtil.createBendPointList(connection, false)).andReturn(pts);
        this.featureProvider.putKeyToBusinessObject("someId", (Object)relation);
        this.featureProvider.link((PictogramElement)EasyMock.eq((Object)connection), EasyMock.aryEq((Object[])new IRelation[]{relation}));
        EasyMock.expect((Object)this.featureProvider.layoutIfPossible((ILayoutContext)EasyMock.isA(ILayoutContext.class))).andReturn(null);
        return connection;
    }

    private Anchor replayAnchor() {
        Anchor startAnchor = (Anchor)EasyMock.createMock(Anchor.class);
        EasyMock.replay((Object[])new Object[]{startAnchor});
        return startAnchor;
    }

    private FreeFormConnection createConnection(Anchor startAnchor, Anchor endAnchor) {
        FreeFormConnection connection = (FreeFormConnection)EasyMock.createMock(FreeFormConnection.class);
        connection.setStart(startAnchor);
        connection.setEnd(endAnchor);
        connection.setVisible(true);
        connection.setActive(true);
        org.eclipse.graphiti.mm.algorithms.styles.Point pt = (org.eclipse.graphiti.mm.algorithms.styles.Point)EasyMock.createMock(org.eclipse.graphiti.mm.algorithms.styles.Point.class);
        EasyMock.expect((Object)pt.getX()).andStubReturn((Object)100);
        EasyMock.expect((Object)pt.getY()).andStubReturn((Object)100);
        org.eclipse.graphiti.mm.algorithms.styles.Point pt1 = (org.eclipse.graphiti.mm.algorithms.styles.Point)EasyMock.createMock(org.eclipse.graphiti.mm.algorithms.styles.Point.class);
        EasyMock.expect((Object)pt1.getX()).andStubReturn((Object)200);
        EasyMock.expect((Object)pt1.getY()).andStubReturn((Object)200);
        BasicInternalEList pts1 = new BasicInternalEList(org.eclipse.graphiti.mm.algorithms.styles.Point.class);
        pts1.add((Object)pt);
        pts1.add((Object)pt1);
        EasyMock.expect((Object)connection.getBendpoints()).andStubReturn((Object)pts1);
        EasyMock.replay((Object[])new Object[]{pt, pt1});
        return connection;
    }

    private void verifyCanAdd(IAddContext context, boolean expected) {
        EasyMock.replay((Object[])new Object[]{context});
        boolean result = this.callCanAdd(context);
        Assert.assertEquals((Object)expected, (Object)result);
        EasyMock.verify((Object[])new Object[]{context});
    }

    private boolean callCanAdd(IAddContext context) {
        IAddFeature fixture = this.createFeature();
        return fixture.canAdd(context);
    }

    private IAddFeature createFeature() {
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
        EasyMock.replay((Object[])new Object[]{this.imageCreator});
        EasyMock.replay((Object[])new Object[]{this.jpaEditorUtil});
        EasyMock.replay((Object[])new Object[]{this.diagramProvider});
        EasyMock.replay((Object[])new Object[]{this.diagram});
        EasyMock.replay((Object[])new Object[]{this.context});
        EasyMock.replay((Object[])new Object[]{this.peUtil});
        EasyMock.replay((Object[])new Object[]{this.gaUtil});
        EasyMock.replay((Object[])new Object[]{this.ft});
        return new AddRelationFeature((IFeatureProvider)this.featureProvider, this.imageCreator, this.jpaEditorUtil);
    }
}

