/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateDeleteOnlyAttributeTest {
    private IJPAEditorFeatureProvider featureProvider;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    JavaPersistentType jpt = null;

    @Before
    public void setUp() throws Exception {
        JptJpaCorePlugin.getJpaProjectManager();
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        IFile entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        this.jpt = (JavaPersistentType)JPACreateFactory.getPersistentType(entity);
        int c = 0;
        while (this.jpt == null && c < 100) {
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {}
            this.jpt = (JavaPersistentType)JPACreateFactory.getPersistentType(entity);
            ++c;
        }
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement((PictogramElement)EasyMock.isA(ContainerShape.class))).andStubReturn((Object)this.jpt);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(null)).andReturn((Object)JPACreateFactory.getPersistentType(entity));
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((JavaPersistentType)EasyMock.isA(JavaPersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)entity)).anyTimes();
        EasyMock.expect((Object)this.featureProvider.addIfPossible((IAddContext)EasyMock.isA(IAddContext.class))).andStubReturn(null);
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)this.jpt)).andStubReturn((Object)((PictogramElement)EasyMock.isA(ContainerShape.class)));
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)entity);
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit(this.jpt)).andStubReturn((Object)cu);
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
    }

    @Test
    public void testCreatePropertyAnnotatedAttribute() throws Exception {
        EntityAttributesChangeTestListener lsnr = new EntityAttributesChangeTestListener(0, 1);
        this.jpt.addListChangeListener("attributes", (ListChangeListener)lsnr);
        this.deleteAttribute("id");
        Assert.assertTrue((boolean)lsnr.waitForEvents());
        this.jpt.removeListChangeListener("attributes", (ListChangeListener)lsnr);
        lsnr = new EntityAttributesChangeTestListener(2, 0);
        this.jpt.addListChangeListener("attributes", (ListChangeListener)lsnr);
        JpaArtifactFactory.instance().makeNewAttribute((IFeatureProvider)this.featureProvider, this.jpt, this.featureProvider.getCompilationUnit(this.jpt), "aaa", "java.lang.String", null, "aaa", null, false, true);
        Assert.assertFalse((boolean)lsnr.waitForEvents());
        Assert.assertEquals((long)1L, (long)lsnr.incrementCounter);
        Assert.assertEquals((long)0L, (long)lsnr.decrementCounter);
    }

    @Test
    public void testCreateFieldAnnotatedAttribute() throws Exception {
        EntityAttributesChangeTestListener lsnr = new EntityAttributesChangeTestListener(0, 1);
        this.jpt.addListChangeListener("attributes", (ListChangeListener)lsnr);
        this.deleteAttribute("id");
        Assert.assertTrue((boolean)lsnr.waitForEvents());
        this.jpt.removeListChangeListener("attributes", (ListChangeListener)lsnr);
        lsnr = new EntityAttributesChangeTestListener(2, 0);
        this.jpt.addListChangeListener("attributes", (ListChangeListener)lsnr);
        JpaArtifactFactory.instance().makeNewAttribute((IFeatureProvider)this.featureProvider, this.jpt, this.featureProvider.getCompilationUnit(this.jpt), "aaa", "java.lang.String", null, "aaa", null, false, false);
        Assert.assertFalse((boolean)lsnr.waitForEvents());
        Assert.assertEquals((long)1L, (long)lsnr.incrementCounter);
        Assert.assertEquals((long)0L, (long)lsnr.decrementCounter);
    }

    @Test
    public void testDeletePropertyAnnotatedAttribute() throws Exception {
        EntityAttributesChangeTestListener lsnr = new EntityAttributesChangeTestListener(0, 2);
        this.jpt.addListChangeListener("attributes", (ListChangeListener)lsnr);
        this.deleteAttribute("id");
        Assert.assertFalse((boolean)lsnr.waitForEvents());
        Assert.assertEquals((long)0L, (long)lsnr.incrementCounter);
        Assert.assertEquals((long)1L, (long)lsnr.decrementCounter);
    }

    @Test
    public void testDeleteFieldAnnotatedAttribute() throws Exception {
        EntityAttributesChangeTestListener lsnr = new EntityAttributesChangeTestListener(1, 1);
        this.jpt.addListChangeListener("attributes", (ListChangeListener)lsnr);
        this.deleteAttribute("id");
        JpaArtifactFactory.instance().makeNewAttribute((IFeatureProvider)this.featureProvider, this.jpt, this.featureProvider.getCompilationUnit(this.jpt), "aaa", "java.lang.String", null, "aaa", null, false, false);
        Assert.assertTrue((boolean)lsnr.waitForEvents());
        this.jpt.removeListChangeListener("attributes", (ListChangeListener)lsnr);
        lsnr = new EntityAttributesChangeTestListener(0, 2);
        this.jpt.addListChangeListener("attributes", (ListChangeListener)lsnr);
        this.deleteAttribute("aaa");
        Assert.assertFalse((boolean)lsnr.waitForEvents());
        Assert.assertEquals((long)0L, (long)lsnr.incrementCounter);
        Assert.assertEquals((long)1L, (long)lsnr.decrementCounter);
    }

    private void deleteAttribute(String attrName) {
        JpaArtifactFactory.instance().deleteAttribute(this.jpt, attrName, this.featureProvider);
    }

    @After
    public void tearDown() throws Exception {
        this.deleteAllProjects();
    }

    private void deleteAllProjects() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = CreateDeleteOnlyAttributeTest.this.jpaProject.getProject();
                project.close(monitor);
                project.close(monitor);
                project.delete(true, true, monitor);
            }
        }, (IProgressMonitor)monitor);
    }

    public static class EntityAttributesChangeTestListener
    implements ListChangeListener {
        private Semaphore sem = new Semaphore(1);
        private int toBeAdded;
        private int toBeRemove;
        public int incrementCounter = 0;
        public int decrementCounter = 0;

        public EntityAttributesChangeTestListener(int add, int remove) {
            this.toBeAdded = add;
            this.toBeRemove = remove;
            try {
                this.sem.acquire(1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public boolean waitForEvents() throws InterruptedException {
            return this.sem.tryAcquire(5L, TimeUnit.SECONDS);
        }

        public void listChanged(ListChangeEvent event) {
        }

        public void itemsAdded(ListAddEvent arg0) {
            ++this.incrementCounter;
            if (this.incrementCounter >= this.toBeAdded && this.decrementCounter >= this.toBeRemove) {
                this.sem.release();
            }
        }

        public void itemsMoved(ListMoveEvent arg0) {
        }

        public void itemsRemoved(ListRemoveEvent arg0) {
            ++this.decrementCounter;
            if (this.incrementCounter >= this.toBeAdded && this.decrementCounter >= this.toBeRemove) {
                this.sem.release();
            }
        }

        public void itemsReplaced(ListReplaceEvent arg0) {
        }

        public void listCleared(ListClearEvent arg0) {
        }
    }
}

