/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ExceptionHandler;

public class ExceptionHandlerTests
extends TestCase {
    public ExceptionHandlerTests(String name) {
        super(name);
    }

    public void testNullExceptionHandler() {
        ExceptionHandler exceptionHandler = ExceptionHandler.Null.instance();
        exceptionHandler.handleException((Throwable)new NullPointerException());
    }

    public void testNullExceptionHandlerToString() {
        ExceptionHandler exceptionHandler = ExceptionHandler.Null.instance();
        ExceptionHandlerTests.assertNotNull((Object)exceptionHandler.toString());
    }

    public void testRuntimeExceptionHandler() {
        NullPointerException npe = new NullPointerException();
        ExceptionHandler exceptionHandler = ExceptionHandler.Runtime.instance();
        boolean exCaught = false;
        try {
            exceptionHandler.handleException((Throwable)npe);
            ExceptionHandlerTests.fail();
        }
        catch (RuntimeException ex) {
            ExceptionHandlerTests.assertSame((Object)npe, (Object)ex.getCause());
            exCaught = true;
        }
        ExceptionHandlerTests.assertTrue((boolean)exCaught);
    }

    public void testRuntimeExceptionHandlerToString() {
        ExceptionHandler exceptionHandler = ExceptionHandler.Runtime.instance();
        ExceptionHandlerTests.assertNotNull((Object)exceptionHandler.toString());
    }
}

