/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import org.eclipse.jpt.common.utility.internal.SynchronizedInt;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;

public class SynchronizedIntTests
extends MultiThreadedTestCase {
    private volatile SynchronizedInt si;
    volatile boolean timeoutOccurred;
    volatile int value = 7;
    volatile long startTime;
    volatile long endTime;
    volatile int sIntValue;

    public SynchronizedIntTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.si = new SynchronizedInt();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.sIntValue = 0;
    }

    public void testGetValue() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
    }

    public void testEqualsInt() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.equals(0));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.equals(7));
    }

    public void testNotEqualInt() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.notEqual(7));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.notEqual(0));
    }

    public void testIsZero() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isZero());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isZero());
    }

    public void testIsNotZero() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotZero());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotZero());
    }

    public void testIsGreaterThan() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThan(-1));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThan(0));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThan(1));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThan(-1));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThan(7));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThan(8));
    }

    public void testIsGreaterThanOrEqual() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThanOrEqual(-1));
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThanOrEqual(0));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThanOrEqual(1));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThanOrEqual(-1));
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThanOrEqual(7));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThanOrEqual(8));
    }

    public void testIsLessThan() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThan(-1));
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThan(0));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThan(1));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThan(-1));
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThan(7));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThan(8));
    }

    public void testIsLessThanOrEqual() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThanOrEqual(-1));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThanOrEqual(0));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThanOrEqual(1));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThanOrEqual(-1));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThanOrEqual(7));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThanOrEqual(8));
    }

    public void testIsPositive() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isPositive());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isPositive());
        this.si.setValue(-3);
        SynchronizedIntTests.assertFalse((boolean)this.si.isPositive());
    }

    public void testIsNotPositive() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotPositive());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotPositive());
        this.si.setValue(-3);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotPositive());
    }

    public void testIsNegative() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isNegative());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isNegative());
        this.si.setValue(-3);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNegative());
    }

    public void testIsNotNegative() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotNegative());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotNegative());
        this.si.setValue(-3);
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotNegative());
    }

    public void testSetValue() throws Exception {
        this.si.setValue(0);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotZero());
        SynchronizedIntTests.assertTrue((boolean)this.si.isZero());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.getValue());
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotZero());
        SynchronizedIntTests.assertFalse((boolean)this.si.isZero());
    }

    public void testAbs() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.abs());
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.abs());
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.abs());
    }

    public void testNeg() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.neg());
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)(-this.value), (int)this.si.neg());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.neg());
    }

    public void testSetZero() throws Exception {
        this.si.setZero();
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotZero());
        SynchronizedIntTests.assertTrue((boolean)this.si.isZero());
    }

    public void testGetMutexThis() throws Exception {
        SynchronizedIntTests.assertSame((Object)this.si, (Object)this.si.getMutex());
    }

    public void testWaitUntilZero() throws Exception {
        this.verifyWaitUntilZero(0L);
        SynchronizedIntTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TICK + "): " + time), (time > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilZeroTimeout() throws Exception {
        this.verifyWaitUntilZero(TICK);
        SynchronizedIntTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit late (expected value should be < " + THREE_TICKS + "): " + time), (time < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilZero(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetZeroCommand(), this.buildWaitUntilZeroCommand(t2Timeout));
    }

    public void testWaitToSetValue() throws Exception {
        this.verifyWaitToSetValue(0L);
        SynchronizedIntTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotZero());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TICK + "): " + time), (time > TICK ? 1 : 0) != 0);
    }

    public void testWaitToSetValueTimeout() throws Exception {
        this.verifyWaitToSetValue(TICK);
        SynchronizedIntTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertTrue((boolean)this.si.isZero());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit late (expected value should be < " + THREE_TICKS + "): " + time), (time < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToSetValue(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetZeroCommand(), this.buildWaitToSetValueCommand(t2Timeout));
    }

    public void testExecute() throws Exception {
        this.si.setValue(0);
        Runnable r1 = this.buildRunnable(this.buildInitializeValueCommand(), this.si, 0L);
        Runnable r2 = this.buildRunnable(this.buildGetValueCommand(), this.si, TICK);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)42, (int)this.sIntValue);
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TWO_TICKS + "): " + time), (time > TWO_TICKS ? 1 : 0) != 0);
    }

    private void executeThreads(Command t1Command, Command t2Command) throws Exception {
        this.si.setValue(this.value);
        Runnable r1 = this.buildRunnable(t1Command, this.si, TWO_TICKS);
        Runnable r2 = this.buildRunnable(t2Command, this.si, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildSetZeroCommand() {
        return new Command(){

            public void execute(SynchronizedInt sInt) {
                sInt.setZero();
            }
        };
    }

    private Command buildWaitUntilZeroCommand(final long timeout) {
        return new Command(){

            public void execute(SynchronizedInt sInt) throws InterruptedException {
                SynchronizedIntTests.this.startTime = System.currentTimeMillis();
                SynchronizedIntTests.this.timeoutOccurred = !sInt.waitUntilZero(timeout);
                SynchronizedIntTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Command buildWaitToSetValueCommand(final long timeout) {
        return new Command(){

            public void execute(SynchronizedInt sInt) throws InterruptedException {
                SynchronizedIntTests.this.startTime = System.currentTimeMillis();
                SynchronizedIntTests.this.timeoutOccurred = !sInt.waitToSetValue(SynchronizedIntTests.this.value, timeout);
                SynchronizedIntTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Command buildInitializeValueCommand() {
        return new Command(){

            public void execute(final SynchronizedInt sInt) throws InterruptedException {
                sInt.execute(new org.eclipse.jpt.common.utility.Command(){

                    public void execute() {
                        try {
                            Thread.sleep(5L * TICK);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                        sInt.setValue(42);
                    }
                });
            }
        };
    }

    private Command buildGetValueCommand() {
        return new Command(){

            public void execute(SynchronizedInt sInt) throws InterruptedException {
                SynchronizedIntTests.this.startTime = System.currentTimeMillis();
                SynchronizedIntTests.this.sIntValue = sInt.getValue();
                SynchronizedIntTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedInt sInt, final long sleep) {
        return new MultiThreadedTestCase.TestRunnable(this){

            protected void run_() throws InterruptedException {
                if (sleep != 0L) {
                    Thread.sleep(sleep);
                }
                command.execute(sInt);
            }
        };
    }

    private long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    private static interface Command {
        public void execute(SynchronizedInt var1) throws InterruptedException;
    }
}

