/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterables.TreeIterable;
import org.eclipse.jpt.common.utility.internal.iterators.TreeIterator;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIterableTests
extends TestCase {
    Collection<TreeNode> nodes = new ArrayList<TreeNode>();

    public TreeIterableTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator1() {
        for (TreeNode tn : this.buildTreeIterable1()) {
            TreeIterableTests.assertTrue((boolean)this.nodes.contains(tn));
        }
    }

    public void testIterator2() {
        for (TreeNode tn : this.buildTreeIterable2()) {
            TreeIterableTests.assertTrue((boolean)this.nodes.contains(tn));
        }
    }

    public void testMidwife1() {
        for (TreeNode tn : new TreeIterable((Object)this.buildTree(), this.buildMidwife())) {
            TreeIterableTests.assertTrue((boolean)this.nodes.contains(tn));
        }
    }

    public void testMidwife2() {
        for (TreeNode tn : new TreeIterable((Object[])new TreeNode[]{this.buildTree()}, this.buildMidwife())) {
            TreeIterableTests.assertTrue((boolean)this.nodes.contains(tn));
        }
    }

    public void testToString() {
        TreeIterableTests.assertNotNull((Object)this.buildTreeIterable1().toString());
    }

    public void testMissingMidwife() {
        boolean exCaught = false;
        try {
            for (TreeNode tn : new TreeIterable((Object)this.buildTree())) {
                TreeIterableTests.assertTrue((boolean)this.nodes.contains(tn));
            }
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        TreeIterableTests.assertTrue((boolean)exCaught);
    }

    private Iterable<TreeNode> buildTreeIterable1() {
        return new TreeIterable<TreeNode>(this.buildTree()){

            public Iterator<TreeNode> children(TreeNode next) {
                return next.children();
            }
        };
    }

    private Iterable<TreeNode> buildTreeIterable2() {
        return new TreeIterable<TreeNode>(new TreeNode[]{this.buildTree()}){

            public Iterator<TreeNode> children(TreeNode next) {
                return next.children();
            }
        };
    }

    private TreeIterator.Midwife<TreeNode> buildMidwife() {
        return new TreeIterator.Midwife<TreeNode>(){

            public Iterator<TreeNode> children(TreeNode next) {
                return next.children();
            }
        };
    }

    private TreeNode buildTree() {
        TreeNode root = new TreeNode("root");
        TreeNode child1 = new TreeNode(root, "child 1");
        new TreeNode(child1, "grandchild 1A");
        TreeNode child2 = new TreeNode(root, "child 2");
        new TreeNode(child2, "grandchild 2A");
        TreeNode grandchild2B = new TreeNode(child2, "grandchild 2B");
        new TreeNode(grandchild2B, "great-grandchild 2B1");
        new TreeNode(grandchild2B, "great-grandchild 2B2");
        TreeNode grandchild2C = new TreeNode(child2, "grandchild 2C");
        new TreeNode(grandchild2C, "great-grandchild 2C1");
        new TreeNode(root, "child 3");
        return root;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TreeNode {
        private String name;
        private Collection<TreeNode> children = new ArrayList<TreeNode>();

        public TreeNode(String name) {
            TreeIterableTests.this.nodes.add(this);
            this.name = name;
        }

        public TreeNode(TreeNode parent, String name) {
            this(name);
            parent.addChild(this);
        }

        public String getName() {
            return this.name;
        }

        private void addChild(TreeNode child) {
            this.children.add(child);
        }

        public Iterator<TreeNode> children() {
            return this.children.iterator();
        }

        public int childrenSize() {
            return this.children.size();
        }

        public String toString() {
            return "TreeNode(" + this.name + ")";
        }
    }
}

