/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.swing;

import java.util.Date;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.DateSpinnerModelAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class DateSpinnerModelAdapterTests
extends TestCase {
    private WritablePropertyValueModel<Object> valueHolder;
    private SpinnerModel spinnerModelAdapter;
    boolean eventFired;

    public DateSpinnerModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.valueHolder = new SimplePropertyValueModel((Object)new Date());
        this.spinnerModelAdapter = new DateSpinnerModelAdapter(this.valueHolder){

            protected PropertyChangeListener buildDateChangeListener() {
                return this.buildDateChangeListener_();
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSetValueSpinnerModel() throws Exception {
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DateSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        Date newDate = new Date();
        newDate.setTime(777777L);
        this.spinnerModelAdapter.setValue(newDate);
        DateSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        DateSpinnerModelAdapterTests.assertEquals((long)777777L, (long)((Date)this.valueHolder.getValue()).getTime());
    }

    public void testSetValueValueHolder() throws Exception {
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DateSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        Date newDate = new Date();
        newDate.setTime(777777L);
        this.valueHolder.setValue((Object)newDate);
        DateSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        DateSpinnerModelAdapterTests.assertEquals((long)777777L, (long)((Date)this.spinnerModelAdapter.getValue()).getTime());
    }

    public void testDefaultValue() throws Exception {
        Date newDate = new Date();
        newDate.setTime(777777L);
        this.valueHolder.setValue((Object)newDate);
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DateSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        DateSpinnerModelAdapterTests.assertEquals((long)777777L, (long)((Date)this.spinnerModelAdapter.getValue()).getTime());
        this.valueHolder.setValue(null);
        DateSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        DateSpinnerModelAdapterTests.assertFalse((((Date)this.spinnerModelAdapter.getValue()).getTime() == 777777L ? 1 : 0) != 0);
    }

    public void testHasListeners() throws Exception {
        SimplePropertyValueModel localValueHolder = (SimplePropertyValueModel)this.valueHolder;
        DateSpinnerModelAdapterTests.assertFalse((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.spinnerModelAdapter);
        TestChangeListener listener = new TestChangeListener();
        this.spinnerModelAdapter.addChangeListener(listener);
        DateSpinnerModelAdapterTests.assertTrue((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners(this.spinnerModelAdapter);
        this.spinnerModelAdapter.removeChangeListener(listener);
        DateSpinnerModelAdapterTests.assertFalse((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.spinnerModelAdapter);
    }

    private void verifyHasNoListeners(SpinnerModel adapter) throws Exception {
        DateSpinnerModelAdapterTests.assertEquals((int)0, (int)((DateSpinnerModelAdapter)adapter).getChangeListeners().length);
    }

    private void verifyHasListeners(Object adapter) throws Exception {
        DateSpinnerModelAdapterTests.assertFalse((((DateSpinnerModelAdapter)adapter).getChangeListeners().length == 0 ? 1 : 0) != 0);
    }

    public void testNullInitialValue() {
        Date today = new Date();
        this.valueHolder = new SimplePropertyValueModel();
        this.spinnerModelAdapter = new DateSpinnerModelAdapter(this.valueHolder, today){

            protected PropertyChangeListener buildDateChangeListener() {
                return this.buildDateChangeListener_();
            }
        };
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DateSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        DateSpinnerModelAdapterTests.assertEquals((Object)today, (Object)this.spinnerModelAdapter.getValue());
        Date newDate = new Date();
        newDate.setTime(777777L);
        this.valueHolder.setValue((Object)newDate);
        DateSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        DateSpinnerModelAdapterTests.assertEquals((long)777777L, (long)((Date)this.spinnerModelAdapter.getValue()).getTime());
    }

    private class TestChangeListener
    implements ChangeListener {
        TestChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            DateSpinnerModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

