/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.synchronizers;

import org.eclipse.jpt.common.utility.Command;
import org.eclipse.jpt.common.utility.internal.CompositeException;
import org.eclipse.jpt.common.utility.internal.ConsumerThreadCoordinator;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.synchronizers.AsynchronousSynchronizer;
import org.eclipse.jpt.common.utility.synchronizers.Synchronizer;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;

public class AsynchronousSynchronizerTests
extends MultiThreadedTestCase {
    PrimaryModel1 primaryModel1;
    SecondaryModel1 secondaryModel1;
    Command command1;
    Synchronizer synchronizer1;
    PrimaryModel2 primaryModel2;
    SecondaryModel2 secondaryModel2;
    Command command2;
    Synchronizer synchronizer2;

    public AsynchronousSynchronizerTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.primaryModel1 = new PrimaryModel1();
        this.secondaryModel1 = new SecondaryModel1(this.primaryModel1);
        this.command1 = new SynchronizeSecondaryModelCommand1(this.secondaryModel1);
        this.synchronizer1 = new AsynchronousSynchronizer(this.command1, this.buildThreadFactory());
        this.primaryModel1.setSynchronizer(this.synchronizer1);
        this.primaryModel2 = new PrimaryModel2();
        this.secondaryModel2 = new SecondaryModel2(this.primaryModel2);
        this.command2 = new SynchronizeSecondaryModelCommand2(this.primaryModel2, this.secondaryModel2);
        this.synchronizer2 = new AsynchronousSynchronizer(this.command2, this.buildThreadFactory());
        this.primaryModel2.setSynchronizer(this.synchronizer2);
    }

    protected void tearDown() throws Exception {
        this.synchronizer1.stop();
        this.synchronizer2.stop();
        super.tearDown();
    }

    public void testInitialization() {
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
    }

    public void testToString() {
        AsynchronousSynchronizerTests.assertNotNull((Object)this.synchronizer1.toString());
    }

    public void testChange() throws Exception {
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setCount(7);
        this.sleep(TICK);
        this.synchronizer1.stop();
        this.sleep(TICK);
        AsynchronousSynchronizerTests.assertEquals((int)14, (int)this.secondaryModel1.getDoubleCount());
        this.synchronizer1.start();
    }

    public void testStart() throws Exception {
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setSynchronizer(Synchronizer.Null.instance());
        this.primaryModel1.setCount(7);
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setSynchronizer(this.synchronizer1);
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setCount(8);
        this.sleep(TICK);
        this.synchronizer1.stop();
        this.sleep(TICK);
        AsynchronousSynchronizerTests.assertEquals((int)16, (int)this.secondaryModel1.getDoubleCount());
        this.synchronizer1.start();
    }

    public void testStop() throws Exception {
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.dispose();
        this.primaryModel1.setCount(7);
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.synchronizer1.start();
    }

    public void testDoubleStart() throws Exception {
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        boolean exCaught = false;
        try {
            this.primaryModel1.startSynchronizer();
            AsynchronousSynchronizerTests.fail();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        AsynchronousSynchronizerTests.assertTrue((boolean)exCaught);
        this.primaryModel1.setCount(7);
        this.sleep(TICK);
        this.synchronizer1.stop();
        this.sleep(TICK);
        AsynchronousSynchronizerTests.assertEquals((int)14, (int)this.secondaryModel1.getDoubleCount());
        this.synchronizer1.start();
    }

    public void testDoubleStop() throws Exception {
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.dispose();
        boolean exCaught = false;
        try {
            this.primaryModel1.dispose();
            AsynchronousSynchronizerTests.fail();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        AsynchronousSynchronizerTests.assertTrue((boolean)exCaught);
        this.primaryModel1.setCount(7);
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.synchronizer1.start();
    }

    public void testRecursiveChange() throws Exception {
        AsynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel2.getDoubleCount());
        this.primaryModel2.setCount(7);
        this.sleep(TICK);
        AsynchronousSynchronizerTests.assertEquals((int)10, (int)this.primaryModel2.getCountPlus3());
        AsynchronousSynchronizerTests.assertEquals((int)14, (int)this.secondaryModel2.getDoubleCount());
        this.sleep(TICK);
        AsynchronousSynchronizerTests.assertEquals((int)20, (int)this.secondaryModel2.getDoubleCountPlus3());
    }

    public void testNullCommand() {
        boolean exCaught = false;
        try {
            AsynchronousSynchronizer s = new AsynchronousSynchronizer(null, this.buildThreadFactory());
            AsynchronousSynchronizerTests.fail((String)("bogus: " + s));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AsynchronousSynchronizerTests.assertTrue((boolean)exCaught);
    }

    public void testThreadName() {
        AsynchronousSynchronizer s = new AsynchronousSynchronizer(this.command1, this.buildThreadFactory(), "sync");
        s.start();
        ConsumerThreadCoordinator ctc = (ConsumerThreadCoordinator)ReflectionTools.getFieldValue((Object)s, (String)"consumerThreadCoordinator");
        Thread t = (Thread)ReflectionTools.getFieldValue((Object)ctc, (String)"thread");
        AsynchronousSynchronizerTests.assertEquals((String)"sync", (String)t.getName());
        s.stop();
    }

    public void testSynchronizeCalledBeforeStart() throws Exception {
        SimpleCommand command = new SimpleCommand();
        AsynchronousSynchronizer synchronizer = new AsynchronousSynchronizer((Command)command, this.buildThreadFactory());
        synchronizer.synchronize();
        synchronizer.start();
        this.sleep(TICK);
        synchronizer.stop();
        AsynchronousSynchronizerTests.assertEquals((int)1, (int)command.count);
    }

    public void testException() throws Exception {
        BogusCommand command = new BogusCommand();
        AsynchronousSynchronizer synchronizer = new AsynchronousSynchronizer((Command)command, this.buildThreadFactory());
        synchronizer.start();
        synchronizer.synchronize();
        this.sleep(TICK);
        synchronizer.synchronize();
        this.sleep(TICK);
        boolean exCaught = false;
        try {
            synchronizer.stop();
            AsynchronousSynchronizerTests.fail();
        }
        catch (CompositeException ex) {
            AsynchronousSynchronizerTests.assertEquals((int)2, (int)ex.getExceptions().length);
            exCaught = true;
        }
        AsynchronousSynchronizerTests.assertTrue((boolean)exCaught);
        AsynchronousSynchronizerTests.assertEquals((int)2, (int)command.count);
    }

    public class BogusCommand
    implements Command {
        int count = 0;

        public void execute() {
            ++this.count;
            throw new NullPointerException();
        }
    }

    public static class PrimaryModel1 {
        protected Synchronizer synchronizer;
        protected int count = 2;

        public PrimaryModel1() {
            this.setSynchronizer_(Synchronizer.Null.instance());
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            if (count != this.count) {
                this.count = count;
                this.stateChanged();
            }
        }

        protected void stateChanged() {
            this.synchronizer.synchronize();
        }

        public void setSynchronizer(Synchronizer synchronizer) {
            if (synchronizer == null) {
                throw new NullPointerException();
            }
            this.synchronizer.stop();
            this.setSynchronizer_(synchronizer);
        }

        protected void setSynchronizer_(Synchronizer synchronizer) {
            this.synchronizer = synchronizer;
            this.synchronizer.start();
        }

        public void startSynchronizer() {
            this.synchronizer.start();
        }

        public void dispose() {
            this.synchronizer.stop();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('(');
            this.toString(sb);
            sb.append(')');
            return sb.toString();
        }

        public void toString(StringBuilder sb) {
            sb.append("count=");
            sb.append(this.count);
        }
    }

    public static class PrimaryModel2
    extends PrimaryModel1 {
        private int countPlus3 = this.count + 3;

        public int getCountPlus3() {
            return this.countPlus3;
        }

        protected void setCountPlus3(int countPlus3) {
            if (countPlus3 != this.countPlus3) {
                this.countPlus3 = countPlus3;
                this.stateChanged();
            }
        }

        public void synchronize() {
            this.setCountPlus3(this.count + 3);
        }

        public void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(", countPlus3=");
            sb.append(this.countPlus3);
        }
    }

    public static class SecondaryModel1 {
        protected final PrimaryModel1 primaryModel;
        protected int doubleCount = 0;

        public SecondaryModel1(PrimaryModel1 primaryModel) {
            this.primaryModel = primaryModel;
            this.synchronize();
        }

        public void synchronize() {
            this.doubleCount = this.primaryModel.getCount() * 2;
        }

        public int getDoubleCount() {
            return this.doubleCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('(');
            this.toString(sb);
            sb.append(')');
            return sb.toString();
        }

        public void toString(StringBuilder sb) {
            sb.append("doubleCount=");
            sb.append(this.doubleCount);
        }
    }

    public static class SecondaryModel2
    extends SecondaryModel1 {
        private int doubleCountPlus3 = 0;

        public SecondaryModel2(PrimaryModel2 extendedPrimaryModel) {
            super(extendedPrimaryModel);
        }

        protected PrimaryModel2 getExtendedPrimaryModel() {
            return (PrimaryModel2)this.primaryModel;
        }

        public void synchronize() {
            super.synchronize();
            int temp = this.getExtendedPrimaryModel().getCountPlus3() * 2;
            if (this.doubleCountPlus3 != temp) {
                this.doubleCountPlus3 = temp;
            }
        }

        public int getDoubleCountPlus3() {
            return this.doubleCountPlus3;
        }

        public void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(", doubleCountPlus3=");
            sb.append(this.doubleCountPlus3);
        }
    }

    public class SimpleCommand
    implements Command {
        int count = 0;

        public void execute() {
            ++this.count;
        }
    }

    public static class SynchronizeSecondaryModelCommand1
    implements Command {
        private final SecondaryModel1 secondaryModel;

        public SynchronizeSecondaryModelCommand1(SecondaryModel1 secondaryModel) {
            this.secondaryModel = secondaryModel;
        }

        public void execute() {
            this.secondaryModel.synchronize();
        }
    }

    public static class SynchronizeSecondaryModelCommand2
    extends SynchronizeSecondaryModelCommand1 {
        private final PrimaryModel2 primaryModel;

        public SynchronizeSecondaryModelCommand2(PrimaryModel2 primaryModel, SecondaryModel2 secondaryModel) {
            super(secondaryModel);
            this.primaryModel = primaryModel;
        }

        public void execute() {
            super.execute();
            this.primaryModel.synchronize();
        }
    }
}

