/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.beans.Introspector;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentClass;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentField;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentProperty;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceField;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorOrderAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSeeAlsoAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaPersistentClassTests
extends JaxbContextModelTestCase {
    public GenericJavaPersistentClassTests(String name) {
        super(name);
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private ICompilationUnit createXmlTypeWithAccessorType() throws CoreException {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAccessType", "javax.xml.bind.annotation.XmlAccessorType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
                sb.append("@XmlAccessorType(value = XmlAccessType.PROPERTY)");
            }
        });
    }

    private ICompilationUnit createXmlTypeWithAccessorOrder() throws CoreException {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAccessOrder", "javax.xml.bind.annotation.XmlAccessorOrder"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
                sb.append("@XmlAccessorOrder(value = XmlAccessOrder.ALPHABETICAL)");
            }
        });
    }

    private ICompilationUnit createPackageInfoWithAccessorType() throws CoreException {
        return this.createTestPackageInfo("@XmlAccessorType(value = XmlAccessType.PROPERTY)", new String[]{"javax.xml.bind.annotation.XmlAccessType", "javax.xml.bind.annotation.XmlAccessorType"});
    }

    private void createTestXmlTypeWithFieldAndPublicMemberAccess() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlAttribute");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlTransient");
                sb.append(";");
                sb.append(CR);
                sb.append("import java.util.List;");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" ");
                sb.append("{").append(CR);
                sb.append("    public int foo;").append(CR);
                sb.append(CR).append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createTestXmlTypeWithPropertyAndPublicMemberAccess() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlAttribute");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlTransient");
                sb.append(";");
                sb.append(CR);
                sb.append("import java.util.List;");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" ");
                sb.append("{").append(CR);
                sb.append("    public int getFoo() {").append(CR);
                sb.append("        return 1;").append(CR).append("    }").append(CR);
                sb.append("    public void setFoo(int foo) {}").append(CR).append(CR);
                sb.append(CR).append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createTestXmlTypeWithPropertyGetterAndPublicMemberAccess() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlAttribute");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlTransient");
                sb.append(";");
                sb.append(CR);
                sb.append("import java.util.List;");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" ");
                sb.append("{").append(CR);
                sb.append("    public int getFoo() {").append(CR);
                sb.append("        return 1;").append(CR).append("    }").append(CR);
                sb.append(CR).append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createTestXmlTypeWithPropertyGetterListAndPublicMemberAccess() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlAttribute");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlTransient");
                sb.append(";");
                sb.append(CR);
                sb.append("import java.util.List;");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" ");
                sb.append("{").append(CR);
                sb.append("    public List<?> getFoo() {").append(CR);
                sb.append("        return 1;").append(CR).append("    }").append(CR);
                sb.append(CR).append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createTestXmlTypeWithPropertySetterAndPublicMemberAccess() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlAttribute");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlTransient");
                sb.append(";");
                sb.append(CR);
                sb.append("import java.util.List;");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" ");
                sb.append("{").append(CR);
                sb.append("    public void setFoo(int foo) {}").append(CR).append(CR);
                sb.append(CR).append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    public void testModifyFactoryClass() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getFactoryClass());
        persistentClass.setFactoryClass("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryClass());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getFactoryClass());
        persistentClass.setFactoryClass(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertNull((Object)xmlTypeAnnotation.getFactoryClass());
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getFactoryClass());
        persistentClass.setSpecifiedAccessType(XmlAccessType.FIELD);
        resourceType.removeAnnotation("javax.xml.bind.annotation.XmlType");
        persistentClass.setFactoryClass("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryClass());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getFactoryClass());
    }

    public void testUpdateFactoryClass() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getFactoryClass());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addXmlTypeTypeMemberValuePair(declaration, "factoryClass", "Foo");
            }
        });
        GenericJavaPersistentClassTests.assertEquals((String)"Foo", (String)persistentClass.getFactoryClass());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaPersistentClassTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaPersistentClassTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getFactoryClass());
    }

    public void testModifyFactoryMethod() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getFactoryMethod());
        persistentClass.setFactoryMethod("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryMethod());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getFactoryMethod());
        persistentClass.setFactoryMethod(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertNull((Object)xmlTypeAnnotation.getFactoryMethod());
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getFactoryMethod());
        persistentClass.setSpecifiedAccessType(XmlAccessType.FIELD);
        resourceType.removeAnnotation("javax.xml.bind.annotation.XmlType");
        persistentClass.setFactoryMethod("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryMethod());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getFactoryMethod());
    }

    public void testUpdateFactoryMethod() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getFactoryMethod());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addXmlTypeMemberValuePair(declaration, "factoryMethod", "foo");
            }
        });
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getFactoryMethod());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaPersistentClassTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaPersistentClassTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getFactoryMethod());
    }

    public void testModifySchemaTypeName() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        String defaultXmlTypeName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedXmlTypeName());
        GenericJavaPersistentClassTests.assertEquals((String)defaultXmlTypeName, (String)persistentClass.getDefaultXmlTypeName());
        GenericJavaPersistentClassTests.assertEquals((String)defaultXmlTypeName, (String)persistentClass.getXmlTypeName());
        persistentClass.setSpecifiedXmlTypeName("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getName());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getSpecifiedXmlTypeName());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getXmlTypeName());
        persistentClass.setSpecifiedXmlTypeName(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertNull((Object)xmlTypeAnnotation.getName());
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedXmlTypeName());
        GenericJavaPersistentClassTests.assertEquals((String)defaultXmlTypeName, (String)persistentClass.getXmlTypeName());
        persistentClass.setSpecifiedAccessType(XmlAccessType.FIELD);
        resourceType.removeAnnotation("javax.xml.bind.annotation.XmlType");
        persistentClass.setSpecifiedXmlTypeName("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getName());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getSpecifiedXmlTypeName());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getXmlTypeName());
    }

    public void testUpdateSchemaTypeName() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        String defaultXmlTypeName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedXmlTypeName());
        GenericJavaPersistentClassTests.assertEquals((String)defaultXmlTypeName, (String)persistentClass.getDefaultXmlTypeName());
        GenericJavaPersistentClassTests.assertEquals((String)defaultXmlTypeName, (String)persistentClass.getXmlTypeName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addXmlTypeMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getSpecifiedXmlTypeName());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getXmlTypeName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaPersistentClassTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaPersistentClassTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedXmlTypeName());
        GenericJavaPersistentClassTests.assertEquals((String)defaultXmlTypeName, (String)persistentClass.getXmlTypeName());
    }

    public void testModifyNamespace() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"", (String)persistentClass.getDefaultNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"", (String)persistentClass.getNamespace());
        persistentClass.setSpecifiedNamespace("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getSpecifiedNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getNamespace());
        persistentClass.setSpecifiedNamespace(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertNull((Object)xmlTypeAnnotation.getNamespace());
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"", (String)persistentClass.getNamespace());
        persistentClass.setSpecifiedAccessType(XmlAccessType.FIELD);
        resourceType.removeAnnotation("javax.xml.bind.annotation.XmlType");
        persistentClass.setSpecifiedNamespace("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getSpecifiedNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"", (String)persistentClass.getDefaultNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"", (String)persistentClass.getNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addXmlTypeMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getSpecifiedNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaPersistentClassTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaPersistentClassTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedNamespace());
        GenericJavaPersistentClassTests.assertEquals((String)"", (String)persistentClass.getNamespace());
    }

    public void testModifyAccessType() throws Exception {
        this.createXmlTypeWithAccessorType();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)persistentClass.getSpecifiedAccessType());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)persistentClass.getAccessType());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)persistentClass.getDefaultAccessType());
        persistentClass.setSpecifiedAccessType(XmlAccessType.FIELD);
        XmlAccessorTypeAnnotation accessorTypeAnnotation = (XmlAccessorTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        GenericJavaPersistentClassTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType.FIELD, (Object)accessorTypeAnnotation.getValue());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.FIELD, (Object)persistentClass.getAccessType());
        persistentClass.setSpecifiedAccessType(XmlAccessType.PUBLIC_MEMBER);
        GenericJavaPersistentClassTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType.PUBLIC_MEMBER, (Object)accessorTypeAnnotation.getValue());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)persistentClass.getAccessType());
        persistentClass.setSpecifiedAccessType(XmlAccessType.NONE);
        GenericJavaPersistentClassTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType.NONE, (Object)accessorTypeAnnotation.getValue());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.NONE, (Object)persistentClass.getAccessType());
        persistentClass.setSpecifiedAccessType(null);
        accessorTypeAnnotation = (XmlAccessorTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        GenericJavaPersistentClassTests.assertNull((Object)accessorTypeAnnotation.getValue());
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedAccessType());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)persistentClass.getAccessType());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)persistentClass.getDefaultAccessType());
    }

    public void testUpdateAccessType() throws Exception {
        this.createXmlTypeWithAccessorType();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)persistentClass.getSpecifiedAccessType());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)persistentClass.getAccessType());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)persistentClass.getDefaultAccessType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", "javax.xml.bind.annotation.XmlAccessType.FIELD");
            }
        });
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.FIELD, (Object)persistentClass.getAccessType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
            }
        });
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)persistentClass.getAccessType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", "javax.xml.bind.annotation.XmlAccessType.NONE");
            }
        });
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.NONE, (Object)persistentClass.getAccessType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessorType");
            }
        });
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedAccessType());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)persistentClass.getAccessType());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)persistentClass.getDefaultAccessType());
    }

    public void testGetDefaultAccessType() throws Exception {
        this.createAnnotatedPersistentClass();
        this.createTestSubType();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentClass childPersistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)childPersistentClass.getDefaultAccessType());
        this.createPackageInfoWithAccessorType();
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)childPersistentClass.getDefaultAccessType());
        persistentClass.setSpecifiedAccessType(XmlAccessType.FIELD);
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)childPersistentClass.getDefaultAccessType());
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)CollectionTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        persistentClass.setSpecifiedAccessType(null);
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)childPersistentClass.getDefaultAccessType());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.FIELD);
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.FIELD, (Object)childPersistentClass.getDefaultAccessType());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.NONE);
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.NONE, (Object)childPersistentClass.getDefaultAccessType());
        contextPackageInfo.setSpecifiedAccessType(null);
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)childPersistentClass.getDefaultAccessType());
    }

    public void testGetSuperPersistentClass() throws Exception {
        this.createAnnotatedPersistentClass();
        this.createTestSubType();
        JaxbPersistentClass persistentClass = this.getContextRoot().getPersistentClass("test.AnnotationTestType");
        JaxbPersistentClass childPersistentClass = this.getContextRoot().getPersistentClass("test.AnnotationTestTypeChild");
        GenericJavaPersistentClassTests.assertEquals((Object)persistentClass, (Object)childPersistentClass.getSuperClass());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)persistentClass.getJavaResourceType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericJavaPersistentClassTests.assertNull((Object)childPersistentClass.getSuperClass());
    }

    public void testModifyAccessOrder() throws Exception {
        this.createXmlTypeWithAccessorOrder();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)persistentClass.getSpecifiedAccessOrder());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)persistentClass.getAccessOrder());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)persistentClass.getDefaultAccessOrder());
        persistentClass.setSpecifiedAccessOrder(XmlAccessOrder.UNDEFINED);
        XmlAccessorOrderAnnotation accessorOrderAnnotation = (XmlAccessorOrderAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        GenericJavaPersistentClassTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessOrder.UNDEFINED, (Object)accessorOrderAnnotation.getValue());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)persistentClass.getAccessOrder());
        persistentClass.setSpecifiedAccessOrder(null);
        accessorOrderAnnotation = (XmlAccessorOrderAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        GenericJavaPersistentClassTests.assertNull((Object)accessorOrderAnnotation.getValue());
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedAccessOrder());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)persistentClass.getAccessOrder());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)persistentClass.getDefaultAccessOrder());
    }

    public void testUpdateAccessOrder() throws Exception {
        this.createXmlTypeWithAccessorOrder();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)persistentClass.getSpecifiedAccessOrder());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)persistentClass.getAccessOrder());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)persistentClass.getDefaultAccessOrder());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorOrder", "javax.xml.bind.annotation.XmlAccessOrder.UNDEFINED");
            }
        });
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)persistentClass.getAccessOrder());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessorOrder");
            }
        });
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getSpecifiedAccessOrder());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)persistentClass.getAccessOrder());
        GenericJavaPersistentClassTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)persistentClass.getDefaultAccessOrder());
    }

    public void testGetPropOrder() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        ListIterator props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addProp(declaration, 0, "bar");
                GenericJavaPersistentClassTests.this.addProp(declaration, 1, "foo");
            }
        });
        props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
    }

    protected void addProp(ModifiedDeclaration declaration, int index, String prop) {
        this.addArrayElement(declaration, "javax.xml.bind.annotation.XmlType", index, "propOrder", (Expression)this.newStringLiteral(declaration.getAst(), prop));
    }

    public void testGetPropOrderSize() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)persistentClass.getPropOrderSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addProp(declaration, 0, "bar");
                GenericJavaPersistentClassTests.this.addProp(declaration, 1, "foo");
            }
        });
        GenericJavaPersistentClassTests.assertEquals((int)2, (int)persistentClass.getPropOrderSize());
    }

    public void testAddProp() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        persistentClass.addProp(0, "bar");
        persistentClass.addProp(0, "foo");
        persistentClass.addProp(0, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        ListIterator props = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
    }

    public void testAddProp2() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        persistentClass.addProp(0, "bar");
        persistentClass.addProp(1, "foo");
        persistentClass.addProp(0, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        ListIterator props = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
    }

    public void testRemoveProp() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        persistentClass.addProp(0, "bar");
        persistentClass.addProp(1, "foo");
        persistentClass.addProp(2, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        persistentClass.removeProp(1);
        ListIterator resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)resourceProps.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)resourceProps.hasNext());
        persistentClass.removeProp(1);
        resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)resourceProps.hasNext());
        persistentClass.removeProp(0);
        resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertFalse((boolean)resourceProps.hasNext());
    }

    public void testMoveProp() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        persistentClass.addProp(0, "bar");
        persistentClass.addProp(1, "foo");
        persistentClass.addProp(2, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaPersistentClassTests.assertEquals((int)3, (int)xmlTypeAnnotation.getPropOrderSize());
        persistentClass.moveProp(2, 0);
        ListIterator props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
        ListIterator resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((String)resourceProps.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)resourceProps.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
        persistentClass.moveProp(0, 1);
        props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
        resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)resourceProps.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((String)resourceProps.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
    }

    public void testSyncXmlNsPrefixes() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        ListIterator props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addProp(declaration, 0, "bar");
                GenericJavaPersistentClassTests.this.addProp(declaration, 1, "foo");
                GenericJavaPersistentClassTests.this.addProp(declaration, 2, "baz");
            }
        });
        props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertTrue((boolean)props.hasNext());
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.moveProp(declaration, 2, 0);
            }
        });
        props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertTrue((boolean)props.hasNext());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.moveProp(declaration, 0, 1);
            }
        });
        props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertTrue((boolean)props.hasNext());
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeProp(declaration, 1);
            }
        });
        props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertTrue((boolean)props.hasNext());
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeProp(declaration, 1);
            }
        });
        props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertTrue((boolean)props.hasNext());
        GenericJavaPersistentClassTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeProp(declaration, 0);
            }
        });
        props = persistentClass.getPropOrder().iterator();
        GenericJavaPersistentClassTests.assertFalse((boolean)props.hasNext());
    }

    protected void addXmlTypeMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlTypeAnnotation(declaration), name, value);
    }

    protected void addXmlTypeTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlTypeAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected Annotation getXmlTypeAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlType");
    }

    protected void moveProp(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)this.getXmlTypeAnnotation(declaration), "propOrder", targetIndex, sourceIndex);
    }

    protected void removeProp(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)this.getXmlTypeAnnotation(declaration), "propOrder", index);
    }

    public void testModifyXmlRootElement() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getRootElement());
        GenericJavaPersistentClassTests.assertFalse((boolean)persistentClass.isRootElement());
        persistentClass.setRootElement("foo");
        XmlRootElementAnnotation xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)xmlRootElementAnnotation.getName());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getRootElement().getName());
        GenericJavaPersistentClassTests.assertTrue((boolean)persistentClass.isRootElement());
        persistentClass.setRootElement(null);
        xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaPersistentClassTests.assertNull((Object)xmlRootElementAnnotation);
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getRootElement());
        GenericJavaPersistentClassTests.assertFalse((boolean)persistentClass.isRootElement());
    }

    public void testUpdateXmlRootElement() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getRootElement());
        GenericJavaPersistentClassTests.assertFalse((boolean)persistentClass.isRootElement());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation annotation = GenericJavaPersistentClassTests.this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlRootElement");
                GenericJavaPersistentClassTests.this.addMemberValuePair(annotation, "name", "foo");
            }
        });
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)persistentClass.getRootElement().getName());
        GenericJavaPersistentClassTests.assertTrue((boolean)persistentClass.isRootElement());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRootElement");
            }
        });
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getRootElement());
        GenericJavaPersistentClassTests.assertFalse((boolean)persistentClass.isRootElement());
    }

    public void testUpdateFieldAttributes() throws Exception {
        this.createTestXmlTypeWithFieldAndPublicMemberAccess();
        JaxbPersistentClass contextClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        this.publicFieldTest(contextClass);
        this.publicTransientFieldTest(contextClass);
        this.publicStaticFieldTest(contextClass);
        this.publicFinalFieldTest(contextClass);
        this.publicStaticFinalFieldTest(contextClass);
        this.privateFieldTest(contextClass);
        this.privateTransientFieldTest(contextClass);
        this.privateStaticFieldTest(contextClass);
        this.privateStaticFinalFieldTest(contextClass);
    }

    protected void publicFieldTest(JaxbPersistentClass contextClass) {
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        Iterator attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        JavaResourceField resourceField = ((JaxbPersistentField)contextClass.getAttributes().iterator().next()).getResourceField();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceField);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlTransient");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlTransient");
            }
        });
    }

    protected void publicTransientFieldTest(JaxbPersistentClass contextClass) {
        Iterator attributes = contextClass.getAttributes().iterator();
        JavaResourceField resourceField = ((JaxbPersistentField)attributes.next()).getResourceField();
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
    }

    protected void publicStaticFieldTest(JaxbPersistentClass contextClass) {
        Iterator attributes = contextClass.getAttributes().iterator();
        JavaResourceField resourceField = ((JaxbPersistentField)attributes.next()).getResourceField();
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.STATIC_KEYWORD);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    protected void publicFinalFieldTest(JaxbPersistentClass contextClass) {
        Iterator attributes = contextClass.getAttributes().iterator();
        JavaResourceField resourceField = ((JaxbPersistentField)attributes.next()).getResourceField();
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.FINAL_KEYWORD);
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    protected void publicStaticFinalFieldTest(JaxbPersistentClass contextClass) {
        Iterator attributes = contextClass.getAttributes().iterator();
        JavaResourceField resourceField = ((JaxbPersistentField)attributes.next()).getResourceField();
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    protected void privateFieldTest(JaxbPersistentClass contextClass) {
        Iterator attributes = contextClass.getAttributes().iterator();
        JavaResourceField resourceField = ((JaxbPersistentField)attributes.next()).getResourceField();
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceField);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    protected void privateTransientFieldTest(JaxbPersistentClass contextClass) {
        Iterator attributes = contextClass.getAttributes().iterator();
        JavaResourceField resourceField = ((JaxbPersistentField)attributes.next()).getResourceField();
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceField);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    protected void privateStaticFieldTest(JaxbPersistentClass contextClass) {
        Iterator attributes = contextClass.getAttributes().iterator();
        JavaResourceField resourceField = ((JaxbPersistentField)attributes.next()).getResourceField();
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceField);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    protected void privateStaticFinalFieldTest(JaxbPersistentClass contextClass) {
        Iterator attributes = contextClass.getAttributes().iterator();
        JavaResourceField resourceField = ((JaxbPersistentField)attributes.next()).getResourceField();
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceField);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
    }

    public void testUpdatePropertyAttributes() throws Exception {
        this.createTestXmlTypeWithPropertyAndPublicMemberAccess();
        JaxbPersistentClass contextClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        this.publicGetterSetterTest(contextClass);
        this.publicStaticGetterSetterTest(contextClass);
        this.privateGetterSetterTest(contextClass);
    }

    public void testUpdateGetterPropertyAttributes() throws Exception {
        this.createTestXmlTypeWithPropertyGetterAndPublicMemberAccess();
        JaxbPersistentClass contextClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        JavaResourceMethod resourceMethod = (JavaResourceMethod)contextClass.getJavaResourceType().getMethods().iterator().next();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        Iterator attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
    }

    public void testUpdateSetterPropertyAttributes() throws Exception {
        this.createTestXmlTypeWithPropertySetterAndPublicMemberAccess();
        JaxbPersistentClass contextClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        JavaResourceMethod resourceMethod = (JavaResourceMethod)contextClass.getJavaResourceType().getMethods().iterator().next();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        Iterator attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
    }

    public void testUpdateGetterListPropertyAttributes() throws Exception {
        this.createTestXmlTypeWithPropertyGetterListAndPublicMemberAccess();
        JaxbPersistentClass contextClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        Iterator attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        JavaResourceMethod resourceMethod = (JavaResourceMethod)contextClass.getJavaResourceType().getMethods().iterator().next();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
    }

    protected void publicGetterSetterTest(JaxbPersistentClass contextClass) {
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        Iterator attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        JavaResourceMethod resourceMethod = ((JaxbPersistentProperty)contextClass.getAttributes().iterator().next()).getResourceGetterMethod();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
    }

    protected void publicStaticGetterSetterTest(JaxbPersistentClass contextClass) {
        Iterator attributes = contextClass.getAttributes().iterator();
        JaxbPersistentProperty contextProperty = (JaxbPersistentProperty)attributes.next();
        JavaResourceMethod resourceGetter = contextProperty.getResourceGetterMethod();
        JavaResourceMethod resourceSetter = contextProperty.getResourceSetterMethod();
        this.addModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.STATIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.STATIC_KEYWORD);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceGetter);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.removeModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.STATIC_KEYWORD);
        this.removeModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    protected void privateGetterSetterTest(JaxbPersistentClass contextClass) {
        Iterator attributes = contextClass.getAttributes().iterator();
        JaxbPersistentProperty contextProperty = (JaxbPersistentProperty)attributes.next();
        JavaResourceMethod resourceGetter = contextProperty.getResourceGetterMethod();
        JavaResourceMethod resourceSetter = contextProperty.getResourceSetterMethod();
        this.removeModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.removeModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)0, (int)contextClass.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceGetter);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(contextClass, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaPersistentClassTests.assertEquals((int)1, (int)contextClass.getAttributesSize());
        attributes = contextClass.getAttributes().iterator();
        GenericJavaPersistentClassTests.assertEquals((String)"foo", (String)((JaxbPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentClassTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.removeModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        this.removeModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getXmlJavaTypeAdapter());
        GenericJavaPersistentClassTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        persistentClass.addXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaPersistentClassTests.assertNotNull((Object)persistentClass.getXmlJavaTypeAdapter());
        GenericJavaPersistentClassTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        persistentClass.removeXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getXmlJavaTypeAdapter());
        GenericJavaPersistentClassTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaPersistentClassTests.assertNotNull((Object)persistentClass.getXmlJavaTypeAdapter());
        GenericJavaPersistentClassTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getXmlJavaTypeAdapter());
        GenericJavaPersistentClassTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
    }

    public void testModifyXmlSeeAlso() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = this.getContextRoot().getPersistentClass("test.AnnotationTestType");
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        XmlSeeAlsoAnnotation annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getXmlSeeAlso());
        GenericJavaPersistentClassTests.assertNull((Object)annotation);
        persistentClass.addXmlSeeAlso();
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaPersistentClassTests.assertNotNull((Object)persistentClass.getXmlSeeAlso());
        GenericJavaPersistentClassTests.assertNotNull((Object)annotation);
        persistentClass.removeXmlSeeAlso();
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getXmlSeeAlso());
        GenericJavaPersistentClassTests.assertNull((Object)annotation);
    }

    public void testUpdateXmlSeeAlso() throws Exception {
        this.createAnnotatedPersistentClass();
        JaxbPersistentClass persistentClass = this.getContextRoot().getPersistentClass("test.AnnotationTestType");
        JavaResourceType resourceType = persistentClass.getJavaResourceType();
        XmlSeeAlsoAnnotation annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getXmlSeeAlso());
        GenericJavaPersistentClassTests.assertNull((Object)annotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSeeAlso");
            }
        });
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaPersistentClassTests.assertNotNull((Object)persistentClass.getXmlSeeAlso());
        GenericJavaPersistentClassTests.assertNotNull((Object)annotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSeeAlso");
            }
        });
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaPersistentClassTests.assertNull((Object)persistentClass.getXmlSeeAlso());
        GenericJavaPersistentClassTests.assertNull((Object)annotation);
    }

    protected void addModifiers(JavaResourceMember resourceMember, final Modifier.ModifierKeyword ... modifiers) {
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMember);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.addModifiers((BodyDeclaration)declaration.getDeclaration(), modifiers);
            }
        });
    }

    protected void removeModifiers(JavaResourceMember resourceMember, final Modifier.ModifierKeyword ... modifiers) {
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMember);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.removeModifiers((BodyDeclaration)declaration.getDeclaration(), modifiers);
            }
        });
    }

    protected void addModifiers(BodyDeclaration bodyDeclaration, Modifier.ModifierKeyword ... modifiers) {
        Modifier.ModifierKeyword[] modifierKeywordArray = modifiers;
        int n = modifiers.length;
        int n2 = 0;
        while (n2 < n) {
            Modifier.ModifierKeyword modifier = modifierKeywordArray[n2];
            this.modifiers(bodyDeclaration).add((IExtendedModifier)bodyDeclaration.getAST().newModifier(modifier));
            ++n2;
        }
    }

    protected void removeModifiers(BodyDeclaration bodyDeclaration, Modifier.ModifierKeyword ... modifierKeywords) {
        Modifier.ModifierKeyword[] modifierKeywordArray = modifierKeywords;
        int n = modifierKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            Modifier.ModifierKeyword modifierKeyWord = modifierKeywordArray[n2];
            Iterator<IExtendedModifier> stream = this.modifiers(bodyDeclaration).iterator();
            while (stream.hasNext()) {
                IExtendedModifier modifier = stream.next();
                if (!modifier.isModifier() || ((Modifier)modifier).getKeyword() != modifierKeyWord) continue;
                stream.remove();
                break;
            }
            ++n2;
        }
    }

    protected List<IExtendedModifier> modifiers(BodyDeclaration bodyDeclaration) {
        return bodyDeclaration.modifiers();
    }

    protected void setAccessTypeInJavaSource(JaxbPersistentClass contextClass, final String accessType) {
        JavaResourceType resourceClass = contextClass.getJavaResourceType();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceClass);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPersistentClassTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", accessType);
            }
        });
    }
}

