/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentClass;
import org.eclipse.jpt.jaxb.core.context.XmlAnyAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElementMapping;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlAnyAttributeMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlAnyAttributeMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlAnyAttribute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAnyAttribute"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAnyAttribute");
            }
        });
    }

    public void testChangeMappingType() throws Exception {
        this.createTypeWithXmlAnyAttribute();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlAnyAttributeMapping xmlAnyAttributeMapping = (XmlAnyAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyAttributeMapping.getParent().getJavaResourceAttribute();
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)xmlAnyAttributeMapping);
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyAttribute"));
        persistentAttribute.setMappingKey("xml-attribute");
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlAnyAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyAttribute"));
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-any-attribute");
        xmlAnyAttributeMapping = (XmlAnyAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)xmlAnyAttributeMapping);
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyAttribute"));
        GenericJavaXmlAnyAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-element");
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)xmlElementMapping);
        GenericJavaXmlAnyAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyAttribute"));
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        persistentAttribute.setMappingKey("xml-any-attribute");
        xmlAnyAttributeMapping = (XmlAnyAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)xmlAnyAttributeMapping);
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAnyAttribute"));
        GenericJavaXmlAnyAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlAnyAttribute();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlAnyAttributeMapping xmlAnyAttributeMapping = (XmlAnyAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyAttributeMapping.getParent().getJavaResourceAttribute();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAnyAttributeMappingTests.assertNull((Object)xmlAnyAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyAttributeMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        xmlAnyAttributeMapping.addXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)xmlAnyAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        xmlAnyAttributeMapping.removeXmlJavaTypeAdapter();
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlAnyAttribute();
        JaxbPersistentClass persistentClass = (JaxbPersistentClass)CollectionTools.get((Iterable)this.getContextRoot().getPersistentClasses(), (int)0);
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)persistentClass.getAttributes(), (int)0);
        XmlAnyAttributeMapping xmlAnyAttributeMapping = (XmlAnyAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAnyAttributeMapping.getParent().getJavaResourceAttribute();
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAnyAttributeMappingTests.assertNull((Object)xmlAnyAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyAttributeMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)xmlAnyAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyAttributeMappingTests.assertNotNull((Object)xmlJavaTypeAdapterAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAnyAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaXmlAnyAttributeMappingTests.assertNull((Object)xmlAnyAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAnyAttributeMappingTests.assertNull((Object)xmlJavaTypeAdapterAnnotation);
    }
}

