/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementDeclAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlElementDeclAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ELEMENT_DECL_NAME = "elementName";
    private static final String XML_ELEMENT_DECL_NAMESPACE = "XmlElementDeclNamespace";
    private static final String XML_ELEMENT_DECL_DEFAULT_VALUE = "myDefaultValue";
    private static final String XML_ELEMENT_DECL_SCOPE = "XmlElementDecl.GLOBAL";

    public XmlElementDeclAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlElementDecl() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementDecl"});
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementDecl");
            }
        });
    }

    private ICompilationUnit createTestXmlElementDeclWithName() throws Exception {
        return this.createTestXmlElementDeclWithStringElementDecl("name", XML_ELEMENT_DECL_NAME);
    }

    private ICompilationUnit createTestXmlElementDeclWithNamespace() throws Exception {
        return this.createTestXmlElementDeclWithStringElementDecl("namespace", XML_ELEMENT_DECL_NAMESPACE);
    }

    private ICompilationUnit createTestXmlElementDeclWithDefaultValue() throws Exception {
        return this.createTestXmlElementDeclWithStringElementDecl("defaultValue", XML_ELEMENT_DECL_DEFAULT_VALUE);
    }

    private ICompilationUnit createTestXmlElementDeclWithSubstitutionHeadName() throws Exception {
        return this.createTestXmlElementDeclWithStringElementDecl("substitutionHeadName", XML_ELEMENT_DECL_NAME);
    }

    private ICompilationUnit createTestXmlElementDeclWithSubstitutionHeadNamespace() throws Exception {
        return this.createTestXmlElementDeclWithStringElementDecl("substitutionHeadNamespace", XML_ELEMENT_DECL_NAME);
    }

    private ICompilationUnit createTestXmlElementDeclWithStringElementDecl(final String element, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementDecl"});
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementDecl(" + element + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestXmlElementDeclWithScope() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlElementDecl"});
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementDecl(scope = XmlElementDecl.GLOBAL.class)");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDeclWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertTrue((xmlElementDeclAnnotation != null ? 1 : 0) != 0);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_NAME, (String)xmlElementDeclAnnotation.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDecl();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertTrue((xmlElementDeclAnnotation != null ? 1 : 0) != 0);
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getName());
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getNamespace());
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getDefaultValue());
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getScope());
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getSubstitutionHeadName());
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getSubstitutionHeadNamespace());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDecl();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getName());
        xmlElementDeclAnnotation.setName(XML_ELEMENT_DECL_NAME);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_NAME, (String)xmlElementDeclAnnotation.getName());
        this.assertSourceContains("@XmlElementDecl(name = \"elementName\")", cu);
        xmlElementDeclAnnotation.setName(null);
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getName());
        this.assertSourceContains("@XmlElementDecl", cu);
        this.assertSourceDoesNotContain("@XmlElementDecl(name = \"elementName\")", cu);
    }

    public void testGetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDeclWithNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertTrue((xmlElementDeclAnnotation != null ? 1 : 0) != 0);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_NAMESPACE, (String)xmlElementDeclAnnotation.getNamespace());
    }

    public void testSetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDecl();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getNamespace());
        xmlElementDeclAnnotation.setNamespace(XML_ELEMENT_DECL_NAMESPACE);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_NAMESPACE, (String)xmlElementDeclAnnotation.getNamespace());
        this.assertSourceContains("@XmlElementDecl(namespace = \"XmlElementDeclNamespace\")", cu);
        xmlElementDeclAnnotation.setNamespace(null);
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getNamespace());
        this.assertSourceContains("@XmlElementDecl", cu);
        this.assertSourceDoesNotContain("@XmlElementDecl(namespace = \"XmlElementDeclNamespace\")", cu);
    }

    public void testGetDefaultValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDeclWithDefaultValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertTrue((xmlElementDeclAnnotation != null ? 1 : 0) != 0);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_DEFAULT_VALUE, (String)xmlElementDeclAnnotation.getDefaultValue());
    }

    public void testSetDefaultValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDecl();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getDefaultValue());
        xmlElementDeclAnnotation.setDefaultValue(XML_ELEMENT_DECL_DEFAULT_VALUE);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_DEFAULT_VALUE, (String)xmlElementDeclAnnotation.getDefaultValue());
        this.assertSourceContains("@XmlElementDecl(defaultValue = \"myDefaultValue\")", cu);
        xmlElementDeclAnnotation.setDefaultValue(null);
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getDefaultValue());
        this.assertSourceContains("@XmlElementDecl", cu);
        this.assertSourceDoesNotContain("@XmlElementDecl(defaultValue = \"myDefaultValue\")", cu);
    }

    public void testGetScope() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDeclWithScope();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertTrue((xmlElementDeclAnnotation != null ? 1 : 0) != 0);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_SCOPE, (String)xmlElementDeclAnnotation.getScope());
        XmlElementDeclAnnotationTests.assertEquals((String)"javax.xml.bind.annotation.XmlElementDecl.GLOBAL", (String)xmlElementDeclAnnotation.getFullyQualifiedScopeClassName());
    }

    public void testSetScope() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDecl();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getScope());
        xmlElementDeclAnnotation.setScope(XML_ELEMENT_DECL_SCOPE);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_SCOPE, (String)xmlElementDeclAnnotation.getScope());
        this.assertSourceContains("@XmlElementDecl(scope = XmlElementDecl.GLOBAL.class", cu);
        xmlElementDeclAnnotation.setScope(null);
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getScope());
        this.assertSourceContains("@XmlElementDecl", cu);
        this.assertSourceDoesNotContain("@XmlElementDecl(scope = XmlElementDecl.GLOBAL.class", cu);
    }

    public void testGetSubstitutionHeadName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDeclWithSubstitutionHeadName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertTrue((xmlElementDeclAnnotation != null ? 1 : 0) != 0);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_NAME, (String)xmlElementDeclAnnotation.getSubstitutionHeadName());
    }

    public void testSetSubstitutionHeadName() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDecl();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getSubstitutionHeadName());
        xmlElementDeclAnnotation.setSubstitutionHeadName(XML_ELEMENT_DECL_NAME);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_NAME, (String)xmlElementDeclAnnotation.getSubstitutionHeadName());
        this.assertSourceContains("@XmlElementDecl(substitutionHeadName = \"elementName\")", cu);
        xmlElementDeclAnnotation.setSubstitutionHeadName(null);
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getSubstitutionHeadName());
        this.assertSourceContains("@XmlElementDecl", cu);
        this.assertSourceDoesNotContain("@XmlElementDecl(substitutionHeadName = \"elementName\")", cu);
    }

    public void testGetSubstitutionHeadNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDeclWithSubstitutionHeadNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertTrue((xmlElementDeclAnnotation != null ? 1 : 0) != 0);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_NAME, (String)xmlElementDeclAnnotation.getSubstitutionHeadNamespace());
    }

    public void testSetSubstitutionHeadNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlElementDecl();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceMethod resourceMethod = this.getMethod(resourceType, 0);
        XmlElementDeclAnnotation xmlElementDeclAnnotation = (XmlElementDeclAnnotation)resourceMethod.getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getSubstitutionHeadNamespace());
        xmlElementDeclAnnotation.setSubstitutionHeadNamespace(XML_ELEMENT_DECL_NAME);
        XmlElementDeclAnnotationTests.assertEquals((String)XML_ELEMENT_DECL_NAME, (String)xmlElementDeclAnnotation.getSubstitutionHeadNamespace());
        this.assertSourceContains("@XmlElementDecl(substitutionHeadNamespace = \"elementName\")", cu);
        xmlElementDeclAnnotation.setSubstitutionHeadNamespace(null);
        XmlElementDeclAnnotationTests.assertNull((Object)xmlElementDeclAnnotation.getSubstitutionHeadNamespace());
        this.assertSourceContains("@XmlElementDecl", cu);
        this.assertSourceDoesNotContain("@XmlElementDecl(substitutionHeadNamespace = \"elementName\")", cu);
    }
}

