/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlRootElementAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ROOT_ELEMENT_NAME = "XmlRootElementName";
    private static final String XML_ROOT_ELEMENT_NAMESPACE = "XmlRootElementNamespace";

    public XmlRootElementAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlRootElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlRootElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlRootElement");
            }
        });
    }

    private ICompilationUnit createTestXmlRootElementWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlRootElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlRootElement(name = \"XmlRootElementName\")");
            }
        });
    }

    private ICompilationUnit createTestXmlRootElementWithNamespace() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlRootElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlRootElement(namespace = \"XmlRootElementNamespace\")");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlRootElementWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlRootElementAnnotation xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        XmlRootElementAnnotationTests.assertTrue((xmlRootElementAnnotation != null ? 1 : 0) != 0);
        XmlRootElementAnnotationTests.assertEquals((String)XML_ROOT_ELEMENT_NAME, (String)xmlRootElementAnnotation.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlRootElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlRootElementAnnotation xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        XmlRootElementAnnotationTests.assertTrue((xmlRootElementAnnotation != null ? 1 : 0) != 0);
        XmlRootElementAnnotationTests.assertNull((Object)xmlRootElementAnnotation.getName());
        XmlRootElementAnnotationTests.assertNull((Object)xmlRootElementAnnotation.getNamespace());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestXmlRootElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlRootElementAnnotation xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        XmlRootElementAnnotationTests.assertNull((Object)xmlRootElementAnnotation.getName());
        xmlRootElementAnnotation.setName(XML_ROOT_ELEMENT_NAME);
        XmlRootElementAnnotationTests.assertEquals((String)XML_ROOT_ELEMENT_NAME, (String)xmlRootElementAnnotation.getName());
        this.assertSourceContains("@XmlRootElement(name = \"XmlRootElementName\")", cu);
        xmlRootElementAnnotation.setName(null);
        XmlRootElementAnnotationTests.assertNull((Object)xmlRootElementAnnotation.getName());
        this.assertSourceContains("@XmlRootElement", cu);
        this.assertSourceDoesNotContain("@XmlRootElement(name = \"XmlRootElementName\")", cu);
    }

    public void testGetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlRootElementWithNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlRootElementAnnotation xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        XmlRootElementAnnotationTests.assertTrue((xmlRootElementAnnotation != null ? 1 : 0) != 0);
        XmlRootElementAnnotationTests.assertEquals((String)XML_ROOT_ELEMENT_NAMESPACE, (String)xmlRootElementAnnotation.getNamespace());
    }

    public void testSetNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlRootElement();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlRootElementAnnotation xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        XmlRootElementAnnotationTests.assertNull((Object)xmlRootElementAnnotation.getNamespace());
        xmlRootElementAnnotation.setNamespace(XML_ROOT_ELEMENT_NAMESPACE);
        XmlRootElementAnnotationTests.assertEquals((String)XML_ROOT_ELEMENT_NAMESPACE, (String)xmlRootElementAnnotation.getNamespace());
        this.assertSourceContains("@XmlRootElement(namespace = \"XmlRootElementNamespace\")", cu);
        xmlRootElementAnnotation.setNamespace(null);
        XmlRootElementAnnotationTests.assertNull((Object)xmlRootElementAnnotation.getNamespace());
        this.assertSourceContains("@XmlRootElement", cu);
        this.assertSourceDoesNotContain("@XmlRootElement(namespace = \"XmlRootElementNamespace\")", cu);
    }
}

