/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.utility.jdt;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTFieldAttribute;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTToolsTests
extends AnnotationTestCase {
    public ASTToolsTests(String name) {
        super(name);
    }

    private void createClassAndMembers(String className, String classBody) throws Exception {
        this.javaProject.createCompilationUnit("clazz", String.valueOf(className) + ".java", "public class " + className + " { " + classBody + " }");
    }

    private void createEnumAndMembers(String enumName, String enumBody) throws Exception {
        this.javaProject.createCompilationUnit("enums", String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }

    private void createAnnotationAndMembers(String annotationName, String annotationBody) throws Exception {
        this.javaProject.createCompilationUnit("annot", String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    private ICompilationUnit createTestType(final Iterator<String> imports, final String idFieldAnnotation) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return imports;
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(idFieldAnnotation);
            }
        });
    }

    public void testResolveEnum1() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        ICompilationUnit cu = this.createTestType("@annot.TestAnnotation(foo=enums.TestEnum.BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        JDTFieldAttribute field = this.idField(cu);
        String actual = ASTTools.resolveEnum((Name)((Name)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu)))));
        ASTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }

    public void testResolveEnum2() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        ICompilationUnit cu = this.createTestType("static enums.TestEnum.BAZ", "@annot.TestAnnotation(foo=BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        JDTFieldAttribute field = this.idField(cu);
        String actual = ASTTools.resolveEnum((Name)((Name)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu)))));
        ASTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }

    public void testResolveEnum3() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        ICompilationUnit cu = this.createTestType("static enums.TestEnum.*", "@annot.TestAnnotation(foo=BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        JDTFieldAttribute field = this.idField(cu);
        String actual = ASTTools.resolveEnum((Name)((Name)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu)))));
        ASTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }

    public void testResolveEnum4() throws Exception {
        this.createEnumAndMembers("TestEnum", "FOO, BAR, BAZ");
        this.createAnnotationAndMembers("TestAnnotation", "TestEnum foo();");
        ICompilationUnit cu = this.createTestType("enums.TestEnum", "@annot.TestAnnotation(foo=TestEnum.BAZ)");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"foo");
        JDTFieldAttribute field = this.idField(cu);
        String actual = ASTTools.resolveEnum((Name)((Name)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu)))));
        ASTToolsTests.assertEquals((String)"enums.TestEnum.BAZ", (String)actual);
    }

    public void testResolveFullyQualifiedNames() throws Exception {
        this.createClassAndMembers("OtherClass", "");
        this.createClassAndMembers("OtherClass2", "");
        this.createAnnotationAndMembers("TestAnnotation", "Class[] foo();");
        ICompilationUnit cu = this.createTestType((Iterator<String>)new ArrayIterator((Object[])new String[]{"clazz.OtherClass", "clazz.OtherClass2", "annot.TestAnnotation"}), "@TestAnnotation(foo={OtherClass.class, OtherClass2.class})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "foo", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forTypes());
        JDTFieldAttribute field = this.idField(cu);
        Iterable actual = ASTTools.resolveFullyQualifiedNames((Expression)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu))));
        ASTToolsTests.assertEquals((Object)CollectionTools.list((Object[])new String[]{"clazz.OtherClass", "clazz.OtherClass2"}), (Object)CollectionTools.list((Iterable)actual));
    }

    public void testResolveFullyQualifiedNames2() throws Exception {
        this.createClassAndMembers("OtherClass", "");
        this.createClassAndMembers("OtherClass2", "");
        this.createAnnotationAndMembers("TestAnnotation", "Class[] foo();");
        ICompilationUnit cu = this.createTestType((Iterator<String>)new ArrayIterator((Object[])new String[]{"clazz.OtherClass", "clazz.OtherClass2", "annot.TestAnnotation"}), "@TestAnnotation(foo={1, OtherClass.class})");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "foo", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forTypes());
        JDTFieldAttribute field = this.idField(cu);
        Iterable actual = ASTTools.resolveFullyQualifiedNames((Expression)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu))));
        Object[] objectArray = new String[2];
        objectArray[1] = "clazz.OtherClass";
        ASTToolsTests.assertEquals((Object)CollectionTools.list((Object[])objectArray), (Object)CollectionTools.list((Iterable)actual));
    }

    public void testResolveFullyQualifiedNames3() throws Exception {
        this.createClassAndMembers("OtherClass", "");
        this.createClassAndMembers("OtherClass2", "");
        this.createAnnotationAndMembers("TestAnnotation", "Class[] foo();");
        ICompilationUnit cu = this.createTestType((Iterator<String>)new ArrayIterator((Object[])new String[]{"clazz.OtherClass", "clazz.OtherClass2", "annot.TestAnnotation"}), "@TestAnnotation(foo={@TestAnnotation(), OtherClass.class}");
        SimpleDeclarationAnnotationAdapter daa = new SimpleDeclarationAnnotationAdapter("annot.TestAnnotation");
        ConversionDeclarationAnnotationElementAdapter daea = new ConversionDeclarationAnnotationElementAdapter((DeclarationAnnotationAdapter)daa, "foo", (ExpressionConverter)AnnotationStringArrayExpressionConverter.forTypes());
        JDTFieldAttribute field = this.idField(cu);
        Iterable actual = ASTTools.resolveFullyQualifiedNames((Expression)daea.getExpression(field.getModifiedDeclaration(this.buildASTRoot(cu))));
        Object[] objectArray = new String[2];
        objectArray[1] = "clazz.OtherClass";
        ASTToolsTests.assertEquals((Object)CollectionTools.list((Object[])objectArray), (Object)CollectionTools.list((Iterable)actual));
    }
}

