/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.JpaRootContextNode;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.jpa.core.platform.GenericPlatform;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.core.tests.internal.projects.TestJpaProject;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public abstract class ContextModelTestCase
extends AnnotationTestCase {
    protected static final String BASE_PROJECT_NAME = "ContextModelTestProject";
    protected JpaXmlResource persistenceXmlResource;
    protected JpaXmlResource ormXmlResource;

    protected ContextModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.persistenceXmlResource = this.getJpaProject().getPersistenceXmlResource();
        this.ormXmlResource = this.getJpaProject().getDefaultOrmXmlResource();
        this.waitForWorkspaceJobsToFinish();
    }

    protected void tearDown() throws Exception {
        this.persistenceXmlResource = null;
        this.ormXmlResource = null;
        JptJpaCorePlugin.getWorkspacePreferences().clear();
        this.waitForWorkspaceJobsToFinish();
        super.tearDown();
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return this.buildJpaProject(BASE_PROJECT_NAME, autoBuild, this.buildJpaConfigDataModel());
    }

    protected TestJpaProject buildJpaProject(String projectName, boolean autoBuild, IDataModel jpaConfig) throws Exception {
        return TestJpaProject.buildJpaProject(projectName, autoBuild, jpaConfig);
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetInstallDataModelProvider());
        dataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)JpaFacet.VERSION_1_0.getVersionString());
        dataModel.setProperty("JpaFacetDataModelProperties.PLATFORM", (Object)GenericPlatform.VERSION_1_0);
        dataModel.setProperty("JpaFacetInstallDataModelProperties.CREATE_ORM_XML", (Object)Boolean.TRUE);
        return dataModel;
    }

    protected JpaProject getJpaProject() {
        return this.getJavaProject().getJpaProject();
    }

    protected void waitForWorkspaceJobsToFinish() throws InterruptedException {
        Job waitJob = new Job("Wait job"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        waitJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        waitJob.schedule();
        waitJob.join();
    }

    protected JpaXmlResource getPersistenceXmlResource() {
        return this.persistenceXmlResource;
    }

    protected JpaXmlResource getOrmXmlResource() {
        return this.ormXmlResource;
    }

    protected void saveXmlFiles() {
        try {
            this.saveXmlFiles_();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void saveXmlFiles_() throws Exception {
        this.persistenceXmlResource.saveIfNecessary();
        this.ormXmlResource.saveIfNecessary();
    }

    protected XmlEntityMappings getXmlEntityMappings() {
        return (XmlEntityMappings)this.getOrmXmlResource().getRootObject();
    }

    protected XmlPersistence getXmlPersistence() {
        return (XmlPersistence)this.getPersistenceXmlResource().getRootObject();
    }

    protected MappingFile getMappingFile() {
        return ((MappingFileRef)this.getPersistenceUnit().mappingFileRefs().next()).getMappingFile();
    }

    protected EntityMappings getEntityMappings() {
        MappingFile mappingFile = this.getMappingFile();
        return mappingFile == null ? null : (EntityMappings)mappingFile.getRoot();
    }

    protected XmlPersistenceUnit getXmlPersistenceUnit() {
        return (XmlPersistenceUnit)this.getXmlPersistence().getPersistenceUnits().get(0);
    }

    protected PersistenceUnit getPersistenceUnit() {
        return (PersistenceUnit)this.getRootContextNode().getPersistenceXml().getPersistence().persistenceUnits().next();
    }

    protected ClassRef getSpecifiedClassRef() {
        return (ClassRef)this.getPersistenceUnit().specifiedClassRefs().next();
    }

    protected JavaPersistentType getJavaPersistentType() {
        return this.getSpecifiedClassRef().getJavaPersistentType();
    }

    protected JavaEntity getJavaEntity() {
        return (JavaEntity)this.getJavaPersistentType().getMapping();
    }

    protected void addXmlClassRef(String className) {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass(className);
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
    }

    protected void removeXmlClassRef(String className) {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        XmlJavaClassRef xmlJavaClassRefToRemove = null;
        for (XmlJavaClassRef xmlJavaClassRef : xmlPersistenceUnit.getClasses()) {
            if (!xmlJavaClassRef.getJavaClass().equals(className)) continue;
            xmlJavaClassRefToRemove = xmlJavaClassRef;
        }
        if (xmlJavaClassRefToRemove == null) {
            throw new IllegalArgumentException();
        }
        xmlPersistenceUnit.getClasses().remove(xmlJavaClassRefToRemove);
    }

    protected void addXmlMappingFileRef(String fileName) {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName(fileName);
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
    }

    protected JpaRootContextNode getRootContextNode() {
        return this.getJavaProject().getJpaProject().getRootContextNode();
    }

    protected TestJpaProject getJavaProject() {
        return (TestJpaProject)super.getJavaProject();
    }

    protected void deleteResource(Resource resource) throws CoreException {
        WorkbenchResourceHelper.deleteResource((Resource)resource);
    }
}

