/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.EnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.LobConverter;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaBasicMappingTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithBasicMappingFetchOptionalSpecified() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.FetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic(fetch=FetchType.EAGER, optional=false)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithLob() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Lob"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Lob").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithEnumerated() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Enumerated", "javax.persistence.EnumType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Enumerated(EnumType.STRING)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithTemporal() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Temporal(TemporalType.TIMESTAMP)").append(CR);
            }
        });
    }

    public JavaBasicMappingTests(String name) {
        super(name);
    }

    public void testDefaultBasicGetDefaultFetch() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)basicMapping.getDefaultFetch());
    }

    public void testSpecifiedBasicGetDefaultFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)basicMapping.getDefaultFetch());
    }

    public void testGetFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)basicMapping.getFetch());
        basicMapping.setSpecifiedFetch(FetchType.LAZY);
        JavaBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)basicMapping.getFetch());
    }

    public void testGetSpecifiedFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedFetch());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getAnnotation("javax.persistence.Basic");
        basic.setFetch(org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY);
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)basicMapping.getSpecifiedFetch());
    }

    public void testGetSpecifiedFetch2() throws Exception {
        this.createTestEntityWithBasicMappingFetchOptionalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)basicMapping.getSpecifiedFetch());
    }

    public void testSetSpecifiedFetch() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedFetch());
        basicMapping.setSpecifiedFetch(FetchType.LAZY);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)basic.getFetch());
        basicMapping.setSpecifiedFetch(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
    }

    public void testSetSpecifiedFetch2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.createOrmXmlFile();
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedFetch());
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedFetch(FetchType.LAZY);
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableProperties().next();
        BasicAnnotation basic = (BasicAnnotation)resourceAttribute.getAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.FetchType.LAZY, (Object)basic.getFetch());
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)basicMapping.getSpecifiedFetch());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedFetch(null);
        JavaBasicMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Basic"));
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
    }

    protected void createOrmXmlFile() throws Exception {
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testSetBasicToDefault() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addAnnotation("javax.persistence.Temporal");
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaBasicMappingTests.assertNotSame((Object)basicMapping, (Object)persistentAttribute.getMapping());
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)basicMapping.getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToDefaultBasic() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(EnumeratedConverter.class);
        ((EnumeratedConverter)basicMapping.getConverter()).setSpecifiedEnumType(EnumType.STRING);
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Temporal");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)((BasicMapping)persistentAttribute.getMapping()).getConverter()).getEnumType());
        JavaBasicMappingTests.assertNull((Object)((BasicMapping)persistentAttribute.getMapping()).getSpecifiedFetch());
        JavaBasicMappingTests.assertNull((Object)((BasicMapping)persistentAttribute.getMapping()).getSpecifiedOptional());
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToId() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(TemporalType.TIME);
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Enumerated");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)((IdMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((Object)TemporalType.TIME, (Object)((TemporalConverter)((IdMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToVersion() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(TemporalType.TIME);
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        JavaBasicMappingTests.assertEquals((String)"FOO", (String)((VersionMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((Object)TemporalType.TIME, (Object)((TemporalConverter)((VersionMapping)persistentAttribute.getMapping()).getConverter()).getTemporalType());
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Version"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToEmbedded() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addAnnotation("javax.persistence.Temporal");
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToEmbeddedId() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addAnnotation("javax.persistence.Temporal");
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToTransient() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addAnnotation("javax.persistence.Temporal");
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToOneToOne() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addAnnotation("javax.persistence.Temporal");
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Enumerated");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToOneToMany() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addAnnotation("javax.persistence.Temporal");
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Enumerated");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToManyToOne() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addAnnotation("javax.persistence.Temporal");
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Enumerated");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToOne"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testBasicMorphToManyToMany() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        attributeResource.addAnnotation("javax.persistence.Temporal");
        attributeResource.addAnnotation("javax.persistence.Lob");
        attributeResource.addAnnotation("javax.persistence.Enumerated");
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        JavaBasicMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testDefaultBasicGetDefaultOptional() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((boolean)true, (boolean)basicMapping.isDefaultOptional());
    }

    public void testSpecifiedBasicGetDefaultOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((boolean)true, (boolean)basicMapping.isDefaultOptional());
    }

    public void testGetOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((boolean)true, (boolean)basicMapping.isOptional());
        basicMapping.setSpecifiedOptional(Boolean.TRUE);
        JavaBasicMappingTests.assertEquals((boolean)true, (boolean)basicMapping.isOptional());
    }

    public void testGetSpecifiedOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getAnnotation("javax.persistence.Basic");
        basic.setOptional(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
    }

    public void testGetSpecifiedOptional2() throws Exception {
        this.createTestEntityWithBasicMappingFetchOptionalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
    }

    public void testSetSpecifiedOptional() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basic.getOptional());
        basicMapping.setSpecifiedOptional(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
    }

    public void testSetSpecifiedOptional2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaBasicMappingTests.assertTrue((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedOptional(Boolean.TRUE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getAnnotation("javax.persistence.Basic");
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basic.getOptional());
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicMapping.getSpecifiedOptional());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.setSpecifiedOptional(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
    }

    public void testGetSpecifiedOptionalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        BasicAnnotation basic = (BasicAnnotation)attributeResource.getAnnotation("javax.persistence.Basic");
        basic.setOptional(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
        basic.setOptional(null);
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getSpecifiedOptional());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getMapping());
        basic.setOptional(Boolean.FALSE);
        attributeResource.setPrimaryAnnotation(null, EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaBasicMappingTests.assertEquals((boolean)true, (boolean)((BasicMapping)persistentAttribute.getMapping()).isOptional());
    }

    public void testIsLob() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((basicMapping.getConverter().getType() == LobConverter.class ? 1 : 0) != 0);
    }

    public void testIsLob2() throws Exception {
        this.createTestEntityWithLob();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertTrue((basicMapping.getConverter().getType() == LobConverter.class ? 1 : 0) != 0);
    }

    public void testSetLob() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        basicMapping.setConverter(LobConverter.class);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
        basicMapping.setConverter(null);
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Lob"));
    }

    public void testIsLobUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertFalse((basicMapping.getConverter().getType() == LobConverter.class ? 1 : 0) != 0);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("javax.persistence.Lob");
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertTrue((basicMapping.getConverter().getType() == LobConverter.class ? 1 : 0) != 0);
        attributeResource.removeAnnotation("javax.persistence.Lob");
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertFalse((basicMapping.getConverter().getType() == LobConverter.class ? 1 : 0) != 0);
    }

    public void testDefaultBasicGetDefaultConverter() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
    }

    public void testSpecifiedBasicGetDefaultConverter() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
    }

    public void testGetEnumerated() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EnumeratedAnnotation enumeratedAnnotation = (EnumeratedAnnotation)attributeResource.addAnnotation("javax.persistence.Enumerated");
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)((EnumeratedConverter)basicMapping.getConverter()).getDefaultEnumType());
        enumeratedAnnotation.setValue(org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING);
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)basicMapping.getConverter()).getSpecifiedEnumType());
    }

    public void testGetSpecifiedEnumerated() throws Exception {
        this.createTestEntityWithEnumerated();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)basicMapping.getConverter()).getSpecifiedEnumType());
    }

    public void testSetSpecifiedEnumerated() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        basicMapping.setConverter(EnumeratedConverter.class);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.getAnnotation("javax.persistence.Enumerated");
        JavaBasicMappingTests.assertNotNull((Object)enumerated);
        JavaBasicMappingTests.assertEquals(null, (Object)enumerated.getValue());
        ((EnumeratedConverter)basicMapping.getConverter()).setSpecifiedEnumType(EnumType.STRING);
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING, (Object)enumerated.getValue());
        ((EnumeratedConverter)basicMapping.getConverter()).setSpecifiedEnumType(null);
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
        JavaBasicMappingTests.assertNull((Object)enumerated.getValue());
        basicMapping.setConverter(null);
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
    }

    public void testGetSpecifiedEnumeratedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)attributeResource.addAnnotation("javax.persistence.Enumerated");
        enumerated.setValue(org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING);
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)((EnumeratedConverter)basicMapping.getConverter()).getSpecifiedEnumType());
        enumerated.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Enumerated"));
        JavaBasicMappingTests.assertNull((Object)((EnumeratedConverter)basicMapping.getConverter()).getSpecifiedEnumType());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getMapping());
    }

    public void testGetTemporal() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("javax.persistence.Temporal");
        this.getJpaProject().synchronizeContextModel();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals(TemporalConverter.class, (Object)basicMapping.getConverter().getType());
    }

    public void testGetTemporal2() throws Exception {
        this.createTestEntityWithTemporal();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertEquals(TemporalConverter.class, (Object)basicMapping.getConverter().getType());
        JavaBasicMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)((TemporalConverter)basicMapping.getConverter()).getTemporalType());
    }

    public void testSetTemporal() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getAnnotation("javax.persistence.Temporal");
        JavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.TemporalType.TIME, (Object)temporal.getValue());
        basicMapping.setConverter(null);
        JavaBasicMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.addAnnotation("javax.persistence.Temporal");
        temporal.setValue(org.eclipse.jpt.jpa.core.resource.java.TemporalType.DATE);
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertEquals(TemporalConverter.class, (Object)basicMapping.getConverter().getType());
        JavaBasicMappingTests.assertEquals((Object)TemporalType.DATE, (Object)((TemporalConverter)basicMapping.getConverter()).getTemporalType());
        attributeResource.removeAnnotation("javax.persistence.Temporal");
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        JavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        JavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getMapping());
    }

    public void testGetColumn() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        JavaBasicMappingTests.assertNull((Object)basicMapping.getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((String)"id", (String)basicMapping.getColumn().getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaBasicMappingTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getSpecifiedName());
        JavaBasicMappingTests.assertEquals((String)"foo", (String)basicMapping.getColumn().getName());
        JavaBasicMappingTests.assertEquals((String)"id", (String)basicMapping.getColumn().getDefaultName());
    }
}

