/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.MappedSuperclass;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaNullTypeMapping;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaEmbeddableTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEmbeddable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable");
            }
        });
    }

    public JavaEmbeddableTests(String name) {
        super(name);
    }

    public void testMorphToEntity() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaPersistentType().setMappingKey("entity");
        JavaEmbeddableTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof Entity));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEmbeddableTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Embeddable"));
    }

    public void testMorphToMappedSuperclass() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaPersistentType().setMappingKey("mappedSuperclass");
        JavaEmbeddableTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof MappedSuperclass));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEmbeddableTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Embeddable"));
    }

    public void testMorphToNull() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaEmbeddableTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof JavaNullTypeMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaEmbeddableTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Embeddable"));
    }

    public void testEmbeddable() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEmbeddableTests.assertTrue((boolean)(this.getJavaPersistentType().getMapping() instanceof Embeddable));
    }

    public void testOverridableAttributeNames() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.getJavaPersistentType().getMapping();
        Iterator overridableAttributeNames = embeddable.overridableAttributeNames();
        JavaEmbeddableTests.assertEquals((String)((String)overridableAttributeNames.next()), (String)"id");
        JavaEmbeddableTests.assertEquals((String)((String)overridableAttributeNames.next()), (String)"name");
        JavaEmbeddableTests.assertFalse((boolean)overridableAttributeNames.hasNext());
    }

    public void testOverridableAssociationNames() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.getJavaPersistentType().getMapping();
        Iterator overridableAssociationNames = embeddable.overridableAssociationNames();
        JavaEmbeddableTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }

    public void testTableNameIsInvalid() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.getJavaPersistentType().getMapping();
        JavaEmbeddableTests.assertFalse((boolean)embeddable.tableNameIsInvalid("test.AnnotationTestType"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.tableNameIsInvalid("FOO"));
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.getJavaPersistentType().getMapping();
        JavaEmbeddableTests.assertTrue((boolean)embeddable.attributeMappingKeyAllowed("basic"));
        JavaEmbeddableTests.assertTrue((boolean)embeddable.attributeMappingKeyAllowed("transient"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("id"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("embedded"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("embeddedId"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("version"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("oneToOne"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("manyToOne"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("oneToMany"));
        JavaEmbeddableTests.assertFalse((boolean)embeddable.attributeMappingKeyAllowed("manyToMany"));
    }

    public void testAssociatedTables() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.getJavaPersistentType().getMapping();
        JavaEmbeddableTests.assertFalse((boolean)embeddable.associatedTables().hasNext());
    }

    public void testAssociatedTablesIncludingInherited() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.getJavaPersistentType().getMapping();
        JavaEmbeddableTests.assertFalse((boolean)embeddable.allAssociatedTables().hasNext());
    }

    public void testAssociatedTableNamesIncludingInherited() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.getJavaPersistentType().getMapping();
        JavaEmbeddableTests.assertFalse((boolean)embeddable.allAssociatedTableNames().hasNext());
    }

    public void testAllOverridableAssociationNames() throws Exception {
        this.createTestEmbeddable();
        this.addXmlClassRef("test.AnnotationTestType");
        Embeddable embeddable = (Embeddable)this.getJavaPersistentType().getMapping();
        Iterator overridableAssociationNames = embeddable.overridableAssociationNames();
        JavaEmbeddableTests.assertFalse((boolean)overridableAssociationNames.hasNext());
    }
}

