/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.NamedNativeQuery;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaNamedNativeQueryTests
extends ContextModelTestCase {
    private static final String QUERY_NAME = "QUERY_NAME";
    private static final String QUERY_QUERY = "MY_QUERY";

    private ICompilationUnit createTestEntityWithNamedNativeQuery() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.NamedNativeQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedNativeQuery(name=\"QUERY_NAME\", query=\"MY_QUERY\")");
            }
        });
    }

    public JavaNamedNativeQueryTests(String name) {
        super(name);
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        JavaNamedNativeQueryTests.assertEquals((String)QUERY_NAME, (String)javaNamedNativeQuery.getName());
        JavaNamedNativeQueryTests.assertEquals((String)QUERY_NAME, (String)namedNativeQuery.getName());
        javaNamedNativeQuery.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertNull((Object)javaNamedNativeQuery.getName());
        JavaNamedNativeQueryTests.assertNull((Object)namedNativeQuery.getName());
        javaNamedNativeQuery.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)javaNamedNativeQuery.getName());
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQuery.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        JavaNamedNativeQueryTests.assertEquals((String)QUERY_NAME, (String)javaNamedNativeQuery.getName());
        JavaNamedNativeQueryTests.assertEquals((String)QUERY_NAME, (String)namedNativeQuery.getName());
        namedNativeQuery.setName(null);
        JavaNamedNativeQueryTests.assertNull((Object)javaNamedNativeQuery.getName());
        JavaNamedNativeQueryTests.assertNull((Object)namedNativeQuery.getName());
        namedNativeQuery.setName("foo");
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)javaNamedNativeQuery.getName());
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQuery.getName());
    }

    public void testUpdateQuery() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        JavaNamedNativeQueryTests.assertEquals((String)QUERY_QUERY, (String)javaNamedNativeQuery.getQuery());
        JavaNamedNativeQueryTests.assertEquals((String)QUERY_QUERY, (String)namedNativeQuery.getQuery());
        javaNamedNativeQuery.setQuery(null);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertNull((Object)javaNamedNativeQuery.getQuery());
        JavaNamedNativeQueryTests.assertNull((Object)namedNativeQuery.getQuery());
        javaNamedNativeQuery.setQuery("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)javaNamedNativeQuery.getQuery());
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQuery.getQuery());
    }

    public void testModifyQuery() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        JavaNamedNativeQueryTests.assertEquals((String)QUERY_QUERY, (String)javaNamedNativeQuery.getQuery());
        JavaNamedNativeQueryTests.assertEquals((String)QUERY_QUERY, (String)namedNativeQuery.getQuery());
        namedNativeQuery.setQuery(null);
        JavaNamedNativeQueryTests.assertNull((Object)javaNamedNativeQuery.getQuery());
        JavaNamedNativeQueryTests.assertNull((Object)namedNativeQuery.getQuery());
        namedNativeQuery.setQuery("foo");
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)javaNamedNativeQuery.getQuery());
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQuery.getQuery());
    }

    public void testAddHint() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        QueryHint queryHint = namedNativeQuery.addHint(0);
        queryHint.setName("FOO");
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)javaNamedNativeQuery.hintAt(0).getName());
        QueryHint queryHint2 = namedNativeQuery.addHint(0);
        queryHint2.setName("BAR");
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)javaNamedNativeQuery.hintAt(0).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)javaNamedNativeQuery.hintAt(1).getName());
        QueryHint queryHint3 = namedNativeQuery.addHint(1);
        queryHint3.setName("BAZ");
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)javaNamedNativeQuery.hintAt(0).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)javaNamedNativeQuery.hintAt(1).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)javaNamedNativeQuery.hintAt(2).getName());
        ListIterator hints = namedNativeQuery.getHints().iterator();
        JavaNamedNativeQueryTests.assertEquals((Object)queryHint2, hints.next());
        JavaNamedNativeQueryTests.assertEquals((Object)queryHint3, hints.next());
        JavaNamedNativeQueryTests.assertEquals((Object)queryHint, hints.next());
        hints = namedNativeQuery.getHints().iterator();
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
    }

    public void testRemoveHint() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        namedNativeQuery.addHint(0).setName("FOO");
        namedNativeQuery.addHint(1).setName("BAR");
        namedNativeQuery.addHint(2).setName("BAZ");
        JavaNamedNativeQueryTests.assertEquals((int)3, (int)javaNamedNativeQuery.hintsSize());
        namedNativeQuery.removeHint(0);
        JavaNamedNativeQueryTests.assertEquals((int)2, (int)javaNamedNativeQuery.hintsSize());
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)javaNamedNativeQuery.hintAt(0).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)javaNamedNativeQuery.hintAt(1).getName());
        namedNativeQuery.removeHint(0);
        JavaNamedNativeQueryTests.assertEquals((int)1, (int)javaNamedNativeQuery.hintsSize());
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)javaNamedNativeQuery.hintAt(0).getName());
        namedNativeQuery.removeHint(0);
        JavaNamedNativeQueryTests.assertEquals((int)0, (int)javaNamedNativeQuery.hintsSize());
    }

    public void testMoveHint() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        namedNativeQuery.addHint(0).setName("FOO");
        namedNativeQuery.addHint(1).setName("BAR");
        namedNativeQuery.addHint(2).setName("BAZ");
        JavaNamedNativeQueryTests.assertEquals((int)3, (int)javaNamedNativeQuery.hintsSize());
        namedNativeQuery.moveHint(2, 0);
        ListIterator hints = namedNativeQuery.getHints().iterator();
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)javaNamedNativeQuery.hintAt(0).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)javaNamedNativeQuery.hintAt(1).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)javaNamedNativeQuery.hintAt(2).getName());
        namedNativeQuery.moveHint(0, 1);
        hints = namedNativeQuery.getHints().iterator();
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)javaNamedNativeQuery.hintAt(0).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)javaNamedNativeQuery.hintAt(1).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)javaNamedNativeQuery.hintAt(2).getName());
    }

    public void testUpdateHints() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation queryAnnotation = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        queryAnnotation.addHint(0).setName("FOO");
        queryAnnotation.addHint(1).setName("BAR");
        queryAnnotation.addHint(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator hints = namedNativeQuery.getHints().iterator();
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertFalse((boolean)hints.hasNext());
        queryAnnotation.moveHint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        hints = namedNativeQuery.getHints().iterator();
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertFalse((boolean)hints.hasNext());
        queryAnnotation.moveHint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        hints = namedNativeQuery.getHints().iterator();
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertFalse((boolean)hints.hasNext());
        queryAnnotation.removeHint(1);
        this.getJpaProject().synchronizeContextModel();
        hints = namedNativeQuery.getHints().iterator();
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertFalse((boolean)hints.hasNext());
        queryAnnotation.removeHint(1);
        this.getJpaProject().synchronizeContextModel();
        hints = namedNativeQuery.getHints().iterator();
        JavaNamedNativeQueryTests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        JavaNamedNativeQueryTests.assertFalse((boolean)hints.hasNext());
        queryAnnotation.removeHint(0);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertFalse((boolean)namedNativeQuery.getHints().iterator().hasNext());
    }

    public void testHintsSize() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaNamedNativeQueryTests.assertEquals((int)0, (int)namedNativeQuery.getHintsSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        javaNamedNativeQuery.addHint(0);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertEquals((int)1, (int)namedNativeQuery.getHintsSize());
        javaNamedNativeQuery.addHint(0);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertEquals((int)2, (int)namedNativeQuery.getHintsSize());
        javaNamedNativeQuery.removeHint(0);
        javaNamedNativeQuery.removeHint(0);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertEquals((int)0, (int)namedNativeQuery.getHintsSize());
    }

    public void testUpdateResultClass() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation queryAnnotation = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        JavaNamedNativeQueryTests.assertEquals(null, (String)queryAnnotation.getResultClass());
        JavaNamedNativeQueryTests.assertEquals(null, (String)namedNativeQuery.getResultClass());
        queryAnnotation.setResultClass("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)queryAnnotation.getResultClass());
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQuery.getResultClass());
        queryAnnotation.setResultClass(null);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertNull((Object)queryAnnotation.getResultClass());
        JavaNamedNativeQueryTests.assertNull((Object)namedNativeQuery.getResultClass());
    }

    public void testModifyResultClass() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        JavaNamedNativeQueryTests.assertEquals(null, (String)javaNamedNativeQuery.getResultClass());
        JavaNamedNativeQueryTests.assertEquals(null, (String)namedNativeQuery.getResultClass());
        namedNativeQuery.setResultClass("foo");
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)javaNamedNativeQuery.getResultClass());
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQuery.getResultClass());
        namedNativeQuery.setResultClass(null);
        JavaNamedNativeQueryTests.assertNull((Object)javaNamedNativeQuery.getResultClass());
        JavaNamedNativeQueryTests.assertNull((Object)namedNativeQuery.getResultClass());
    }

    public void testUpdateResultSetMapping() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        JavaNamedNativeQueryTests.assertEquals(null, (String)javaNamedNativeQuery.getResultSetMapping());
        JavaNamedNativeQueryTests.assertEquals(null, (String)namedNativeQuery.getResultSetMapping());
        javaNamedNativeQuery.setResultSetMapping("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)javaNamedNativeQuery.getResultSetMapping());
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQuery.getResultSetMapping());
        javaNamedNativeQuery.setResultSetMapping(null);
        this.getJpaProject().synchronizeContextModel();
        JavaNamedNativeQueryTests.assertNull((Object)javaNamedNativeQuery.getResultSetMapping());
        JavaNamedNativeQueryTests.assertNull((Object)namedNativeQuery.getResultSetMapping());
    }

    public void testModifyResultSetMapping() throws Exception {
        this.createTestEntityWithNamedNativeQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedNativeQuery namedNativeQuery = (NamedNativeQuery)entity.getQueryContainer().namedNativeQueries().next();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        NamedNativeQueryAnnotation javaNamedNativeQuery = (NamedNativeQueryAnnotation)typeResource.getAnnotation("javax.persistence.NamedNativeQuery");
        JavaNamedNativeQueryTests.assertEquals(null, (String)javaNamedNativeQuery.getResultSetMapping());
        JavaNamedNativeQueryTests.assertEquals(null, (String)namedNativeQuery.getResultSetMapping());
        namedNativeQuery.setResultSetMapping("foo");
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)javaNamedNativeQuery.getResultSetMapping());
        JavaNamedNativeQueryTests.assertEquals((String)"foo", (String)namedNativeQuery.getResultSetMapping());
        namedNativeQuery.setResultSetMapping(null);
        JavaNamedNativeQueryTests.assertNull((Object)javaNamedNativeQuery.getResultSetMapping());
        JavaNamedNativeQueryTests.assertNull((Object)namedNativeQuery.getResultSetMapping());
    }
}

