/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.persistence;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnitTransactionType;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperty;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class PersistenceUnitTests
extends ContextModelTestCase {
    protected static final String INNER_CLASS_NAME = "InnerAnnotationTestType";
    protected static final String FULLY_QUALIFIED_INNER_CLASS_NAME = "test.AnnotationTestType.InnerAnnotationTestType";
    public static final String OTHER_TYPE_NAME = "OtherTestType";
    public static final String FULLY_QUALIFIED_OTHER_TYPE_NAME = "test.OtherTestType";

    public PersistenceUnitTests(String name) {
        super(name);
    }

    public void testUpdateName() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        xmlPersistenceUnit.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        xmlPersistenceUnit.setName("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        xmlPersistenceUnit.setName(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        xmlPersistenceUnit.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
    }

    public void testModifyName() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        persistenceUnit.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        persistenceUnit.setName("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        persistenceUnit.setName(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
        persistenceUnit.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getName(), (String)persistenceUnit.getName());
    }

    public void testUpdateTransactionType() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getTransactionType());
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedTransactionType());
        xmlPersistenceUnit.setTransactionType(XmlPersistenceUnitTransactionType.JTA);
        PersistenceUnitTests.assertEquals((Object)PersistenceUnitTransactionType.JTA, (Object)persistenceUnit.getSpecifiedTransactionType());
        xmlPersistenceUnit.setTransactionType(XmlPersistenceUnitTransactionType.RESOURCE_LOCAL);
        PersistenceUnitTests.assertEquals((Object)PersistenceUnitTransactionType.RESOURCE_LOCAL, (Object)persistenceUnit.getSpecifiedTransactionType());
        xmlPersistenceUnit.setTransactionType(null);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedTransactionType());
    }

    public void testModifyTransactionType() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getTransactionType());
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedTransactionType());
        persistenceUnit.setSpecifiedTransactionType(PersistenceUnitTransactionType.JTA);
        PersistenceUnitTests.assertEquals((Object)XmlPersistenceUnitTransactionType.JTA, (Object)xmlPersistenceUnit.getTransactionType());
        persistenceUnit.setSpecifiedTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
        PersistenceUnitTests.assertEquals((Object)XmlPersistenceUnitTransactionType.RESOURCE_LOCAL, (Object)xmlPersistenceUnit.getTransactionType());
        persistenceUnit.setSpecifiedTransactionType(null);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedTransactionType());
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getTransactionType());
    }

    public void testUpdateDescription() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        xmlPersistenceUnit.setDescription("newDescription");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        xmlPersistenceUnit.setDescription("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        xmlPersistenceUnit.setDescription(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        xmlPersistenceUnit.setDescription("newDescription");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
    }

    public void testModifyDescription() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        persistenceUnit.setDescription("newDescription");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        persistenceUnit.setDescription("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        persistenceUnit.setDescription(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
        persistenceUnit.setDescription("newDescription");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getDescription(), (String)persistenceUnit.getDescription());
    }

    public void testUpdateProvider() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        xmlPersistenceUnit.setProvider("newProvider");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        xmlPersistenceUnit.setProvider("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        xmlPersistenceUnit.setProvider(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        xmlPersistenceUnit.setProvider("newProvider");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
    }

    public void testModifyProvider() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        persistenceUnit.setProvider("newProvider");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        persistenceUnit.setProvider("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        persistenceUnit.setProvider(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
        persistenceUnit.setProvider("newProvider");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getProvider(), (String)persistenceUnit.getProvider());
    }

    public void testUpdateJtaDataSource() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        xmlPersistenceUnit.setJtaDataSource("newJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        xmlPersistenceUnit.setJtaDataSource("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        xmlPersistenceUnit.setJtaDataSource(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        xmlPersistenceUnit.setJtaDataSource("newJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
    }

    public void testModifyJtaDataSource() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        persistenceUnit.setJtaDataSource("newJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        persistenceUnit.setJtaDataSource("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        persistenceUnit.setJtaDataSource(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
        persistenceUnit.setJtaDataSource("newJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getJtaDataSource(), (String)persistenceUnit.getJtaDataSource());
    }

    public void testUpdateNonJtaDataSource() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        xmlPersistenceUnit.setNonJtaDataSource("newNonJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        xmlPersistenceUnit.setNonJtaDataSource("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        xmlPersistenceUnit.setNonJtaDataSource(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        xmlPersistenceUnit.setNonJtaDataSource("newNonJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
    }

    public void testModifyNonJtaDataSource() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        persistenceUnit.setNonJtaDataSource("newNonJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        persistenceUnit.setNonJtaDataSource("");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        persistenceUnit.setNonJtaDataSource(null);
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
        persistenceUnit.setNonJtaDataSource("newNonJtaDataSource");
        PersistenceUnitTests.assertEquals((String)xmlPersistenceUnit.getNonJtaDataSource(), (String)persistenceUnit.getNonJtaDataSource());
    }

    public void testUpdateJarFileRefs1() {
    }

    public void testUpdateJarFileRefs2() {
    }

    public void testUpdateImpliedMappingFileRef1() throws Exception {
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        JpaXmlResource ormResource = this.getOrmXmlResource();
        PersistenceUnitTests.assertTrue((boolean)ormResource.fileExists());
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        this.deleteResource((Resource)ormResource);
        PersistenceUnitTests.assertFalse((boolean)ormResource.fileExists());
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedMappingFileRef());
    }

    public void testUpdateImpliedMappingFileRef2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        JpaXmlResource ormResource = this.getOrmXmlResource();
        PersistenceUnitTests.assertTrue((boolean)ormResource.fileExists());
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getImpliedMappingFileRef());
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("META-INF/orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)1, (int)persistenceUnit.specifiedMappingFileRefsSize());
        PersistenceUnitTests.assertTrue((boolean)ormResource.fileExists());
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getImpliedMappingFileRef());
    }

    public void testUpdateSpecifiedMappingFileRefs1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getMappingFiles().size());
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.specifiedMappingFileRefsSize());
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)1, (int)persistenceUnit.specifiedMappingFileRefsSize());
        xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm2.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.specifiedMappingFileRefsSize());
    }

    public void testUpdateSpecifiedMappingFileRefs2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm2.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)xmlPersistenceUnit.getMappingFiles().size(), (int)2);
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.specifiedMappingFileRefsSize());
        xmlMappingFileRef = (XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(0);
        xmlPersistenceUnit.getMappingFiles().remove((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)1, (int)persistenceUnit.specifiedMappingFileRefsSize());
        xmlMappingFileRef = (XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(0);
        xmlPersistenceUnit.getMappingFiles().remove((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.specifiedMappingFileRefsSize());
    }

    public void testModifySpecifiedMappingFileRefs1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getMappingFiles().size());
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.specifiedMappingFileRefsSize());
        persistenceUnit.addSpecifiedMappingFileRef("foo");
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getMappingFiles().size());
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(0)).getFileName());
        persistenceUnit.addSpecifiedMappingFileRef("bar");
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(0)).getFileName());
        PersistenceUnitTests.assertEquals((String)"bar", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(1)).getFileName());
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getMappingFiles().size());
        persistenceUnit.addSpecifiedMappingFileRef(0, "baz");
        PersistenceUnitTests.assertEquals((int)3, (int)xmlPersistenceUnit.getMappingFiles().size());
        PersistenceUnitTests.assertEquals((String)"baz", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(0)).getFileName());
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(1)).getFileName());
        PersistenceUnitTests.assertEquals((String)"bar", (String)((XmlMappingFileRef)xmlPersistenceUnit.getMappingFiles().get(2)).getFileName());
    }

    public void testModifySpecifiedMappingFileRefs2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        xmlMappingFileRef.setFileName("orm2.xml");
        xmlPersistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getMappingFiles().size());
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.specifiedMappingFileRefsSize());
        persistenceUnit.removeSpecifiedMappingFileRef(0);
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getMappingFiles().size());
        persistenceUnit.removeSpecifiedMappingFileRef(0);
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getMappingFiles().size());
    }

    public void testUpdateClassRefs1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.specifiedClassRefsSize());
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Bar");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)1, (int)persistenceUnit.specifiedClassRefsSize());
        xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Baz");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.specifiedClassRefsSize());
    }

    public void testUpdateClassRefs2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Bar");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Baz");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.specifiedClassRefsSize());
        xmlClassRef = (XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(0);
        xmlPersistenceUnit.getClasses().remove((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)1, (int)persistenceUnit.specifiedClassRefsSize());
        xmlClassRef = (XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(0);
        xmlPersistenceUnit.getClasses().remove((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.specifiedClassRefsSize());
    }

    public void testModifyClassRefs1() throws Exception {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.specifiedClassRefsSize());
        persistenceUnit.addSpecifiedClassRef("Foo");
        this.getPersistenceXmlResource().save(null);
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((String)"Foo", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(0)).getJavaClass());
        persistenceUnit.addSpecifiedClassRef("Bar");
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((String)"Foo", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(0)).getJavaClass());
        PersistenceUnitTests.assertEquals((String)"Bar", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(1)).getJavaClass());
        persistenceUnit.addSpecifiedClassRef(0, "Baz");
        PersistenceUnitTests.assertEquals((int)3, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((String)"Baz", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(0)).getJavaClass());
        PersistenceUnitTests.assertEquals((String)"Foo", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(1)).getJavaClass());
        PersistenceUnitTests.assertEquals((String)"Bar", (String)((XmlJavaClassRef)xmlPersistenceUnit.getClasses().get(2)).getJavaClass());
    }

    public void testModifyClassRefs2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Bar");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Baz");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getClasses().size());
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.specifiedClassRefsSize());
        persistenceUnit.removeSpecifiedClassRef(0);
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getClasses().size());
        persistenceUnit.removeSpecifiedClassRef(0);
        PersistenceUnitTests.assertEquals((int)0, (int)xmlPersistenceUnit.getClasses().size());
    }

    public void testImpliedClassRefs1() throws Exception {
        this.createTestEntityWithPersistentInnerClass();
        this.getJpaProject().setDiscoversAnnotatedClasses(false);
        this.getPersistenceUnit().setSpecifiedExcludeUnlistedClasses(Boolean.TRUE);
        PersistenceUnitTests.assertEquals((int)0, (int)this.getPersistenceUnit().impliedClassRefsSize());
        this.getJpaProject().setDiscoversAnnotatedClasses(true);
        this.getPersistenceUnit().setSpecifiedExcludeUnlistedClasses(Boolean.FALSE);
        PersistenceUnitTests.assertEquals((int)2, (int)this.getPersistenceUnit().impliedClassRefsSize());
        this.verifyVirtualClassRef("test.AnnotationTestType");
        this.verifyVirtualClassRef(FULLY_QUALIFIED_INNER_CLASS_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        PersistenceUnitTests.assertEquals((int)1, (int)this.getPersistenceUnit().impliedClassRefsSize());
        this.verifyVirtualClassRef(FULLY_QUALIFIED_INNER_CLASS_NAME);
        this.removeXmlClassRef("test.AnnotationTestType");
        PersistenceUnitTests.assertEquals((int)2, (int)this.getPersistenceUnit().impliedClassRefsSize());
        this.verifyVirtualClassRef("test.AnnotationTestType");
        this.verifyVirtualClassRef(FULLY_QUALIFIED_INNER_CLASS_NAME);
        this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        PersistenceUnitTests.assertEquals((int)1, (int)this.getPersistenceUnit().impliedClassRefsSize());
        this.verifyVirtualClassRef(FULLY_QUALIFIED_INNER_CLASS_NAME);
        this.addXmlClassRef(FULLY_QUALIFIED_INNER_CLASS_NAME);
        PersistenceUnitTests.assertEquals((int)0, (int)this.getPersistenceUnit().impliedClassRefsSize());
        this.removeXmlClassRef(FULLY_QUALIFIED_INNER_CLASS_NAME);
        PersistenceUnitTests.assertEquals((int)1, (int)this.getPersistenceUnit().impliedClassRefsSize());
        this.verifyVirtualClassRef(FULLY_QUALIFIED_INNER_CLASS_NAME);
        this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_INNER_CLASS_NAME);
        PersistenceUnitTests.assertEquals((int)0, (int)this.getPersistenceUnit().impliedClassRefsSize());
    }

    protected void verifyVirtualClassRef(String className) {
        if (this.getVirtualClassRef(className) == null) {
            PersistenceUnitTests.fail((String)("missing virtual class ref: " + className));
        }
    }

    protected ClassRef getVirtualClassRef(String className) {
        Iterator stream = this.getPersistenceUnit().impliedClassRefs();
        while (stream.hasNext()) {
            ClassRef ref = (ClassRef)stream.next();
            if (!Tools.valuesAreEqual((Object)ref.getClassName(), (Object)className)) continue;
            return ref;
        }
        return null;
    }

    public void testImpliedClassRefs2() throws Exception {
        this.createTestEntity();
        this.getJpaProject().setDiscoversAnnotatedClasses(true);
        JavaResourcePersistentType javaType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        PersistenceUnitTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.getPersistenceUnit().impliedClassRefs()));
        javaType.removeAnnotation("javax.persistence.Entity");
        this.getJpaProject().synchronizeContextModel();
        PersistenceUnitTests.assertEquals((int)0, (int)this.getPersistenceUnit().impliedClassRefsSize());
        javaType.addAnnotation("javax.persistence.Embeddable");
        this.getJpaProject().synchronizeContextModel();
        PersistenceUnitTests.assertEquals((int)1, (int)this.getPersistenceUnit().impliedClassRefsSize());
        javaType.removeAnnotation("javax.persistence.Embeddable");
        this.getJpaProject().synchronizeContextModel();
        PersistenceUnitTests.assertEquals((int)0, (int)this.getPersistenceUnit().impliedClassRefsSize());
        javaType.addAnnotation("javax.persistence.MappedSuperclass");
        this.getJpaProject().synchronizeContextModel();
        PersistenceUnitTests.assertEquals((int)1, (int)this.getPersistenceUnit().impliedClassRefsSize());
    }

    public void testRenamePersistentTypeImpliedClassRefs() throws Exception {
        this.getJavaProject().getJpaProject().setDiscoversAnnotatedClasses(true);
        ICompilationUnit testType = this.createTestEntity();
        this.createTestOtherTypeEntity();
        ClassRef testTypeClassRef = this.getVirtualClassRef("test.AnnotationTestType");
        ClassRef otherTestTypeClassRef = this.getVirtualClassRef(FULLY_QUALIFIED_OTHER_TYPE_NAME);
        PersistenceUnitTests.assertNotNull((Object)testTypeClassRef);
        PersistenceUnitTests.assertNotNull((Object)otherTestTypeClassRef);
        JavaPersistentType testJavaPersistentType = testTypeClassRef.getJavaPersistentType();
        JavaPersistentType otherTestJavaPersistentType = otherTestTypeClassRef.getJavaPersistentType();
        testType.findPrimaryType().rename("TestType2", false, null);
        testTypeClassRef = this.getVirtualClassRef("test.TestType2");
        otherTestTypeClassRef = this.getVirtualClassRef(FULLY_QUALIFIED_OTHER_TYPE_NAME);
        PersistenceUnitTests.assertNotNull((Object)testTypeClassRef);
        PersistenceUnitTests.assertNotNull((Object)otherTestTypeClassRef);
        PersistenceUnitTests.assertEquals((Object)otherTestJavaPersistentType, (Object)otherTestTypeClassRef.getJavaPersistentType());
        PersistenceUnitTests.assertNotSame((Object)testJavaPersistentType, (Object)testTypeClassRef.getJavaPersistentType());
    }

    public void testUpdateExcludeUnlistedClasses() throws Exception {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.excludesUnlistedClasses());
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        xmlPersistenceUnit.setExcludeUnlistedClasses(Boolean.TRUE);
        PersistenceUnitTests.assertEquals((Object)Boolean.TRUE, (Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertTrue((boolean)persistenceUnit.excludesUnlistedClasses());
        PersistenceUnitTests.assertEquals((Object)Boolean.TRUE, (Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        xmlPersistenceUnit.setExcludeUnlistedClasses(Boolean.FALSE);
        PersistenceUnitTests.assertEquals((Object)Boolean.FALSE, (Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.excludesUnlistedClasses());
        PersistenceUnitTests.assertEquals((Object)Boolean.FALSE, (Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        xmlPersistenceUnit.setExcludeUnlistedClasses(null);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.excludesUnlistedClasses());
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
    }

    public void testModifyExcludeUnlistedClasses() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.excludesUnlistedClasses());
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        persistenceUnit.setSpecifiedExcludeUnlistedClasses(Boolean.TRUE);
        PersistenceUnitTests.assertEquals((Object)Boolean.TRUE, (Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertTrue((boolean)persistenceUnit.excludesUnlistedClasses());
        PersistenceUnitTests.assertEquals((Object)Boolean.TRUE, (Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        persistenceUnit.setSpecifiedExcludeUnlistedClasses(Boolean.FALSE);
        PersistenceUnitTests.assertEquals((Object)Boolean.FALSE, (Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.excludesUnlistedClasses());
        PersistenceUnitTests.assertEquals((Object)Boolean.FALSE, (Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
        persistenceUnit.setSpecifiedExcludeUnlistedClasses(null);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getSpecifiedExcludeUnlistedClasses());
        PersistenceUnitTests.assertFalse((boolean)persistenceUnit.excludesUnlistedClasses());
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getExcludeUnlistedClasses());
    }

    public void testUpdateProperties1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getProperties());
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.propertiesSize());
        XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
        xmlPersistenceUnit.setProperties(xmlProperties);
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.propertiesSize());
        XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("foo");
        xmlProperty.setValue("bar");
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)1, (int)persistenceUnit.propertiesSize());
        xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("FOO");
        xmlProperty.setValue("BAR");
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.propertiesSize());
    }

    public void testUpdateProperties2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
        xmlPersistenceUnit.setProperties(xmlProperties);
        XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("foo");
        xmlProperty.setValue("bar");
        xmlProperties.getProperties().add((Object)xmlProperty);
        xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("FOO");
        xmlProperty.setValue("BAR");
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.propertiesSize());
        xmlProperty = (XmlProperty)xmlProperties.getProperties().get(0);
        xmlProperties.getProperties().remove((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)1, (int)persistenceUnit.propertiesSize());
        xmlProperty = (XmlProperty)xmlProperties.getProperties().get(0);
        xmlProperties.getProperties().remove((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.propertiesSize());
    }

    public void testModifyProperties1() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getProperties());
        PersistenceUnitTests.assertEquals((int)0, (int)persistenceUnit.propertiesSize());
        persistenceUnit.addProperty().setName("foo");
        PersistenceUnitTests.assertNotNull((Object)xmlPersistenceUnit.getProperties());
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(0)).getName());
        persistenceUnit.addProperty().setName("bar");
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(0)).getName());
        PersistenceUnitTests.assertEquals((String)"bar", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(1)).getName());
        persistenceUnit.addProperty(0).setName("baz");
        PersistenceUnitTests.assertEquals((int)3, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((String)"baz", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(0)).getName());
        PersistenceUnitTests.assertEquals((String)"foo", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(1)).getName());
        PersistenceUnitTests.assertEquals((String)"bar", (String)((XmlProperty)xmlPersistenceUnit.getProperties().getProperties().get(2)).getName());
    }

    public void testModifyProperties2() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
        xmlPersistenceUnit.setProperties(xmlProperties);
        XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("foo");
        xmlProperty.setValue("bar");
        xmlProperties.getProperties().add((Object)xmlProperty);
        xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperty.setName("FOO");
        xmlProperty.setValue("BAR");
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.propertiesSize());
        persistenceUnit.removeProperty("foo");
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        persistenceUnit.removeProperty("FOO", "BAR");
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getProperties());
    }

    public void testModifyProperties3() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.setProperty("foo", "bar", false);
        persistenceUnit.setProperty("FOO", "BAR", false);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.propertiesSize());
        persistenceUnit.removeProperty("foo", "bar");
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        persistenceUnit.removeProperty("FOO");
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getProperties());
    }

    public void testModifyProperties4() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.setProperty("foo", "bar", false);
        persistenceUnit.setProperty("FOO", "BAR", false);
        PersistenceUnitTests.assertEquals((int)2, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)2, (int)persistenceUnit.propertiesSize());
        persistenceUnit.setProperty("foo", "", false);
        PersistenceUnitTests.assertEquals((String)"", (String)persistenceUnit.getProperty("foo").getValue());
        persistenceUnit.setProperty("foo", "BAR", false);
        PersistenceUnitTests.assertEquals((String)"BAR", (String)persistenceUnit.getProperty("foo").getValue());
        persistenceUnit.removeProperty("FOO");
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getProperty("FOO"));
        PersistenceUnitTests.assertEquals((int)1, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        persistenceUnit.setProperty("notExist", null, false);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getProperty("notExist"));
        persistenceUnit.setProperty("foo", null, false);
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getProperty("foo"));
        PersistenceUnitTests.assertNull((Object)xmlPersistenceUnit.getProperties());
    }

    public void testModifyProperties5() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.setProperty("FOO", "BAR", false);
        persistenceUnit.setProperty("foo", "bar 3", true);
        persistenceUnit.setProperty("foo", "bar 2", true);
        persistenceUnit.setProperty("foo", "bar 1", true);
        PersistenceUnitTests.assertEquals((int)4, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)4, (int)persistenceUnit.propertiesSize());
        persistenceUnit.removeProperty("foo", "bar 1");
        PersistenceUnitTests.assertEquals((int)3, (int)xmlPersistenceUnit.getProperties().getProperties().size());
        PersistenceUnitTests.assertEquals((int)3, (int)persistenceUnit.propertiesSize());
    }

    public void testAccessProperty() {
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.setProperty("foo", "bar", false);
        persistenceUnit.setProperty("FOO", "BAR", false);
        PersistenceUnit.Property property = persistenceUnit.getProperty("foo");
        PersistenceUnitTests.assertNotNull((Object)property);
        PersistenceUnitTests.assertEquals((String)"bar", (String)property.getValue());
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getProperty("FOO"));
        PersistenceUnitTests.assertEquals((String)"BAR", (String)persistenceUnit.getProperty("FOO").getValue());
        PersistenceUnitTests.assertNull((Object)persistenceUnit.getProperty("notExist"));
    }

    private PersistenceUnit.Property persistenceUnitFirstProperty() {
        return (PersistenceUnit.Property)this.getPersistenceUnit().properties().next();
    }

    public void testUpdatePropertyName() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
        xmlPersistenceUnit.setProperties(xmlProperties);
        XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((String)xmlProperty.getName(), (String)this.persistenceUnitFirstProperty().getName());
        xmlProperty.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getName(), (String)this.persistenceUnitFirstProperty().getName());
        xmlProperty.setName("");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getName(), (String)this.persistenceUnitFirstProperty().getName());
        xmlProperty.setName("newName");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getName(), (String)this.persistenceUnitFirstProperty().getName());
    }

    public void testUpdatePropertyValue() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        XmlProperties xmlProperties = PersistenceFactory.eINSTANCE.createXmlProperties();
        xmlPersistenceUnit.setProperties(xmlProperties);
        XmlProperty xmlProperty = PersistenceFactory.eINSTANCE.createXmlProperty();
        xmlProperties.getProperties().add((Object)xmlProperty);
        PersistenceUnitTests.assertEquals((String)xmlProperty.getValue(), (String)this.persistenceUnitFirstProperty().getValue());
        xmlProperty.setValue("newValue");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getValue(), (String)this.persistenceUnitFirstProperty().getValue());
        xmlProperty.setValue("");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getValue(), (String)this.persistenceUnitFirstProperty().getValue());
        xmlProperty.setValue(null);
        PersistenceUnitTests.assertEquals((String)xmlProperty.getValue(), (String)this.persistenceUnitFirstProperty().getValue());
        xmlProperty.setValue("newValue");
        PersistenceUnitTests.assertEquals((String)xmlProperty.getValue(), (String)this.persistenceUnitFirstProperty().getValue());
    }

    public void testGetDefaultAccess() throws Exception {
        this.addXmlMappingFileRef(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.createOrm2XmlFile();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        ListIterator mappingFileRefs = this.getPersistenceUnit().mappingFileRefs();
        OrmXml ormMappingFile = (OrmXml)((MappingFileRef)mappingFileRefs.next()).getMappingFile();
        OrmXml orm2MappingFile = (OrmXml)((MappingFileRef)mappingFileRefs.next()).getMappingFile();
        PersistenceUnitTests.assertEquals(null, (Object)persistenceUnit.getDefaultAccess());
        ormMappingFile.getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        PersistenceUnitTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistenceUnit.getDefaultAccess());
        ormMappingFile.getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.FIELD);
        PersistenceUnitTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnit.getDefaultAccess());
        ormMappingFile.getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(null);
        PersistenceUnitTests.assertFalse((boolean)ormMappingFile.getRoot().getPersistenceUnitMetadata().resourceExists());
        PersistenceUnitTests.assertEquals(null, (Object)persistenceUnit.getDefaultAccess());
        orm2MappingFile.getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.FIELD);
        PersistenceUnitTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnit.getDefaultAccess());
    }

    public void testGetDefaultSchema() throws Exception {
        this.addXmlMappingFileRef(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.createOrm2XmlFile();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        ListIterator mappingFileRefs = this.getPersistenceUnit().mappingFileRefs();
        OrmXml ormMappingFile = (OrmXml)((MappingFileRef)mappingFileRefs.next()).getMappingFile();
        OrmXml orm2MappingFile = (OrmXml)((MappingFileRef)mappingFileRefs.next()).getMappingFile();
        PersistenceUnitTests.assertEquals(null, (String)persistenceUnit.getDefaultSchema());
        ormMappingFile.getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema("FOO");
        PersistenceUnitTests.assertEquals((String)"FOO", (String)persistenceUnit.getDefaultSchema());
        ormMappingFile.getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema(null);
        PersistenceUnitTests.assertFalse((boolean)ormMappingFile.getRoot().getPersistenceUnitMetadata().resourceExists());
        PersistenceUnitTests.assertEquals(null, (String)persistenceUnit.getDefaultSchema());
        orm2MappingFile.getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema("BAR");
        PersistenceUnitTests.assertEquals((String)"BAR", (String)persistenceUnit.getDefaultSchema());
    }

    public void testGetDefaultCatalog() throws Exception {
        this.addXmlMappingFileRef(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.createOrm2XmlFile();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        ListIterator mappingFileRefs = this.getPersistenceUnit().mappingFileRefs();
        OrmXml ormMappingFile = (OrmXml)((MappingFileRef)mappingFileRefs.next()).getMappingFile();
        OrmXml orm2MappingFile = (OrmXml)((MappingFileRef)mappingFileRefs.next()).getMappingFile();
        PersistenceUnitTests.assertEquals(null, (String)persistenceUnit.getDefaultCatalog());
        ormMappingFile.getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedCatalog("FOO");
        PersistenceUnitTests.assertEquals((String)"FOO", (String)persistenceUnit.getDefaultCatalog());
        ormMappingFile.getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedCatalog(null);
        PersistenceUnitTests.assertFalse((boolean)ormMappingFile.getRoot().getPersistenceUnitMetadata().resourceExists());
        PersistenceUnitTests.assertEquals(null, (String)persistenceUnit.getDefaultCatalog());
        orm2MappingFile.getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedCatalog("BAR");
        PersistenceUnitTests.assertEquals((String)"BAR", (String)persistenceUnit.getDefaultCatalog());
    }

    protected void createOrm2XmlFile() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)"orm2.xml");
        config.getDefaultOperation().execute(null, null);
        this.addXmlMappingFileRef("META-INF/orm2.xml");
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    private ICompilationUnit createTestOtherTypeEntity() throws Exception {
        return this.createTestType("test", "OtherTestType.java", OTHER_TYPE_NAME, (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithPersistentInnerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendMemberTypeTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("     public static class InnerAnnotationTestType {}").append(CR);
            }
        });
    }

    public void testPersistentType() throws Exception {
        this.getJpaProject().setDiscoversAnnotatedClasses(false);
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        this.createTestEntity();
        PersistenceUnitTests.assertFalse((boolean)this.getJpaProject().discoversAnnotatedClasses());
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.getJpaProject().setDiscoversAnnotatedClasses(true);
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.getJpaProject().setDiscoversAnnotatedClasses(false);
        XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        classRef.setJavaClass("test.AnnotationTestType");
        this.getXmlPersistenceUnit().getClasses().add((Object)classRef);
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("test.AnnotationTestType"));
        this.addXmlMappingFileRef(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("model.Foo"));
        PersistenceUnitTests.assertEquals((Object)ormPersistentType, (Object)persistenceUnit.getPersistentType("model.Foo"));
        this.getXmlPersistenceUnit().getMappingFiles().remove(0);
        PersistenceUnitTests.assertNotNull((Object)persistenceUnit.getPersistentType("model.Foo"));
    }
}

