/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.JoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.jpa2.context.OverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.VirtualOverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.AssociationOverride2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaAssociationOverride2_0Tests
extends Generic2_0ContextModelTestCase {
    private static final String ASSOCIATION_OVERRIDE_NAME = "MY_ASSOCIATION_OVERRIDE_NAME";

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append(CR);
                sb.append("    private AnnotationTestTypeChild address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassManyToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany");
                sb.append(CR);
                sb.append("    private java.util.Collection<AnnotationTestTypeChild> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithAssociationOverride() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AssociationOverride"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@AssociationOverride(name=\"MY_ASSOCIATION_OVERRIDE_NAME\")");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public GenericJavaAssociationOverride2_0Tests(String name) {
        super(name);
    }

    public void testUpdateName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ReadOnlyAssociationOverride javaAssociationOverride = (ReadOnlyAssociationOverride)overrideContainer.virtualOverrides().next();
        javaAssociationOverride = ((VirtualAssociationOverride)javaAssociationOverride).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address", (String)javaAssociationOverride.getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address", (String)associationOverrideResource.getName());
        GenericJavaAssociationOverride2_0Tests.assertTrue((boolean)overrideContainer.overrides().hasNext());
        associationOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)javaAssociationOverride.getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
        associationOverrideResource.setName(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)0, (int)overrideContainer.specifiedOverridesSize());
        GenericJavaAssociationOverride2_0Tests.assertNull((Object)associationOverrideResource.getName());
        associationOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)1, (int)overrideContainer.specifiedOverridesSize());
        javaAssociationOverride = (ReadOnlyAssociationOverride)overrideContainer.specifiedOverrides().next();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)javaAssociationOverride.getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
        typeResource.removeAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)overrideContainer.specifiedOverrides().hasNext());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").hasNext());
    }

    public void testModifyName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.virtualOverrides().next();
        AssociationOverride specifiedAssociationOverride = virtualAssociationOverride.convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address", (String)specifiedAssociationOverride.getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address", (String)associationOverrideResource.getName());
        GenericJavaAssociationOverride2_0Tests.assertTrue((boolean)overrideContainer.overrides().hasNext());
        specifiedAssociationOverride.setName("foo");
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"foo", (String)specifiedAssociationOverride.getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"foo", (String)associationOverrideResource.getName());
        specifiedAssociationOverride.setName(null);
        GenericJavaAssociationOverride2_0Tests.assertNull((Object)specifiedAssociationOverride.getName());
        associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        GenericJavaAssociationOverride2_0Tests.assertNull((Object)associationOverrideResource.getName());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaAssociationOverride specifiedOverride = ((JavaVirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JoinColumnRelationshipStrategy joiningStrategy = specifiedOverride.getRelationship().getJoinColumnStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        JoinColumn joinColumn = joiningStrategy.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(0).getName());
        JoinColumn joinColumn2 = joiningStrategy.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(1).getName());
        JoinColumn joinColumn3 = joiningStrategy.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
        ListIterator joinColumns = joiningStrategy.specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((Object)joinColumn2, joinColumns.next());
        GenericJavaAssociationOverride2_0Tests.assertEquals((Object)joinColumn3, joinColumns.next());
        GenericJavaAssociationOverride2_0Tests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = joiningStrategy.specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaAssociationOverride javaAssociationOverride = ((JavaVirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JoinColumnRelationshipStrategy joiningStrategy = javaAssociationOverride.getRelationship().getJoinColumnStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)1, (int)associationOverrideResource.joinColumnsSize());
        joiningStrategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joiningStrategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joiningStrategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)4, (int)associationOverrideResource.joinColumnsSize());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)3, (int)associationOverrideResource.joinColumnsSize());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)2, (int)associationOverrideResource.joinColumnsSize());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(0).getName());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)1, (int)associationOverrideResource.joinColumnsSize());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)0, (int)associationOverrideResource.joinColumnsSize());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaAssociationOverride javaAssociationOverride = ((JavaVirtualAssociationOverride)overrideContainer.virtualOverrides().next()).convertToSpecified();
        JoinColumnRelationshipStrategy joiningStrategy = javaAssociationOverride.getRelationship().getJoinColumnStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        joiningStrategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joiningStrategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joiningStrategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)4, (int)associationOverrideResource.joinColumnsSize());
        joiningStrategy.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = joiningStrategy.specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
        joiningStrategy.moveSpecifiedJoinColumn(0, 1);
        joinColumns = joiningStrategy.specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(0).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(1).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        JavaVirtualAssociationOverride virtualAssociationOverride = (JavaVirtualAssociationOverride)overrideContainer.virtualOverrides().next();
        JavaAssociationOverride specifiedAssociationOverride = virtualAssociationOverride.convertToSpecified();
        JavaJoinColumnRelationshipStrategy joiningStrategy = specifiedAssociationOverride.getRelationship().getJoinColumnStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        ListIterator joinColumns = joiningStrategy.specifiedJoinColumns();
        JoinColumn joinColumn = (JoinColumn)joinColumns.next();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)joinColumn.getSpecifiedName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"id", (String)joinColumn.getSpecifiedReferencedColumnName());
        associationOverrideResource.addJoinColumn(0);
        associationOverrideResource.addJoinColumn(1);
        associationOverrideResource.addJoinColumn(2);
        associationOverrideResource.joinColumnAt(0).setName("FOO");
        associationOverrideResource.joinColumnAt(1).setName("BAR");
        associationOverrideResource.joinColumnAt(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.moveJoinColumn(2, 0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.moveJoinColumn(0, 1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((JavaJoinColumn)joinColumns.next()).getName());
        associationOverrideResource.removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joiningStrategy.specifiedJoinColumns().hasNext());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithAssociationOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)overrideContainer.specifiedOverrides().next();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)specifiedAssociationOverride.getName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        associationOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverride = (AssociationOverride)overrideContainer.specifiedOverrides().next();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)specifiedAssociationOverride.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithAssociationOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)overrideContainer.specifiedOverrides().next();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)specifiedAssociationOverride.getName());
        specifiedAssociationOverride.setName("FOO");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
    }

    public void testDefaultName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)1, (int)overrideContainer.virtualOverridesSize());
        ReadOnlyAssociationOverride associationOverride = (ReadOnlyAssociationOverride)overrideContainer.virtualOverrides().next();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"address", (String)associationOverride.getName());
    }

    public void testIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((int)1, (int)overrideContainer.virtualOverridesSize());
        ReadOnlyAssociationOverride associationOverride = (ReadOnlyAssociationOverride)overrideContainer.virtualOverrides().next();
        GenericJavaAssociationOverride2_0Tests.assertTrue((boolean)associationOverride.isVirtual());
    }

    public void testSetJoinTableName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ReadOnlyAssociationOverride javaAssociationOverride = (ReadOnlyAssociationOverride)overrideContainer.virtualOverrides().next();
        javaAssociationOverride = ((VirtualAssociationOverride)javaAssociationOverride).convertToSpecified();
        ((OverrideRelationship2_0)javaAssociationOverride.getRelationship()).setStrategyToJoinTable();
        JoinTableRelationshipStrategy joiningStrategy = ((OverrideRelationship2_0)javaAssociationOverride.getRelationship()).getJoinTableStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverride2_0Annotation associationOverrideResource = (AssociationOverride2_0Annotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        JoinTable joinTable = joiningStrategy.getJoinTable();
        joinTable.setSpecifiedName("FOO");
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)associationOverrideResource.getJoinTable().getName());
    }

    public void testUpdateJoinTable() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ReadOnlyAssociationOverride javaAssociationOverride = (ReadOnlyAssociationOverride)overrideContainer.virtualOverrides().next();
        javaAssociationOverride = ((VirtualAssociationOverride)javaAssociationOverride).convertToSpecified();
        ((OverrideRelationship2_0)javaAssociationOverride.getRelationship()).setStrategyToJoinTable();
        JoinTableRelationshipStrategy joiningStrategy = ((OverrideRelationship2_0)javaAssociationOverride.getRelationship()).getJoinTableStrategy();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestTypeChild");
        AssociationOverride2_0Annotation associationOverrideResource = (AssociationOverride2_0Annotation)typeResource.getAnnotation("javax.persistence.AssociationOverride");
        associationOverrideResource.getJoinTable().setName("MY_JOIN_TABLE");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)joiningStrategy.getJoinTable().getSpecifiedName());
        associationOverrideResource.getJoinTable().addJoinColumn(0);
        associationOverrideResource.getJoinTable().addJoinColumn(1);
        associationOverrideResource.getJoinTable().addJoinColumn(2);
        associationOverrideResource.getJoinTable().joinColumnAt(0).setName("FOO");
        associationOverrideResource.getJoinTable().joinColumnAt(1).setName("BAR");
        associationOverrideResource.getJoinTable().joinColumnAt(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumns = joiningStrategy.getJoinTable().specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.getJoinTable().moveJoinColumn(2, 0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.getJoinTable().specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.getJoinTable().moveJoinColumn(0, 1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.getJoinTable().specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.getJoinTable().removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.getJoinTable().specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.getJoinTable().removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.getJoinTable().specifiedJoinColumns();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.getJoinTable().removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaAssociationOverride2_0Tests.assertFalse((boolean)joiningStrategy.getJoinTable().specifiedJoinColumns().hasNext());
    }

    public void testDefaultJoinTableName() throws Exception {
        this.createTestMappedSuperclassManyToMany();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        ReadOnlyAssociationOverride javaAssociationOverride = (ReadOnlyAssociationOverride)overrideContainer.virtualOverrides().next();
        VirtualOverrideRelationship2_0 rel = (VirtualOverrideRelationship2_0)javaAssociationOverride.getRelationship();
        VirtualJoinTable joinTable = rel.getJoinTableStrategy().getJoinTable();
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"AnnotationTestTypeChild_AnnotationTestTypeChild", (String)joinTable.getName());
        this.getJavaEntity().getTable().setSpecifiedName("FOO");
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"FOO_FOO", (String)joinTable.getName());
        PersistentType mappedSuperclass = this.getJavaEntity().getPersistentType().getSuperPersistentType();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)mappedSuperclass.getAttributeNamed("address").getMapping();
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("BAR");
        GenericJavaAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)joinTable.getName());
    }
}

