/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa2.Generic2_0JpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.SequenceGenerator2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class SequenceGenerator2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    private static final String GENERATOR_CATALOG = "TEST_CATALOG";
    private static final String GENERATOR_SCHEMA = "TEST_SCHEMA";

    public SequenceGenerator2_0AnnotationTests(String name) {
        super(name);
    }

    protected JpaAnnotationDefinitionProvider annotationDefinitionProvider() {
        return Generic2_0JpaAnnotationDefinitionProvider.instance();
    }

    public void testGetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithCatalog();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        SequenceGenerator2_0Annotation sequenceGenerator = (SequenceGenerator2_0Annotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)GENERATOR_CATALOG, (String)sequenceGenerator.getCatalog());
    }

    public void testSetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithCatalog();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        SequenceGenerator2_0Annotation sequenceGenerator = (SequenceGenerator2_0Annotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)GENERATOR_CATALOG, (String)sequenceGenerator.getCatalog());
        sequenceGenerator.setCatalog("foo");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)"foo", (String)sequenceGenerator.getCatalog());
        this.assertSourceContains("@SequenceGenerator(catalog = \"foo\")", cu);
        sequenceGenerator.setCatalog(null);
        SequenceGenerator2_0AnnotationTests.assertNull((Object)sequenceGenerator.getCatalog());
        this.assertSourceDoesNotContain("@SequenceGenerator(", cu);
    }

    public void testGetSchema() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithSchema();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        SequenceGenerator2_0Annotation sequenceGenerator = (SequenceGenerator2_0Annotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)GENERATOR_SCHEMA, (String)sequenceGenerator.getSchema());
    }

    public void testSetSchema() throws Exception {
        ICompilationUnit cu = this.createTestSequenceGeneratorWithSchema();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        SequenceGenerator2_0Annotation sequenceGenerator = (SequenceGenerator2_0Annotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)GENERATOR_SCHEMA, (String)sequenceGenerator.getSchema());
        sequenceGenerator.setSchema("foo");
        SequenceGenerator2_0AnnotationTests.assertEquals((String)"foo", (String)sequenceGenerator.getSchema());
        this.assertSourceContains("@SequenceGenerator(schema = \"foo\")", cu);
        sequenceGenerator.setSchema(null);
        SequenceGenerator2_0AnnotationTests.assertNull((Object)sequenceGenerator.getSchema());
        this.assertSourceDoesNotContain("@SequenceGenerator(", cu);
    }

    protected ICompilationUnit createTestSequenceGeneratorWithStringElement(final String elementName, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.SequenceGenerator"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@SequenceGenerator(" + elementName + " = \"" + value + "\")");
            }
        });
    }

    private ICompilationUnit createTestSequenceGeneratorWithCatalog() throws Exception {
        return this.createTestSequenceGeneratorWithStringElement("catalog", GENERATOR_CATALOG);
    }

    private ICompilationUnit createTestSequenceGeneratorWithSchema() throws Exception {
        return this.createTestSequenceGeneratorWithStringElement("schema", GENERATOR_SCHEMA);
    }
}

