/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.platform;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.jpa.core.tests.internal.projects.TestJpaProject;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JpaPlatformExtensionTests
extends ContextModelTestCase {
    public static final String TEST_PLATFORM_ID = "core.testJpaPlatform";
    public static final JpaPlatformDescription TEST_PLATFORM_DESC = JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform("core.testJpaPlatform");
    public static final String TEST_PLATFORM_LABEL = "Test Jpa Platform";
    protected TestJpaProject testProject;

    public JpaPlatformExtensionTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JpaPlatformExtensionTests.verifyExtensionTestProjectExists();
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return super.buildJpaProject("AnnotationTestProject", autoBuild, this.buildConfig());
    }

    protected IDataModel buildConfig() throws Exception {
        JpaFacetInstallDataModelProvider configFactory = new JpaFacetInstallDataModelProvider();
        IDataModel config = (IDataModel)configFactory.create();
        config.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)JpaFacet.VERSION_1_0.getVersionString());
        config.setProperty("JpaFacetDataModelProperties.PLATFORM", (Object)TEST_PLATFORM_DESC);
        return config;
    }

    public static void verifyExtensionTestProjectExists() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.jpt.jpa.core", "jpaPlatform");
        IExtension[] extensions = extensionPoint.getExtensions();
        boolean extensionFound = false;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getContributor().getName().equals("org.eclipse.jpt.jpa.core.tests.extension.resource")) {
                extensionFound = true;
            }
            ++n2;
        }
        if (!extensionFound) {
            throw new RuntimeException("Missing Extension core.testJpaPlatform. The ExtensionTestProject plugin must be in your testing workspace.");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAllJpaPlatformIds() {
        JpaPlatformExtensionTests.assertTrue((CollectionTools.size((Iterable)JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatforms()) >= 2 ? 1 : 0) != 0);
    }

    public void testJpaPlatformLabel() {
        JpaPlatformExtensionTests.assertEquals((String)TEST_PLATFORM_LABEL, (String)JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform(TEST_PLATFORM_ID).getLabel());
    }

    public void testJpaPlatform() {
        JpaPlatformExtensionTests.assertNotNull((Object)JptJpaCorePlugin.getJpaPlatformManager().buildJpaPlatformImplementation(this.testProject.getProject()));
    }
}

