/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class DiscriminatorColumnTests
extends JpaJavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";

    public DiscriminatorColumnTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestDiscriminatorColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.DiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@DiscriminatorColumn");
            }
        });
    }

    private ICompilationUnit createTestDiscriminatorColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.DiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@DiscriminatorColumn(name = \"MY_COLUMN\")");
            }
        });
    }

    private ICompilationUnit createTestDiscriminatorColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.DiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@DiscriminatorColumn(columnDefinition = \"COLUMN_DEFINITION\")");
            }
        });
    }

    private ICompilationUnit createTestDiscriminatorColumnWithDiscriminatorType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.DiscriminatorColumn", "javax.persistence.DiscriminatorType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@DiscriminatorColumn(discriminatorType = DiscriminatorType.CHAR)");
            }
        });
    }

    private ICompilationUnit createTestColumnWithIntElement(final String intElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.DiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@DiscriminatorColumn(" + intElement + " = 5)");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        DiscriminatorColumnTests.assertNotNull((Object)column);
        DiscriminatorColumnTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        DiscriminatorColumnTests.assertNotNull((Object)column);
        DiscriminatorColumnTests.assertNull((Object)column.getName());
        DiscriminatorColumnTests.assertNull((Object)column.getDiscriminatorType());
        DiscriminatorColumnTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        DiscriminatorColumnTests.assertNotNull((Object)column);
        DiscriminatorColumnTests.assertNull((Object)column.getName());
        column.setName("Foo");
        DiscriminatorColumnTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@DiscriminatorColumn(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        DiscriminatorColumnTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        DiscriminatorColumnTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("(name", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorColumnWithColumnDefinition();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        DiscriminatorColumnTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        DiscriminatorColumnTests.assertNotNull((Object)column);
        DiscriminatorColumnTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        DiscriminatorColumnTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@DiscriminatorColumn(columnDefinition = \"Foo\")", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("(columnDefinition", cu);
    }

    public void testGetLength() throws Exception {
        ICompilationUnit cu = this.createTestColumnWithIntElement("length");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        DiscriminatorColumnTests.assertEquals((Object)5, (Object)column.getLength());
    }

    public void testSetLength() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        DiscriminatorColumnTests.assertNotNull((Object)column);
        DiscriminatorColumnTests.assertNull((Object)column.getLength());
        column.setLength(Integer.valueOf(5));
        DiscriminatorColumnTests.assertEquals((Object)5, (Object)column.getLength());
        this.assertSourceContains("@DiscriminatorColumn(length = 5)", cu);
        column.setLength(null);
        this.assertSourceDoesNotContain("(length", cu);
    }

    public void testGetDiscriminatorType() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorColumnWithDiscriminatorType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        DiscriminatorColumnTests.assertEquals((Object)DiscriminatorType.CHAR, (Object)column.getDiscriminatorType());
    }

    public void testSetDiscriminatorType() throws Exception {
        ICompilationUnit cu = this.createTestDiscriminatorColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        DiscriminatorColumnTests.assertNull((Object)column.getDiscriminatorType());
        column.setDiscriminatorType(DiscriminatorType.INTEGER);
        DiscriminatorColumnTests.assertEquals((Object)DiscriminatorType.INTEGER, (Object)column.getDiscriminatorType());
        this.assertSourceContains("@DiscriminatorColumn(discriminatorType = INTEGER)", cu);
        column.setDiscriminatorType(null);
        this.assertSourceDoesNotContain("(discriminatorType", cu);
    }
}

